/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import fit.Fixture;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smartrics.rest.fitnesse.fixture.support.Config;

public abstract class Variables {
    public static final Pattern VARIABLES_PATTERN = Pattern.compile("\\%([a-zA-Z0-9_]+)\\%");
    private static final String FIT_NULL_VALUE = Variables.fitSymbolForNull();
    private String nullValue = "null";

    Variables() {
        this(Config.getConfig());
    }

    Variables(Config c) {
        if (c != null) {
            this.nullValue = c.get("restfixture.null.value.representation", "null");
        }
    }

    public abstract void put(String var1, String var2);

    public abstract String get(String var1);

    public final String substitute(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = VARIABLES_PATTERN.matcher(text);
        HashMap<String, String> replacements = new HashMap<String, String>();
        while (m.find()) {
            int gc = m.groupCount();
            if (gc != 1) continue;
            String g0 = m.group(0);
            String g1 = m.group(1);
            String value = this.get(g1);
            if (FIT_NULL_VALUE.equals(value)) {
                value = this.nullValue;
            }
            replacements.put(g0, value);
        }
        String newText = text;
        for (Map.Entry en : replacements.entrySet()) {
            String k = (String)en.getKey();
            String replacement = (String)replacements.get(k);
            if (replacement == null) continue;
            newText = newText.replaceAll(k, replacement);
        }
        return newText;
    }

    private static String fitSymbolForNull() {
        String k = "somerandomvaluetogettherepresentationofnull-1234567890";
        Fixture.setSymbol((String)"somerandomvaluetogettherepresentationofnull-1234567890", null);
        return Fixture.getSymbol((String)"somerandomvaluetogettherepresentationofnull-1234567890").toString();
    }

    public final String replaceNull(String s) {
        if (s == null) {
            return this.nullValue;
        }
        return s;
    }
}

