/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support.http;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpMethodParams;

class URIBuilder {
    URIBuilder() {
    }

    public URI getURI(String scheme, String host, int port, String path, String queryString, HttpMethodParams params) throws URIException {
        HttpHost httphost = new HttpHost(host, port);
        StringBuffer buffer = new StringBuffer();
        if (httphost != null) {
            buffer.append(httphost.getProtocol().getScheme());
            buffer.append("://");
            buffer.append(httphost.getHostName());
            int p = httphost.getPort();
            if (p != -1 && p != httphost.getProtocol().getDefaultPort()) {
                buffer.append(":");
                buffer.append(p);
            }
        }
        buffer.append(path);
        if (queryString != null) {
            buffer.append('?');
            buffer.append(queryString);
        }
        String charset = params.getUriCharset();
        return new HttpURL(buffer.toString(), charset);
    }

    public void setURI(HttpMethodBase m, URI uri) throws URIException {
        HostConfiguration conf = m.getHostConfiguration();
        if (uri.isAbsoluteURI()) {
            conf.setHost(new HttpHost(uri));
            m.setHostConfiguration(conf);
        }
        m.setPath(uri.getPath() != null ? uri.getEscapedPath() : "/");
        m.setQueryString(uri.getQuery());
    }

    public static URI newURI(HttpMethod m, HostConfiguration conf) throws URIException {
        String scheme = conf.getProtocol().getScheme();
        String host = conf.getHost();
        int port = conf.getPort();
        return new URIBuilder().getURI(scheme, host, port, m.getPath(), m.getQueryString(), m.getParams());
    }
}

