/*
 * Decompiled with CFR 0.152.
 */
package so.prelude.android.sdk;

import android.content.Context;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import so.prelude.android.sdk.Endpoint;
import so.prelude.android.sdk.PreludeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J1\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011\u00a8\u0006*"}, d2={"Lso/prelude/android/sdk/Configuration;", "", "context", "Landroid/content/Context;", "sdkKey", "", "endpoint", "Lso/prelude/android/sdk/Endpoint;", "requestTimeout", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;Lso/prelude/android/sdk/Endpoint;J)V", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "getSdkKey", "()Ljava/lang/String;", "setSdkKey", "(Ljava/lang/String;)V", "getEndpoint", "()Lso/prelude/android/sdk/Endpoint;", "setEndpoint", "(Lso/prelude/android/sdk/Endpoint;)V", "getRequestTimeout", "()J", "setRequestTimeout", "(J)V", "endpointAddress", "getEndpointAddress", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "sdk_release"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Context context;
    @NotNull
    private String sdkKey;
    @NotNull
    private Endpoint endpoint;
    private long requestTimeout;
    public static final long DEFAULT_REQUEST_TIMEOUT = 2000L;

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint, long requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.context = context;
        this.sdkKey = sdkKey;
        this.endpoint = endpoint;
        this.requestTimeout = requestTimeout;
    }

    public /* synthetic */ Configuration(Context context, String string, Endpoint endpoint, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            endpoint = Endpoint.Default.INSTANCE;
        }
        if ((n & 8) != 0) {
            l = 2000L;
        }
        this(context, string, endpoint, l);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final String getSdkKey() {
        return this.sdkKey;
    }

    public final void setSdkKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sdkKey = string;
    }

    @NotNull
    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    public final void setEndpoint(@NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"<set-?>");
        this.endpoint = endpoint;
    }

    public final long getRequestTimeout() {
        return this.requestTimeout;
    }

    public final void setRequestTimeout(long l) {
        this.requestTimeout = l;
    }

    @NotNull
    public final String getEndpointAddress() {
        String string;
        Endpoint endpoint = this.endpoint;
        if (endpoint instanceof Endpoint.Default) {
            string = PreludeKt.defaultEndpoint();
        } else if (endpoint instanceof Endpoint.Custom) {
            Endpoint endpoint2 = this.endpoint;
            Intrinsics.checkNotNull((Object)endpoint2, (String)"null cannot be cast to non-null type so.prelude.android.sdk.Endpoint.Custom");
            string = ((Endpoint.Custom)endpoint2).getAddress();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final Context component1() {
        return this.context;
    }

    @NotNull
    public final String component2() {
        return this.sdkKey;
    }

    @NotNull
    public final Endpoint component3() {
        return this.endpoint;
    }

    public final long component4() {
        return this.requestTimeout;
    }

    @NotNull
    public final Configuration copy(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint, long requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return new Configuration(context, sdkKey, endpoint, requestTimeout);
    }

    public static /* synthetic */ Configuration copy$default(Configuration configuration, Context context, String string, Endpoint endpoint, long l, int n, Object object) {
        if ((n & 1) != 0) {
            context = configuration.context;
        }
        if ((n & 2) != 0) {
            string = configuration.sdkKey;
        }
        if ((n & 4) != 0) {
            endpoint = configuration.endpoint;
        }
        if ((n & 8) != 0) {
            l = configuration.requestTimeout;
        }
        return configuration.copy(context, string, endpoint, l);
    }

    @NotNull
    public String toString() {
        return "Configuration(context=" + this.context + ", sdkKey=" + this.sdkKey + ", endpoint=" + this.endpoint + ", requestTimeout=" + this.requestTimeout + ')';
    }

    public int hashCode() {
        int result = this.context.hashCode();
        result = result * 31 + this.sdkKey.hashCode();
        result = result * 31 + this.endpoint.hashCode();
        result = result * 31 + Long.hashCode(this.requestTimeout);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)configuration.context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sdkKey, (Object)configuration.sdkKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endpoint, (Object)configuration.endpoint)) {
            return false;
        }
        return this.requestTimeout == configuration.requestTimeout;
    }

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this(context, sdkKey, endpoint, 0L, 8, null);
    }

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        this(context, sdkKey, null, 0L, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lso/prelude/android/sdk/Configuration$Companion;", "", "<init>", "()V", "DEFAULT_REQUEST_TIMEOUT", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

