/*
 * Decompiled with CFR 0.152.
 */
package so.prelude.android.sdk.request;

import android.net.Network;
import java.net.URL;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import so.prelude.android.sdk.request.NetworkResponse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lso/prelude/android/sdk/request/Request;", "", "url", "Ljava/net/URL;", "method", "", "headers", "", "body", "", "timeout", "", "<init>", "(Ljava/net/URL;Ljava/lang/String;Ljava/util/Map;[BJ)V", "send", "Lso/prelude/android/sdk/request/NetworkResponse;", "network", "Landroid/net/Network;", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\nso/prelude/android/sdk/request/Request\n+ 2 OkHttpClient.kt\nokhttp3/OkHttpClient$Builder\n*L\n1#1,71:1\n578#2:72\n*S KotlinDebug\n*F\n+ 1 Request.kt\nso/prelude/android/sdk/request/Request\n*L\n38#1:72\n*E\n"})
public final class Request {
    @NotNull
    private final URL url;
    @NotNull
    private final String method;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private final byte[] body;
    private final long timeout;

    public Request(@NotNull URL url, @NotNull String method, @NotNull Map<String, String> headers, @Nullable byte[] body, long timeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
        this.timeout = timeout;
    }

    public /* synthetic */ Request(URL uRL, String string, Map map, byte[] byArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "GET";
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            byArray = null;
        }
        if ((n & 0x10) != 0) {
            l = 2000L;
        }
        this(uRL, string, map, byArray, l);
    }

    @NotNull
    public final NetworkResponse send(@NotNull Network network) {
        NetworkResponse networkResponse;
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(this.timeout, TimeUnit.MILLISECONDS);
        SocketFactory socketFactory = network.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)socketFactory, (String)"getSocketFactory(...)");
        OkHttpClient.Builder this_$iv = builder.socketFactory(socketFactory);
        boolean bl = false;
        OkHttpClient.Builder clientBuilder = this_$iv.addNetworkInterceptor(new Interceptor(this){
            final /* synthetic */ Request this$0;
            {
                this.this$0 = request;
            }

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Request.Builder builder = chain2.request().newBuilder();
                String string = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                Request.Builder builder2 = builder.header("X-SDK-Request-Date", string);
                for (Map.Entry<K, V> entry : Request.access$getHeaders$p(this.this$0).entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    builder2.header(key, value);
                }
                return chain2.proceed(builder2.build());
            }
        });
        OkHttpClient client = clientBuilder.build();
        okhttp3.Request request = new Request.Builder().url(this.url).method(this.method, this.body != null ? RequestBody.Companion.create(this.body, null, 0, this.body.length) : null).build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            networkResponse = new NetworkResponse.Success(response.code(), (byte[])(responseBody != null ? responseBody.bytes() : null));
        } else {
            networkResponse = new NetworkResponse.Error(response.code());
        }
        return networkResponse;
    }

    public static final /* synthetic */ Map access$getHeaders$p(Request $this) {
        return $this.headers;
    }
}

