/*
 * Decompiled with CFR 0.152.
 */
package so.prelude.android.sdk;

import android.content.Context;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import so.prelude.android.sdk.Endpoint;
import so.prelude.android.sdk.Features;
import so.prelude.android.sdk.PreludeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b$\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010/\u001a\u00020\fH\u00c6\u0003J\t\u00100\u001a\u00020\u000eH\u00c6\u0003JK\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u00020\u000eH\u00d6\u0001J\t\u00106\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0016\u00a8\u00068"}, d2={"Lso/prelude/android/sdk/Configuration;", "", "context", "Landroid/content/Context;", "sdkKey", "", "endpoint", "Lso/prelude/android/sdk/Endpoint;", "implementedFeatures", "", "Lso/prelude/android/sdk/Features;", "requestTimeout", "", "maxRetries", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;Lso/prelude/android/sdk/Endpoint;Ljava/util/List;JI)V", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "getSdkKey", "()Ljava/lang/String;", "setSdkKey", "(Ljava/lang/String;)V", "getEndpoint", "()Lso/prelude/android/sdk/Endpoint;", "setEndpoint", "(Lso/prelude/android/sdk/Endpoint;)V", "getImplementedFeatures", "()Ljava/util/List;", "setImplementedFeatures", "(Ljava/util/List;)V", "getRequestTimeout", "()J", "setRequestTimeout", "(J)V", "getMaxRetries", "()I", "setMaxRetries", "(I)V", "endpointAddress", "getEndpointAddress", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "sdk_release"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Context context;
    @NotNull
    private String sdkKey;
    @NotNull
    private Endpoint endpoint;
    @NotNull
    private List<? extends Features> implementedFeatures;
    private long requestTimeout;
    private int maxRetries;
    public static final long DEFAULT_REQUEST_TIMEOUT = 2000L;
    public static final int DEFAULT_MAX_RETRY_COUNT = 0;

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint, @NotNull List<? extends Features> implementedFeatures, long requestTimeout, int maxRetries) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(implementedFeatures, (String)"implementedFeatures");
        this.context = context;
        this.sdkKey = sdkKey;
        this.endpoint = endpoint;
        this.implementedFeatures = implementedFeatures;
        this.requestTimeout = requestTimeout;
        this.maxRetries = maxRetries;
    }

    public /* synthetic */ Configuration(Context context, String string, Endpoint endpoint, List list, long l, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            endpoint = Endpoint.Default.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x10) != 0) {
            l = 2000L;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        this(context, string, endpoint, list, l, n);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final String getSdkKey() {
        return this.sdkKey;
    }

    public final void setSdkKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sdkKey = string;
    }

    @NotNull
    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    public final void setEndpoint(@NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"<set-?>");
        this.endpoint = endpoint;
    }

    @NotNull
    public final List<Features> getImplementedFeatures() {
        return this.implementedFeatures;
    }

    public final void setImplementedFeatures(@NotNull List<? extends Features> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.implementedFeatures = list;
    }

    public final long getRequestTimeout() {
        return this.requestTimeout;
    }

    public final void setRequestTimeout(long l) {
        this.requestTimeout = l;
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    @NotNull
    public final String getEndpointAddress() {
        String string;
        Endpoint endpoint = this.endpoint;
        if (endpoint instanceof Endpoint.Default) {
            string = PreludeKt.defaultEndpoint();
        } else if (endpoint instanceof Endpoint.Custom) {
            Endpoint endpoint2 = this.endpoint;
            Intrinsics.checkNotNull((Object)endpoint2, (String)"null cannot be cast to non-null type so.prelude.android.sdk.Endpoint.Custom");
            string = ((Endpoint.Custom)endpoint2).getAddress();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final Context component1() {
        return this.context;
    }

    @NotNull
    public final String component2() {
        return this.sdkKey;
    }

    @NotNull
    public final Endpoint component3() {
        return this.endpoint;
    }

    @NotNull
    public final List<Features> component4() {
        return this.implementedFeatures;
    }

    public final long component5() {
        return this.requestTimeout;
    }

    public final int component6() {
        return this.maxRetries;
    }

    @NotNull
    public final Configuration copy(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint, @NotNull List<? extends Features> implementedFeatures, long requestTimeout, int maxRetries) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(implementedFeatures, (String)"implementedFeatures");
        return new Configuration(context, sdkKey, endpoint, implementedFeatures, requestTimeout, maxRetries);
    }

    public static /* synthetic */ Configuration copy$default(Configuration configuration, Context context, String string, Endpoint endpoint, List list, long l, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            context = configuration.context;
        }
        if ((n2 & 2) != 0) {
            string = configuration.sdkKey;
        }
        if ((n2 & 4) != 0) {
            endpoint = configuration.endpoint;
        }
        if ((n2 & 8) != 0) {
            list = configuration.implementedFeatures;
        }
        if ((n2 & 0x10) != 0) {
            l = configuration.requestTimeout;
        }
        if ((n2 & 0x20) != 0) {
            n = configuration.maxRetries;
        }
        return configuration.copy(context, string, endpoint, list, l, n);
    }

    @NotNull
    public String toString() {
        return "Configuration(context=" + this.context + ", sdkKey=" + this.sdkKey + ", endpoint=" + this.endpoint + ", implementedFeatures=" + this.implementedFeatures + ", requestTimeout=" + this.requestTimeout + ", maxRetries=" + this.maxRetries + ')';
    }

    public int hashCode() {
        int result = this.context.hashCode();
        result = result * 31 + this.sdkKey.hashCode();
        result = result * 31 + this.endpoint.hashCode();
        result = result * 31 + ((Object)this.implementedFeatures).hashCode();
        result = result * 31 + Long.hashCode(this.requestTimeout);
        result = result * 31 + Integer.hashCode(this.maxRetries);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)configuration.context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sdkKey, (Object)configuration.sdkKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endpoint, (Object)configuration.endpoint)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.implementedFeatures, configuration.implementedFeatures)) {
            return false;
        }
        if (this.requestTimeout != configuration.requestTimeout) {
            return false;
        }
        return this.maxRetries == configuration.maxRetries;
    }

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint, @NotNull List<? extends Features> implementedFeatures, long requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(implementedFeatures, (String)"implementedFeatures");
        this(context, sdkKey, endpoint, implementedFeatures, requestTimeout, 0, 32, null);
    }

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint, @NotNull List<? extends Features> implementedFeatures) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(implementedFeatures, (String)"implementedFeatures");
        this(context, sdkKey, endpoint, implementedFeatures, 0L, 0, 48, null);
    }

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey, @NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this(context, sdkKey, endpoint, null, 0L, 0, 56, null);
    }

    @JvmOverloads
    public Configuration(@NotNull Context context, @NotNull String sdkKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        this(context, sdkKey, null, null, 0L, 0, 60, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lso/prelude/android/sdk/Configuration$Companion;", "", "<init>", "()V", "DEFAULT_REQUEST_TIMEOUT", "", "DEFAULT_MAX_RETRY_COUNT", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

