/*
 * Decompiled with CFR 0.152.
 */
package so.prelude.android.sdk.signals.families;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.fonts.Font;
import android.graphics.fonts.SystemFonts;
import android.os.Build;
import android.os.LocaleList;
import android.os.SystemClock;
import android.provider.Settings;
import android.system.Os;
import android.system.StructUtsname;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import so.prelude.android.sdk.BatteryState;
import so.prelude.android.sdk.Device;
import so.prelude.android.sdk.Platform;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005\u00b2\u0006\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u008a\u0084\u0002\u00b2\u0006\f\u0010\b\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\n\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u000b\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\f\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\r\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u000e\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u000f\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\u000e\u0010\u0010\u001a\u0004\u0018\u00010\t8\nX\u008b\u0084\u0002\u00b2\u0006\f\u0010\u0011\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u0012\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\u0012\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014X\u008a\u0084\u0002\u00b2\u0006\f\u0010\u0015\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u008a\u0084\u0002\u00b2\u0006\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u008a\u0084\u0002\u00b2\u0006\f\u0010\u001a\u001a\u0004\u0018\u00010\tX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u008a\u0084\u0002"}, d2={"collect", "Lso/prelude/android/sdk/Device;", "Lso/prelude/android/sdk/Device$Companion;", "context", "Landroid/content/Context;", "sdk_release", "bootTime", "Ljava/time/Instant;", "hostname", "", "kernelVersion", "osBuild", "osRelease", "osType", "systemName", "systemVersion", "vendorID", "name", "localeCurrent", "localePreferred", "", "timeZoneCurrent", "batteryLevel", "", "batteryState", "Lso/prelude/android/sdk/BatteryState;", "fontsDigest", "simulator", ""})
@SourceDebugExtension(value={"SMAP\nDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Device.kt\nso/prelude/android/sdk/signals/families/DeviceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1557#2:186\n1628#2,3:187\n*S KotlinDebug\n*F\n+ 1 Device.kt\nso/prelude/android/sdk/signals/families/DeviceKt\n*L\n76#1:186\n76#1:187,3\n*E\n"})
public final class DeviceKt {
    @NotNull
    public static final Device collect(@NotNull Device.Companion $this$collect, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$collect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StructUtsname uname = Os.uname();
        Intent batteryStatus = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        Lazy bootTime$delegate = LazyKt.lazy(DeviceKt::collect$lambda$0);
        Lazy hostname$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$2(uname));
        Lazy kernelVersion$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$4(uname));
        Lazy osBuild$delegate = LazyKt.lazy(DeviceKt::collect$lambda$6);
        Lazy osRelease$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$8(uname));
        Lazy osType$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$10(uname));
        Lazy systemName$delegate = LazyKt.lazy(DeviceKt::collect$lambda$12);
        Lazy systemVersion$delegate = LazyKt.lazy(DeviceKt::collect$lambda$14);
        Lazy vendorID$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$16(context));
        Lazy name$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$18(context));
        Lazy localeCurrent$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$20(context));
        Lazy localePreferred$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$23(context));
        Lazy timeZoneCurrent$delegate = LazyKt.lazy(DeviceKt::collect$lambda$25);
        Lazy batteryLevel$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$27(batteryStatus));
        Lazy batteryState$delegate = LazyKt.lazy(() -> DeviceKt.collect$lambda$29(batteryStatus));
        Lazy fontsDigest$delegate = LazyKt.lazy(DeviceKt::collect$lambda$32);
        Lazy simulator$delegate = LazyKt.lazy(DeviceKt::collect$lambda$34);
        return new Device(Platform.ANDROID, DeviceKt.collect$lambda$1((Lazy<Instant>)bootTime$delegate), DeviceKt.collect$lambda$3((Lazy<String>)hostname$delegate), DeviceKt.collect$lambda$5((Lazy<String>)kernelVersion$delegate), DeviceKt.collect$lambda$7((Lazy<String>)osBuild$delegate), DeviceKt.collect$lambda$9((Lazy<String>)osRelease$delegate), DeviceKt.collect$lambda$11((Lazy<String>)osType$delegate), DeviceKt.collect$lambda$13((Lazy<String>)systemName$delegate), DeviceKt.collect$lambda$15((Lazy<String>)systemVersion$delegate), DeviceKt.collect$lambda$17((Lazy<String>)vendorID$delegate), DeviceKt.collect$lambda$19((Lazy<String>)name$delegate), DeviceKt.collect$lambda$21((Lazy<String>)localeCurrent$delegate), DeviceKt.collect$lambda$24((Lazy<? extends List<String>>)localePreferred$delegate), DeviceKt.collect$lambda$26((Lazy<String>)timeZoneCurrent$delegate), DeviceKt.collect$lambda$28((Lazy<Float>)batteryLevel$delegate), DeviceKt.collect$lambda$30((Lazy<? extends BatteryState>)batteryState$delegate), DeviceKt.collect$lambda$33((Lazy<String>)fontsDigest$delegate), DeviceKt.collect$lambda$35((Lazy<Boolean>)simulator$delegate));
    }

    private static final Instant collect$lambda$0() {
        return Instant.ofEpochMilli(System.currentTimeMillis() - SystemClock.elapsedRealtime());
    }

    private static final Instant collect$lambda$1(Lazy<Instant> $bootTime$delegate) {
        Lazy<Instant> lazy = $bootTime$delegate;
        return (Instant)lazy.getValue();
    }

    private static final String collect$lambda$2(StructUtsname $uname) {
        return $uname.nodename;
    }

    private static final String collect$lambda$3(Lazy<String> $hostname$delegate) {
        Lazy<String> lazy = $hostname$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$4(StructUtsname $uname) {
        return $uname.version;
    }

    private static final String collect$lambda$5(Lazy<String> $kernelVersion$delegate) {
        Lazy<String> lazy = $kernelVersion$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$6() {
        return null;
    }

    private static final String collect$lambda$7(Lazy<String> $osBuild$delegate) {
        Lazy<String> lazy = $osBuild$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$8(StructUtsname $uname) {
        return $uname.release;
    }

    private static final String collect$lambda$9(Lazy<String> $osRelease$delegate) {
        Lazy<String> lazy = $osRelease$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$10(StructUtsname $uname) {
        return $uname.sysname;
    }

    private static final String collect$lambda$11(Lazy<String> $osType$delegate) {
        Lazy<String> lazy = $osType$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$12() {
        return "Android";
    }

    private static final String collect$lambda$13(Lazy<String> $systemName$delegate) {
        Lazy<String> lazy = $systemName$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$14() {
        return Build.VERSION.RELEASE;
    }

    private static final String collect$lambda$15(Lazy<String> $systemVersion$delegate) {
        Lazy<String> lazy = $systemVersion$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$16(Context $context) {
        return Settings.Secure.getString((ContentResolver)$context.getContentResolver(), (String)"android_id");
    }

    private static final String collect$lambda$17(Lazy<String> $vendorID$delegate) {
        Lazy<String> lazy = $vendorID$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$18(Context $context) {
        return Settings.Global.getString((ContentResolver)$context.getContentResolver(), (String)"device_name");
    }

    private static final String collect$lambda$19(Lazy<String> $name$delegate) {
        Lazy<String> lazy = $name$delegate;
        return (String)lazy.getValue();
    }

    private static final String collect$lambda$20(Context $context) {
        return $context.getResources().getConfiguration().getLocales().get(0).toString();
    }

    private static final String collect$lambda$21(Lazy<String> $localeCurrent$delegate) {
        Lazy<String> lazy = $localeCurrent$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List collect$lambda$23(Context $context) {
        void $this$mapTo$iv$iv;
        LocaleList localeList = $context.getResources().getConfiguration().getLocales();
        Intrinsics.checkNotNullExpressionValue((Object)localeList, (String)"getLocales(...)");
        LocaleList configurationLocales = localeList;
        List locales = new ArrayList();
        int n = configurationLocales.size();
        for (int i = 0; i < n; ++i) {
            Locale locale = configurationLocales.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"get(...)");
            locales.add(locale);
        }
        Iterable $this$map$iv = locales;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private static final List<String> collect$lambda$24(Lazy<? extends List<String>> $localePreferred$delegate) {
        Lazy<? extends List<String>> lazy = $localePreferred$delegate;
        return (List)lazy.getValue();
    }

    private static final String collect$lambda$25() {
        return TimeZone.getDefault().getID();
    }

    private static final String collect$lambda$26(Lazy<String> $timeZoneCurrent$delegate) {
        Lazy<String> lazy = $timeZoneCurrent$delegate;
        return (String)lazy.getValue();
    }

    private static final Float collect$lambda$27(Intent $batteryStatus) {
        int scale;
        Intent intent = $batteryStatus;
        int level = intent != null ? intent.getIntExtra("level", -1) : -1;
        Intent intent2 = $batteryStatus;
        int n = scale = intent2 != null ? intent2.getIntExtra("scale", -1) : -1;
        return (0 <= level ? level <= scale : false) ? Float.valueOf((float)level / (float)scale) : null;
    }

    private static final Float collect$lambda$28(Lazy<Float> $batteryLevel$delegate) {
        Lazy<Float> lazy = $batteryLevel$delegate;
        return (Float)lazy.getValue();
    }

    private static final BatteryState collect$lambda$29(Intent $batteryStatus) {
        BatteryState batteryState;
        Intent intent = $batteryStatus;
        int status = intent != null ? intent.getIntExtra("status", -1) : -1;
        switch (status) {
            case 2: {
                batteryState = BatteryState.CHARGING;
                break;
            }
            case 3: {
                batteryState = BatteryState.UNPLUGGED;
                break;
            }
            case 5: {
                batteryState = BatteryState.FULL;
                break;
            }
            case 4: {
                batteryState = BatteryState.UNPLUGGED;
                break;
            }
            case 1: {
                batteryState = BatteryState.UNKNOWN;
                break;
            }
            default: {
                batteryState = null;
            }
        }
        return batteryState;
    }

    private static final BatteryState collect$lambda$30(Lazy<? extends BatteryState> $batteryState$delegate) {
        Lazy<? extends BatteryState> lazy = $batteryState$delegate;
        return (BatteryState)lazy.getValue();
    }

    private static final CharSequence collect$lambda$32$lambda$31(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String collect$lambda$32() {
        String string;
        if (Build.VERSION.SDK_INT >= 29) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (Font font : SystemFonts.getAvailableFonts()) {
                md.update(font.getBuffer());
            }
            byte[] byArray = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            string = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, DeviceKt::collect$lambda$32$lambda$31, (int)30, null);
        } else {
            string = null;
        }
        return string;
    }

    private static final String collect$lambda$33(Lazy<String> $fontsDigest$delegate) {
        Lazy<String> lazy = $fontsDigest$delegate;
        return (String)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collect$lambda$34() {
        block9: {
            block10: {
                if (!Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)"Google") || !Intrinsics.areEqual((Object)Build.BRAND, (Object)"google")) break block9;
                String string = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)string, (String)"google/sdk_gphone_", (boolean)false, (int)2, null)) {
                    String string2 = Build.FINGERPRINT;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FINGERPRINT");
                    if (StringsKt.endsWith$default((String)string2, (String)":user/release-keys", (boolean)false, (int)2, null)) {
                        String string3 = Build.PRODUCT;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PRODUCT");
                        if (StringsKt.startsWith$default((String)string3, (String)"sdk_gphone_", (boolean)false, (int)2, null)) {
                            String string4 = Build.MODEL;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MODEL");
                            if (StringsKt.startsWith$default((String)string4, (String)"sdk_gphone_", (boolean)false, (int)2, null)) return true;
                        }
                    }
                }
                String string5 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"FINGERPRINT");
                if (!StringsKt.startsWith$default((String)string5, (String)"google/sdk_gphone64_", (boolean)false, (int)2, null)) break block9;
                String string6 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"FINGERPRINT");
                if (StringsKt.endsWith$default((String)string6, (String)":userdebug/dev-keys", (boolean)false, (int)2, null)) break block10;
                String string7 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"FINGERPRINT");
                if (!StringsKt.endsWith$default((String)string7, (String)":user/release-keys", (boolean)false, (int)2, null)) break block9;
            }
            String string = Build.PRODUCT;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
            if (StringsKt.startsWith$default((String)string, (String)"sdk_gphone64_", (boolean)false, (int)2, null)) {
                String string8 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"MODEL");
                if (StringsKt.startsWith$default((String)string8, (String)"sdk_gphone64_", (boolean)false, (int)2, null)) return true;
            }
        }
        String string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string9 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string9, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string10 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string11 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string12 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        if (Build.BOARD.equals("QC_Reference_Phone")) {
            if (!StringsKt.equals((String)Build.MANUFACTURER, (String)"Xiaomi", (boolean)true)) return true;
        }
        String string13 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string13, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string14 = Build.HOST;
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"HOST");
        if (StringsKt.startsWith$default((String)string14, (String)"Build", (boolean)false, (int)2, null)) return true;
        String string15 = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"BRAND");
        if (StringsKt.startsWith$default((String)string15, (String)"generic", (boolean)false, (int)2, null)) {
            String string16 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"DEVICE");
            if (StringsKt.startsWith$default((String)string16, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        if (!Build.PRODUCT.equals("google_sdk")) return false;
        return true;
    }

    private static final Boolean collect$lambda$35(Lazy<Boolean> $simulator$delegate) {
        Lazy<Boolean> lazy = $simulator$delegate;
        return (Boolean)lazy.getValue();
    }
}

