/**
 * <h1>AWS::ACMPCA Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.acmpca.*;
 * </pre></blockquote>
 * <p>
 * <h2>Certificate Authority</h2>
 * <p>
 * This package contains a <code>CertificateAuthority</code> class.
 * At the moment, you cannot create new Authorities using it,
 * but you can import existing ones using the <code>fromCertificateAuthorityArn</code> static method:
 * <p>
 * <blockquote><pre>
 * ICertificateAuthority certificateAuthority = CertificateAuthority.fromCertificateAuthorityArn(this, "CA", "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/023077d8-2bfa-4eb0-8f22-05c96deade77");
 * </pre></blockquote>
 * <p>
 * <h2>Low-level <code>Cfn*</code> classes</h2>
 * <p>
 * You can always use the low-level classes
 * (starting with <code>Cfn*</code>) to create resources like the Certificate Authority:
 * <p>
 * <blockquote><pre>
 * CfnCertificateAuthority cfnCertificateAuthority = CfnCertificateAuthority.Builder.create(this, "CA")
 *         .type("ROOT")
 *         .keyAlgorithm("RSA_2048")
 *         .signingAlgorithm("SHA256WITHRSA")
 *         .subject(SubjectProperty.builder()
 *                 .country("US")
 *                 .organization("string")
 *                 .organizationalUnit("string")
 *                 .distinguishedNameQualifier("string")
 *                 .state("string")
 *                 .commonName("123")
 *                 .serialNumber("string")
 *                 .locality("string")
 *                 .title("string")
 *                 .surname("string")
 *                 .givenName("string")
 *                 .initials("DG")
 *                 .pseudonym("string")
 *                 .generationQualifier("DBG")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you need to pass the higher-level <code>ICertificateAuthority</code> somewhere,
 * you can get it from the lower-level <code>CfnCertificateAuthority</code> using the same <code>fromCertificateAuthorityArn</code> method:
 * <p>
 * <blockquote><pre>
 * CfnCertificateAuthority cfnCertificateAuthority;
 * 
 * 
 * ICertificateAuthority certificateAuthority = CertificateAuthority.fromCertificateAuthorityArn(this, "CertificateAuthority", cfnCertificateAuthority.getAttrArn());
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.acmpca;
