package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Properties for an App.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp = App.Builder.create(this, "MyApp")
 *         .sourceCodeProvider(GitHubSourceCodeProvider.Builder.create()
 *                 .owner("&lt;user&gt;")
 *                 .repository("&lt;repo&gt;")
 *                 .oauthToken(SecretValue.secretsManager("my-github-token"))
 *                 .build())
 *         .autoBranchCreation(AutoBranchCreation.builder() // Automatically connect branches that match a pattern set
 *                 .patterns(List.of("feature/*", "test/*")).build())
 *         .autoBranchDeletion(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.071Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.amplify.$Module.class, fqn = "@aws-cdk/aws-amplify.AppProps")
@software.amazon.jsii.Jsii.Proxy(AppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name for the application.
     * <p>
     * Default: - a CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppName() {
        return null;
    }

    /**
     * (experimental) The auto branch creation configuration.
     * <p>
     * Use this to automatically create
     * branches that match a certain pattern.
     * <p>
     * Default: - no auto branch creation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.AutoBranchCreation getAutoBranchCreation() {
        return null;
    }

    /**
     * (experimental) Automatically disconnect a branch in the Amplify Console when you delete a branch from your Git repository.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoBranchDeletion() {
        return null;
    }

    /**
     * (experimental) The Basic Auth configuration.
     * <p>
     * Use this to set password protection at an
     * app level to all your branches.
     * <p>
     * Default: - no password protection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.BasicAuth getBasicAuth() {
        return null;
    }

    /**
     * (experimental) BuildSpec for the application.
     * <p>
     * Alternatively, add a <code>amplify.yml</code>
     * file to the repository.
     * <p>
     * Default: - no build spec
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html">https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
        return null;
    }

    /**
     * (experimental) The custom HTTP response headers for an Amplify app.
     * <p>
     * Default: - no custom response headers
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html">https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.amplify.CustomResponseHeader> getCustomResponseHeaders() {
        return null;
    }

    /**
     * (experimental) Custom rewrite/redirect rules for the application.
     * <p>
     * Default: - no custom rewrite/redirect rules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.amplify.CustomRule> getCustomRules() {
        return null;
    }

    /**
     * (experimental) A description for the application.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Environment variables for the application.
     * <p>
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     * <p>
     * Default: - no environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
        return null;
    }

    /**
     * (experimental) The IAM service role to associate with the application.
     * <p>
     * The App
     * implements IGrantable.
     * <p>
     * Default: - a new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) The source code provider for this application.
     * <p>
     * Default: - not connected to a source code provider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.ISourceCodeProvider getSourceCodeProvider() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AppProps> {
        java.lang.String appName;
        software.amazon.awscdk.services.amplify.AutoBranchCreation autoBranchCreation;
        java.lang.Boolean autoBranchDeletion;
        software.amazon.awscdk.services.amplify.BasicAuth basicAuth;
        software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        java.util.List<software.amazon.awscdk.services.amplify.CustomResponseHeader> customResponseHeaders;
        java.util.List<software.amazon.awscdk.services.amplify.CustomRule> customRules;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.amplify.ISourceCodeProvider sourceCodeProvider;

        /**
         * Sets the value of {@link AppProps#getAppName}
         * @param appName The name for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder appName(java.lang.String appName) {
            this.appName = appName;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getAutoBranchCreation}
         * @param autoBranchCreation The auto branch creation configuration.
         *                           Use this to automatically create
         *                           branches that match a certain pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBranchCreation(software.amazon.awscdk.services.amplify.AutoBranchCreation autoBranchCreation) {
            this.autoBranchCreation = autoBranchCreation;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getAutoBranchDeletion}
         * @param autoBranchDeletion Automatically disconnect a branch in the Amplify Console when you delete a branch from your Git repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBranchDeletion(java.lang.Boolean autoBranchDeletion) {
            this.autoBranchDeletion = autoBranchDeletion;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getBasicAuth}
         * @param basicAuth The Basic Auth configuration.
         *                  Use this to set password protection at an
         *                  app level to all your branches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder basicAuth(software.amazon.awscdk.services.amplify.BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getBuildSpec}
         * @param buildSpec BuildSpec for the application.
         *                  Alternatively, add a <code>amplify.yml</code>
         *                  file to the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getCustomResponseHeaders}
         * @param customResponseHeaders The custom HTTP response headers for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder customResponseHeaders(java.util.List<? extends software.amazon.awscdk.services.amplify.CustomResponseHeader> customResponseHeaders) {
            this.customResponseHeaders = (java.util.List<software.amazon.awscdk.services.amplify.CustomResponseHeader>)customResponseHeaders;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getCustomRules}
         * @param customRules Custom rewrite/redirect rules for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder customRules(java.util.List<? extends software.amazon.awscdk.services.amplify.CustomRule> customRules) {
            this.customRules = (java.util.List<software.amazon.awscdk.services.amplify.CustomRule>)customRules;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getDescription}
         * @param description A description for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getEnvironmentVariables}
         * @param environmentVariables Environment variables for the application.
         *                             All environment variables that you add are encrypted to prevent rogue
         *                             access so you can use them to store secret information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getRole}
         * @param role The IAM service role to associate with the application.
         *             The App
         *             implements IGrantable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getSourceCodeProvider}
         * @param sourceCodeProvider The source code provider for this application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceCodeProvider(software.amazon.awscdk.services.amplify.ISourceCodeProvider sourceCodeProvider) {
            this.sourceCodeProvider = sourceCodeProvider;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppProps {
        private final java.lang.String appName;
        private final software.amazon.awscdk.services.amplify.AutoBranchCreation autoBranchCreation;
        private final java.lang.Boolean autoBranchDeletion;
        private final software.amazon.awscdk.services.amplify.BasicAuth basicAuth;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final java.util.List<software.amazon.awscdk.services.amplify.CustomResponseHeader> customResponseHeaders;
        private final java.util.List<software.amazon.awscdk.services.amplify.CustomRule> customRules;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.amplify.ISourceCodeProvider sourceCodeProvider;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appName = software.amazon.jsii.Kernel.get(this, "appName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoBranchCreation = software.amazon.jsii.Kernel.get(this, "autoBranchCreation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.AutoBranchCreation.class));
            this.autoBranchDeletion = software.amazon.jsii.Kernel.get(this, "autoBranchDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.basicAuth = software.amazon.jsii.Kernel.get(this, "basicAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuth.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.customResponseHeaders = software.amazon.jsii.Kernel.get(this, "customResponseHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.CustomResponseHeader.class)));
            this.customRules = software.amazon.jsii.Kernel.get(this, "customRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.CustomRule.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.sourceCodeProvider = software.amazon.jsii.Kernel.get(this, "sourceCodeProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.ISourceCodeProvider.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appName = builder.appName;
            this.autoBranchCreation = builder.autoBranchCreation;
            this.autoBranchDeletion = builder.autoBranchDeletion;
            this.basicAuth = builder.basicAuth;
            this.buildSpec = builder.buildSpec;
            this.customResponseHeaders = (java.util.List<software.amazon.awscdk.services.amplify.CustomResponseHeader>)builder.customResponseHeaders;
            this.customRules = (java.util.List<software.amazon.awscdk.services.amplify.CustomRule>)builder.customRules;
            this.description = builder.description;
            this.environmentVariables = builder.environmentVariables;
            this.role = builder.role;
            this.sourceCodeProvider = builder.sourceCodeProvider;
        }

        @Override
        public final java.lang.String getAppName() {
            return this.appName;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.AutoBranchCreation getAutoBranchCreation() {
            return this.autoBranchCreation;
        }

        @Override
        public final java.lang.Boolean getAutoBranchDeletion() {
            return this.autoBranchDeletion;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.BasicAuth getBasicAuth() {
            return this.basicAuth;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.amplify.CustomResponseHeader> getCustomResponseHeaders() {
            return this.customResponseHeaders;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.amplify.CustomRule> getCustomRules() {
            return this.customRules;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.ISourceCodeProvider getSourceCodeProvider() {
            return this.sourceCodeProvider;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAppName() != null) {
                data.set("appName", om.valueToTree(this.getAppName()));
            }
            if (this.getAutoBranchCreation() != null) {
                data.set("autoBranchCreation", om.valueToTree(this.getAutoBranchCreation()));
            }
            if (this.getAutoBranchDeletion() != null) {
                data.set("autoBranchDeletion", om.valueToTree(this.getAutoBranchDeletion()));
            }
            if (this.getBasicAuth() != null) {
                data.set("basicAuth", om.valueToTree(this.getBasicAuth()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCustomResponseHeaders() != null) {
                data.set("customResponseHeaders", om.valueToTree(this.getCustomResponseHeaders()));
            }
            if (this.getCustomRules() != null) {
                data.set("customRules", om.valueToTree(this.getCustomRules()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSourceCodeProvider() != null) {
                data.set("sourceCodeProvider", om.valueToTree(this.getSourceCodeProvider()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-amplify.AppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppProps.Jsii$Proxy that = (AppProps.Jsii$Proxy) o;

            if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) return false;
            if (this.autoBranchCreation != null ? !this.autoBranchCreation.equals(that.autoBranchCreation) : that.autoBranchCreation != null) return false;
            if (this.autoBranchDeletion != null ? !this.autoBranchDeletion.equals(that.autoBranchDeletion) : that.autoBranchDeletion != null) return false;
            if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.customResponseHeaders != null ? !this.customResponseHeaders.equals(that.customResponseHeaders) : that.customResponseHeaders != null) return false;
            if (this.customRules != null ? !this.customRules.equals(that.customRules) : that.customRules != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.sourceCodeProvider != null ? this.sourceCodeProvider.equals(that.sourceCodeProvider) : that.sourceCodeProvider == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appName != null ? this.appName.hashCode() : 0;
            result = 31 * result + (this.autoBranchCreation != null ? this.autoBranchCreation.hashCode() : 0);
            result = 31 * result + (this.autoBranchDeletion != null ? this.autoBranchDeletion.hashCode() : 0);
            result = 31 * result + (this.basicAuth != null ? this.basicAuth.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.customResponseHeaders != null ? this.customResponseHeaders.hashCode() : 0);
            result = 31 * result + (this.customRules != null ? this.customRules.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.sourceCodeProvider != null ? this.sourceCodeProvider.hashCode() : 0);
            return result;
        }
    }
}
