package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Properties for a BasicAuth.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.core.*;
 * Key key;
 * SecretValue secretValue;
 * BasicAuthProps basicAuthProps = BasicAuthProps.builder()
 *         .username("username")
 *         // the properties below are optional
 *         .encryptionKey(key)
 *         .password(secretValue)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.075Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.amplify.$Module.class, fqn = "@aws-cdk/aws-amplify.BasicAuthProps")
@software.amazon.jsii.Jsii.Proxy(BasicAuthProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BasicAuthProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The username.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * (experimental) The encryption key to use to encrypt the password when it's generated in Secrets Manager.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) The password.
     * <p>
     * Default: - A Secrets Manager generated password
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretValue getPassword() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BasicAuthProps> {
        java.lang.String username;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.core.SecretValue password;

        /**
         * Sets the value of {@link BasicAuthProps#getUsername}
         * @param username The username. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link BasicAuthProps#getEncryptionKey}
         * @param encryptionKey The encryption key to use to encrypt the password when it's generated in Secrets Manager.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link BasicAuthProps#getPassword}
         * @param password The password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(software.amazon.awscdk.core.SecretValue password) {
            this.password = password;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicAuthProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BasicAuthProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BasicAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthProps {
        private final java.lang.String username;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.core.SecretValue password;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            this.encryptionKey = builder.encryptionKey;
            this.password = builder.password;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getPassword() {
            return this.password;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("username", om.valueToTree(this.getUsername()));
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-amplify.BasicAuthProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicAuthProps.Jsii$Proxy that = (BasicAuthProps.Jsii$Proxy) o;

            if (!username.equals(that.username)) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            return this.password != null ? this.password.equals(that.password) : that.password == null;
        }

        @Override
        public final int hashCode() {
            int result = this.username.hashCode();
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            return result;
        }
    }
}
