package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Properties for a CodeCommit source code provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codecommit.*;
 * Repository repository = Repository.Builder.create(this, "Repo")
 *         .repositoryName("my-repo")
 *         .build();
 * App amplifyApp = App.Builder.create(this, "App")
 *         .sourceCodeProvider(CodeCommitSourceCodeProvider.Builder.create().repository(repository).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.116Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.amplify.$Module.class, fqn = "@aws-cdk/aws-amplify.CodeCommitSourceCodeProviderProps")
@software.amazon.jsii.Jsii.Proxy(CodeCommitSourceCodeProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeCommitSourceCodeProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The CodeCommit repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository getRepository();

    /**
     * @return a {@link Builder} of {@link CodeCommitSourceCodeProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeCommitSourceCodeProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeCommitSourceCodeProviderProps> {
        software.amazon.awscdk.services.codecommit.IRepository repository;

        /**
         * Sets the value of {@link CodeCommitSourceCodeProviderProps#getRepository}
         * @param repository The CodeCommit repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(software.amazon.awscdk.services.codecommit.IRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeCommitSourceCodeProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeCommitSourceCodeProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeCommitSourceCodeProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeCommitSourceCodeProviderProps {
        private final software.amazon.awscdk.services.codecommit.IRepository repository;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
        }

        @Override
        public final software.amazon.awscdk.services.codecommit.IRepository getRepository() {
            return this.repository;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repository", om.valueToTree(this.getRepository()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-amplify.CodeCommitSourceCodeProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeCommitSourceCodeProviderProps.Jsii$Proxy that = (CodeCommitSourceCodeProviderProps.Jsii$Proxy) o;

            return this.repository.equals(that.repository);
        }

        @Override
        public final int hashCode() {
            int result = this.repository.hashCode();
            return result;
        }
    }
}
