package software.amazon.awscdk.services.amplify;

/**
 * (experimental) An Amplify Console domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp;
 * Branch master;
 * Branch dev;
 * Domain domain = amplifyApp.addDomain("example.com", DomainOptions.builder()
 *         .enableAutoSubdomain(true) // in case subdomains should be auto registered for branches
 *         .autoSubdomainCreationPatterns(List.of("*", "pr*"))
 *         .build());
 * domain.mapRoot(master); // map master branch to domain root
 * domain.mapSubDomain(master, "www");
 * domain.mapSubDomain(dev);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.120Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.amplify.$Module.class, fqn = "@aws-cdk/aws-amplify.Domain")
public class Domain extends software.amazon.awscdk.core.Resource {

    protected Domain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Domain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Domain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.DomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Maps a branch to the domain root.
     * <p>
     * @param branch This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Domain mapRoot(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IBranch branch) {
        return software.amazon.jsii.Kernel.call(this, "mapRoot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Domain.class), new Object[] { java.util.Objects.requireNonNull(branch, "branch is required") });
    }

    /**
     * (experimental) Maps a branch to a sub domain.
     * <p>
     * @param branch The branch. This parameter is required.
     * @param prefix The prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Domain mapSubDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IBranch branch, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        return software.amazon.jsii.Kernel.call(this, "mapSubDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Domain.class), new Object[] { java.util.Objects.requireNonNull(branch, "branch is required"), prefix });
    }

    /**
     * (experimental) Maps a branch to a sub domain.
     * <p>
     * @param branch The branch. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Domain mapSubDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IBranch branch) {
        return software.amazon.jsii.Kernel.call(this, "mapSubDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Domain.class), new Object[] { java.util.Objects.requireNonNull(branch, "branch is required") });
    }

    /**
     * (experimental) Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The ARN of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The DNS Record for certificate verification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateRecord() {
        return software.amazon.jsii.Kernel.get(this, "certificateRecord", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Branch patterns for the automatically created subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDomainAutoSubDomainCreationPatterns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "domainAutoSubDomainCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The IAM service role for the subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainAutoSubDomainIamRole() {
        return software.amazon.jsii.Kernel.get(this, "domainAutoSubDomainIamRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Specifies whether the automated creation of subdomains for branches is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getDomainEnableAutoSubDomain() {
        return software.amazon.jsii.Kernel.get(this, "domainEnableAutoSubDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     * (experimental) The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The status of the domain association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainStatus() {
        return software.amazon.jsii.Kernel.get(this, "domainStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The reason for the current status of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatusReason() {
        return software.amazon.jsii.Kernel.get(this, "statusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.amplify.Domain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.Domain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amplify.DomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amplify.DomainProps.Builder();
        }

        /**
         * (experimental) Branches which should automatically create subdomains.
         * <p>
         * Default: - all repository branches ['*', 'pr*']
         * <p>
         * @return {@code this}
         * @param autoSubdomainCreationPatterns Branches which should automatically create subdomains. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoSubdomainCreationPatterns(final java.util.List<java.lang.String> autoSubdomainCreationPatterns) {
            this.props.autoSubdomainCreationPatterns(autoSubdomainCreationPatterns);
            return this;
        }

        /**
         * (experimental) The name of the domain.
         * <p>
         * Default: - the construct's id
         * <p>
         * @return {@code this}
         * @param domainName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * (experimental) Automatically create subdomains for connected branches.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableAutoSubdomain Automatically create subdomains for connected branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableAutoSubdomain(final java.lang.Boolean enableAutoSubdomain) {
            this.props.enableAutoSubdomain(enableAutoSubdomain);
            return this;
        }

        /**
         * (experimental) Subdomains.
         * <p>
         * Default: - use `addSubDomain()` to add subdomains
         * <p>
         * @return {@code this}
         * @param subDomains Subdomains. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subDomains(final java.util.List<? extends software.amazon.awscdk.services.amplify.SubDomain> subDomains) {
            this.props.subDomains(subDomains);
            return this;
        }

        /**
         * (experimental) The application to which the domain must be connected.
         * <p>
         * @return {@code this}
         * @param app The application to which the domain must be connected. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder app(final software.amazon.awscdk.services.amplify.IApp app) {
            this.props.app(app);
            return this;
        }

        /**
         * (experimental) The IAM role with access to Route53 when using enableAutoSubdomain.
         * <p>
         * Default: the IAM role from App.grantPrincipal
         * <p>
         * @return {@code this}
         * @param autoSubDomainIamRole The IAM role with access to Route53 when using enableAutoSubdomain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoSubDomainIamRole(final software.amazon.awscdk.services.iam.IRole autoSubDomainIamRole) {
            this.props.autoSubDomainIamRole(autoSubDomainIamRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplify.Domain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.amplify.Domain build() {
            return new software.amazon.awscdk.services.amplify.Domain(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
