package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Properties for a Domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * import software.amazon.awscdk.services.iam.*;
 * App app;
 * Branch branch;
 * Role role;
 * DomainProps domainProps = DomainProps.builder()
 *         .app(app)
 *         // the properties below are optional
 *         .autoSubdomainCreationPatterns(List.of("autoSubdomainCreationPatterns"))
 *         .autoSubDomainIamRole(role)
 *         .domainName("domainName")
 *         .enableAutoSubdomain(false)
 *         .subDomains(List.of(SubDomain.builder()
 *                 .branch(branch)
 *                 // the properties below are optional
 *                 .prefix("prefix")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.123Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.amplify.$Module.class, fqn = "@aws-cdk/aws-amplify.DomainProps")
@software.amazon.jsii.Jsii.Proxy(DomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DomainProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.amplify.DomainOptions {

    /**
     * (experimental) The application to which the domain must be connected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IApp getApp();

    /**
     * (experimental) The IAM role with access to Route53 when using enableAutoSubdomain.
     * <p>
     * Default: the IAM role from App.grantPrincipal
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAutoSubDomainIamRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DomainProps> {
        software.amazon.awscdk.services.amplify.IApp app;
        software.amazon.awscdk.services.iam.IRole autoSubDomainIamRole;
        java.util.List<java.lang.String> autoSubdomainCreationPatterns;
        java.lang.String domainName;
        java.lang.Boolean enableAutoSubdomain;
        java.util.List<software.amazon.awscdk.services.amplify.SubDomain> subDomains;

        /**
         * Sets the value of {@link DomainProps#getApp}
         * @param app The application to which the domain must be connected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder app(software.amazon.awscdk.services.amplify.IApp app) {
            this.app = app;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getAutoSubDomainIamRole}
         * @param autoSubDomainIamRole The IAM role with access to Route53 when using enableAutoSubdomain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoSubDomainIamRole(software.amazon.awscdk.services.iam.IRole autoSubDomainIamRole) {
            this.autoSubDomainIamRole = autoSubDomainIamRole;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getAutoSubdomainCreationPatterns}
         * @param autoSubdomainCreationPatterns Branches which should automatically create subdomains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoSubdomainCreationPatterns(java.util.List<java.lang.String> autoSubdomainCreationPatterns) {
            this.autoSubdomainCreationPatterns = autoSubdomainCreationPatterns;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getDomainName}
         * @param domainName The name of the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getEnableAutoSubdomain}
         * @param enableAutoSubdomain Automatically create subdomains for connected branches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableAutoSubdomain(java.lang.Boolean enableAutoSubdomain) {
            this.enableAutoSubdomain = enableAutoSubdomain;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getSubDomains}
         * @param subDomains Subdomains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder subDomains(java.util.List<? extends software.amazon.awscdk.services.amplify.SubDomain> subDomains) {
            this.subDomains = (java.util.List<software.amazon.awscdk.services.amplify.SubDomain>)subDomains;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainProps {
        private final software.amazon.awscdk.services.amplify.IApp app;
        private final software.amazon.awscdk.services.iam.IRole autoSubDomainIamRole;
        private final java.util.List<java.lang.String> autoSubdomainCreationPatterns;
        private final java.lang.String domainName;
        private final java.lang.Boolean enableAutoSubdomain;
        private final java.util.List<software.amazon.awscdk.services.amplify.SubDomain> subDomains;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.app = software.amazon.jsii.Kernel.get(this, "app", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.IApp.class));
            this.autoSubDomainIamRole = software.amazon.jsii.Kernel.get(this, "autoSubDomainIamRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.autoSubdomainCreationPatterns = software.amazon.jsii.Kernel.get(this, "autoSubdomainCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableAutoSubdomain = software.amazon.jsii.Kernel.get(this, "enableAutoSubdomain", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subDomains = software.amazon.jsii.Kernel.get(this, "subDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.SubDomain.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.app = java.util.Objects.requireNonNull(builder.app, "app is required");
            this.autoSubDomainIamRole = builder.autoSubDomainIamRole;
            this.autoSubdomainCreationPatterns = builder.autoSubdomainCreationPatterns;
            this.domainName = builder.domainName;
            this.enableAutoSubdomain = builder.enableAutoSubdomain;
            this.subDomains = (java.util.List<software.amazon.awscdk.services.amplify.SubDomain>)builder.subDomains;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.IApp getApp() {
            return this.app;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAutoSubDomainIamRole() {
            return this.autoSubDomainIamRole;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoSubdomainCreationPatterns() {
            return this.autoSubdomainCreationPatterns;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Boolean getEnableAutoSubdomain() {
            return this.enableAutoSubdomain;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.amplify.SubDomain> getSubDomains() {
            return this.subDomains;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("app", om.valueToTree(this.getApp()));
            if (this.getAutoSubDomainIamRole() != null) {
                data.set("autoSubDomainIamRole", om.valueToTree(this.getAutoSubDomainIamRole()));
            }
            if (this.getAutoSubdomainCreationPatterns() != null) {
                data.set("autoSubdomainCreationPatterns", om.valueToTree(this.getAutoSubdomainCreationPatterns()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEnableAutoSubdomain() != null) {
                data.set("enableAutoSubdomain", om.valueToTree(this.getEnableAutoSubdomain()));
            }
            if (this.getSubDomains() != null) {
                data.set("subDomains", om.valueToTree(this.getSubDomains()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-amplify.DomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainProps.Jsii$Proxy that = (DomainProps.Jsii$Proxy) o;

            if (!app.equals(that.app)) return false;
            if (this.autoSubDomainIamRole != null ? !this.autoSubDomainIamRole.equals(that.autoSubDomainIamRole) : that.autoSubDomainIamRole != null) return false;
            if (this.autoSubdomainCreationPatterns != null ? !this.autoSubdomainCreationPatterns.equals(that.autoSubdomainCreationPatterns) : that.autoSubdomainCreationPatterns != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.enableAutoSubdomain != null ? !this.enableAutoSubdomain.equals(that.enableAutoSubdomain) : that.enableAutoSubdomain != null) return false;
            return this.subDomains != null ? this.subDomains.equals(that.subDomains) : that.subDomains == null;
        }

        @Override
        public final int hashCode() {
            int result = this.app.hashCode();
            result = 31 * result + (this.autoSubDomainIamRole != null ? this.autoSubDomainIamRole.hashCode() : 0);
            result = 31 * result + (this.autoSubdomainCreationPatterns != null ? this.autoSubdomainCreationPatterns.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.enableAutoSubdomain != null ? this.enableAutoSubdomain.hashCode() : 0);
            result = 31 * result + (this.subDomains != null ? this.subDomains.hashCode() : 0);
            return result;
        }
    }
}
