/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.amplify;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.amplify.CfnApp;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnAppProps
extends JsiiSerializable {
    public String getName();

    public String getAccessToken();

    public Object getBasicAuthConfig();

    public String getBuildSpec();

    public Object getCustomRules();

    public String getDescription();

    public Object getEnvironmentVariables();

    public String getIamServiceRole();

    public String getOauthToken();

    public String getRepository();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        @Nullable
        private String _accessToken;
        @Nullable
        private Object _basicAuthConfig;
        @Nullable
        private String _buildSpec;
        @Nullable
        private Object _customRules;
        @Nullable
        private String _description;
        @Nullable
        private Object _environmentVariables;
        @Nullable
        private String _iamServiceRole;
        @Nullable
        private String _oauthToken;
        @Nullable
        private String _repository;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withAccessToken(@Nullable String value) {
            this._accessToken = value;
            return this;
        }

        public Builder withBasicAuthConfig(@Nullable CfnApp.BasicAuthConfigProperty value) {
            this._basicAuthConfig = value;
            return this;
        }

        public Builder withBasicAuthConfig(@Nullable IResolvable value) {
            this._basicAuthConfig = value;
            return this;
        }

        public Builder withBuildSpec(@Nullable String value) {
            this._buildSpec = value;
            return this;
        }

        public Builder withCustomRules(@Nullable IResolvable value) {
            this._customRules = value;
            return this;
        }

        public Builder withCustomRules(@Nullable List<Object> value) {
            this._customRules = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEnvironmentVariables(@Nullable IResolvable value) {
            this._environmentVariables = value;
            return this;
        }

        public Builder withEnvironmentVariables(@Nullable List<Object> value) {
            this._environmentVariables = value;
            return this;
        }

        public Builder withIamServiceRole(@Nullable String value) {
            this._iamServiceRole = value;
            return this;
        }

        public Builder withOauthToken(@Nullable String value) {
            this._oauthToken = value;
            return this;
        }

        public Builder withRepository(@Nullable String value) {
            this._repository = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnAppProps build() {
            return new CfnAppProps(){
                private final String $name;
                @Nullable
                private final String $accessToken;
                @Nullable
                private final Object $basicAuthConfig;
                @Nullable
                private final String $buildSpec;
                @Nullable
                private final Object $customRules;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $environmentVariables;
                @Nullable
                private final String $iamServiceRole;
                @Nullable
                private final String $oauthToken;
                @Nullable
                private final String $repository;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$accessToken = _accessToken;
                    this.$basicAuthConfig = _basicAuthConfig;
                    this.$buildSpec = _buildSpec;
                    this.$customRules = _customRules;
                    this.$description = _description;
                    this.$environmentVariables = _environmentVariables;
                    this.$iamServiceRole = _iamServiceRole;
                    this.$oauthToken = _oauthToken;
                    this.$repository = _repository;
                    this.$tags = _tags;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getAccessToken() {
                    return this.$accessToken;
                }

                @Override
                public Object getBasicAuthConfig() {
                    return this.$basicAuthConfig;
                }

                @Override
                public String getBuildSpec() {
                    return this.$buildSpec;
                }

                @Override
                public Object getCustomRules() {
                    return this.$customRules;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getEnvironmentVariables() {
                    return this.$environmentVariables;
                }

                @Override
                public String getIamServiceRole() {
                    return this.$iamServiceRole;
                }

                @Override
                public String getOauthToken() {
                    return this.$oauthToken;
                }

                @Override
                public String getRepository() {
                    return this.$repository;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    if (this.getAccessToken() != null) {
                        obj.set("accessToken", om.valueToTree((Object)this.getAccessToken()));
                    }
                    if (this.getBasicAuthConfig() != null) {
                        obj.set("basicAuthConfig", om.valueToTree(this.getBasicAuthConfig()));
                    }
                    if (this.getBuildSpec() != null) {
                        obj.set("buildSpec", om.valueToTree((Object)this.getBuildSpec()));
                    }
                    if (this.getCustomRules() != null) {
                        obj.set("customRules", om.valueToTree(this.getCustomRules()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getEnvironmentVariables() != null) {
                        obj.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                    }
                    if (this.getIamServiceRole() != null) {
                        obj.set("iamServiceRole", om.valueToTree((Object)this.getIamServiceRole()));
                    }
                    if (this.getOauthToken() != null) {
                        obj.set("oauthToken", om.valueToTree((Object)this.getOauthToken()));
                    }
                    if (this.getRepository() != null) {
                        obj.set("repository", om.valueToTree((Object)this.getRepository()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

