/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.amplify;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.amplify.CfnBranch;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnBranchProps
extends JsiiSerializable {
    public String getAppId();

    public String getBranchName();

    public Object getBasicAuthConfig();

    public String getBuildSpec();

    public String getDescription();

    public Object getEnvironmentVariables();

    public String getStage();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _appId;
        private String _branchName;
        @Nullable
        private Object _basicAuthConfig;
        @Nullable
        private String _buildSpec;
        @Nullable
        private String _description;
        @Nullable
        private Object _environmentVariables;
        @Nullable
        private String _stage;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withAppId(String value) {
            this._appId = Objects.requireNonNull(value, "appId is required");
            return this;
        }

        public Builder withBranchName(String value) {
            this._branchName = Objects.requireNonNull(value, "branchName is required");
            return this;
        }

        public Builder withBasicAuthConfig(@Nullable IResolvable value) {
            this._basicAuthConfig = value;
            return this;
        }

        public Builder withBasicAuthConfig(@Nullable CfnBranch.BasicAuthConfigProperty value) {
            this._basicAuthConfig = value;
            return this;
        }

        public Builder withBuildSpec(@Nullable String value) {
            this._buildSpec = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEnvironmentVariables(@Nullable IResolvable value) {
            this._environmentVariables = value;
            return this;
        }

        public Builder withEnvironmentVariables(@Nullable List<Object> value) {
            this._environmentVariables = value;
            return this;
        }

        public Builder withStage(@Nullable String value) {
            this._stage = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnBranchProps build() {
            return new CfnBranchProps(){
                private final String $appId;
                private final String $branchName;
                @Nullable
                private final Object $basicAuthConfig;
                @Nullable
                private final String $buildSpec;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $environmentVariables;
                @Nullable
                private final String $stage;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$appId = Objects.requireNonNull(_appId, "appId is required");
                    this.$branchName = Objects.requireNonNull(_branchName, "branchName is required");
                    this.$basicAuthConfig = _basicAuthConfig;
                    this.$buildSpec = _buildSpec;
                    this.$description = _description;
                    this.$environmentVariables = _environmentVariables;
                    this.$stage = _stage;
                    this.$tags = _tags;
                }

                @Override
                public String getAppId() {
                    return this.$appId;
                }

                @Override
                public String getBranchName() {
                    return this.$branchName;
                }

                @Override
                public Object getBasicAuthConfig() {
                    return this.$basicAuthConfig;
                }

                @Override
                public String getBuildSpec() {
                    return this.$buildSpec;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getEnvironmentVariables() {
                    return this.$environmentVariables;
                }

                @Override
                public String getStage() {
                    return this.$stage;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("appId", om.valueToTree((Object)this.getAppId()));
                    obj.set("branchName", om.valueToTree((Object)this.getBranchName()));
                    if (this.getBasicAuthConfig() != null) {
                        obj.set("basicAuthConfig", om.valueToTree(this.getBasicAuthConfig()));
                    }
                    if (this.getBuildSpec() != null) {
                        obj.set("buildSpec", om.valueToTree((Object)this.getBuildSpec()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getEnvironmentVariables() != null) {
                        obj.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                    }
                    if (this.getStage() != null) {
                        obj.set("stage", om.valueToTree((Object)this.getStage()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

