package software.amazon.awscdk.services.apigateway;

/**
 * A Deployment of a REST API.
 * 
 * An immutable representation of a RestApi resource that can be called by users
 * using Stages. A deployment must be associated with a Stage for it to be
 * callable over the Internet.
 * 
 * Normally, you don't need to define deployments manually. The RestApi
 * construct manages a Deployment resource that represents the latest model. It
 * can be accessed through `restApi.latestDeployment` (unless `deploy: false` is
 * set when defining the `RestApi`).
 * 
 * If you manually define this resource, you will need to know that since
 * deployments are immutable, as long as the resource's logical ID doesn't
 * change, the deployment will represent the snapshot in time in which the
 * resource was created. This means that if you modify the RestApi model (i.e.
 * add methods or resources), these changes will not be reflected unless a new
 * deployment resource is created.
 * 
 * To achieve this behavior, the method `addToLogicalId(data)` can be used to
 * augment the logical ID generated for the deployment resource such that it
 * will include arbitrary data. This is done automatically for the
 * `restApi.latestDeployment` deployment.
 * 
 * Furthermore, since a deployment does not reference any of the REST API
 * resources and methods, CloudFormation will likely provision it before these
 * resources are created, which means that it will represent a "half-baked"
 * model. Use the `addDependency(dep)` method to circumvent that. This is done
 * automatically for the `restApi.latestDeployment` deployment.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:04:28.816Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.Deployment")
public class Deployment extends software.amazon.awscdk.Construct implements software.amazon.awscdk.IDependable {
    protected Deployment(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Deployment(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.apigateway.DeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a dependency for this deployment. Should be called by all resources and methods
     * so they are provisioned before this Deployment.
     */
    public void addDependency(final software.amazon.awscdk.IDependable dep) {
        this.jsiiCall("addDependency", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(dep, "dep is required")).toArray());
    }

    /**
     * Adds a component to the hash that determines this Deployment resource's
     * logical ID.
     * 
     * This should be called by constructs of the API Gateway model that want to
     * invalidate the deployment when their settings change. The component will
     * be resolve()ed during synthesis so tokens are welcome.
     */
    public void addToLogicalId(@javax.annotation.Nullable final java.lang.Object data) {
        this.jsiiCall("addToLogicalId", Void.class, java.util.stream.Stream.of(data).toArray());
    }

    /**
     * Adds a component to the hash that determines this Deployment resource's
     * logical ID.
     * 
     * This should be called by constructs of the API Gateway model that want to
     * invalidate the deployment when their settings change. The component will
     * be resolve()ed during synthesis so tokens are welcome.
     */
    public void addToLogicalId() {
        this.jsiiCall("addToLogicalId", Void.class);
    }

    public software.amazon.awscdk.services.apigateway.RestApiRef getApi() {
        return this.jsiiGet("api", software.amazon.awscdk.services.apigateway.RestApiRef.class);
    }

    /**
     * Allows taking a dependency on this construct.
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    public java.lang.String getDeploymentId() {
        return this.jsiiGet("deploymentId", java.lang.String.class);
    }
}
