package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-12T09:57:22.830Z")
public interface IntegrationResponse extends software.amazon.jsii.JsiiSerializable {
    /**
     * The status code that API Gateway uses to map the integration response to
     * a MethodResponse status code.
     */
    java.lang.String getStatusCode();
    /**
     * The status code that API Gateway uses to map the integration response to
     * a MethodResponse status code.
     */
    void setStatusCode(final java.lang.String value);
    /**
     * Specifies how to handle request payload content type conversions.
     * @default none the request payload is passed through from the method request to the integration request without modification.
     */
    software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling();
    /**
     * Specifies how to handle request payload content type conversions.
     * @default none the request payload is passed through from the method request to the integration request without modification.
     */
    void setContentHandling(final software.amazon.awscdk.services.apigateway.ContentHandling value);
    /**
     * The response parameters from the backend response that API Gateway sends
     * to the method response.
     * 
     * Use the destination as the key and the source as the value:
     * 
     * - The destination must be an existing response parameter in the
     *    MethodResponse property.
     * - The source must be an existing method request parameter or a static
     *    value. You must enclose static values in single quotation marks and
     *    pre-encode these values based on the destination specified in the
     *    request.
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
     */
    java.util.Map<java.lang.String, java.lang.String> getResponseParameters();
    /**
     * The response parameters from the backend response that API Gateway sends
     * to the method response.
     * 
     * Use the destination as the key and the source as the value:
     * 
     * - The destination must be an existing response parameter in the
     *    MethodResponse property.
     * - The source must be an existing method request parameter or a static
     *    value. You must enclose static values in single quotation marks and
     *    pre-encode these values based on the destination specified in the
     *    request.
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
     */
    void setResponseParameters(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * The templates that are used to transform the integration response body.
     * Specify templates as key-value pairs, with a content type as the key and
     * a template as the value.
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    java.util.Map<java.lang.String, java.lang.String> getResponseTemplates();
    /**
     * The templates that are used to transform the integration response body.
     * Specify templates as key-value pairs, with a content type as the key and
     * a template as the value.
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    void setResponseTemplates(final java.util.Map<java.lang.String, java.lang.String> value);

    /**
     * @return a {@link Builder} of {@link IntegrationResponse}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IntegrationResponse}
     */
    final class Builder {
        private java.lang.String _statusCode;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ContentHandling _contentHandling;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _responseParameters;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _responseTemplates;

        /**
         * Sets the value of StatusCode
         * @param value The status code that API Gateway uses to map the integration response to
a MethodResponse status code.
         * @return {@code this}
         */
        public Builder withStatusCode(final java.lang.String value) {
            this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
            return this;
        }
        /**
         * Sets the value of ContentHandling
         * @param value Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        public Builder withContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
            this._contentHandling = value;
            return this;
        }
        /**
         * Sets the value of ResponseParameters
         * @param value The response parameters from the backend response that API Gateway sends
to the method response.

Use the destination as the key and the source as the value:

- The destination must be an existing response parameter in the
   MethodResponse property.
- The source must be an existing method request parameter or a static
   value. You must enclose static values in single quotation marks and
   pre-encode these values based on the destination specified in the
   request.
         * @return {@code this}
         */
        public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._responseParameters = value;
            return this;
        }
        /**
         * Sets the value of ResponseTemplates
         * @param value The templates that are used to transform the integration response body.
Specify templates as key-value pairs, with a content type as the key and
a template as the value.
         * @return {@code this}
         */
        public Builder withResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._responseTemplates = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        public IntegrationResponse build() {
            return new IntegrationResponse() {
                private java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.ContentHandling $contentHandling = _contentHandling;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $responseParameters = _responseParameters;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $responseTemplates = _responseTemplates;

                @Override
                public java.lang.String getStatusCode() {
                    return this.$statusCode;
                }

                @Override
                public void setStatusCode(final java.lang.String value) {
                    this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
                    return this.$contentHandling;
                }

                @Override
                public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
                    this.$contentHandling = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getResponseParameters() {
                    return this.$responseParameters;
                }

                @Override
                public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$responseParameters = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getResponseTemplates() {
                    return this.$responseTemplates;
                }

                @Override
                public void setResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$responseTemplates = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IntegrationResponse {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The status code that API Gateway uses to map the integration response to
         * a MethodResponse status code.
         */
        @Override
        public java.lang.String getStatusCode() {
            return this.jsiiGet("statusCode", java.lang.String.class);
        }

        /**
         * The status code that API Gateway uses to map the integration response to
         * a MethodResponse status code.
         */
        @Override
        public void setStatusCode(final java.lang.String value) {
            this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * @default none the request payload is passed through from the method request to the integration request without modification.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.jsiiGet("contentHandling", software.amazon.awscdk.services.apigateway.ContentHandling.class);
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * @default none the request payload is passed through from the method request to the integration request without modification.
         */
        @Override
        public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
            this.jsiiSet("contentHandling", value);
        }

        /**
         * The response parameters from the backend response that API Gateway sends
         * to the method response.
         * 
         * Use the destination as the key and the source as the value:
         * 
         * - The destination must be an existing response parameter in the
         *    MethodResponse property.
         * - The source must be an existing method request parameter or a static
         *    value. You must enclose static values in single quotation marks and
         *    pre-encode these values based on the destination specified in the
         *    request.
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getResponseParameters() {
            return this.jsiiGet("responseParameters", java.util.Map.class);
        }

        /**
         * The response parameters from the backend response that API Gateway sends
         * to the method response.
         * 
         * Use the destination as the key and the source as the value:
         * 
         * - The destination must be an existing response parameter in the
         *    MethodResponse property.
         * - The source must be an existing method request parameter or a static
         *    value. You must enclose static values in single quotation marks and
         *    pre-encode these values based on the destination specified in the
         *    request.
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
         */
        @Override
        public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("responseParameters", value);
        }

        /**
         * The templates that are used to transform the integration response body.
         * Specify templates as key-value pairs, with a content type as the key and
         * a template as the value.
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getResponseTemplates() {
            return this.jsiiGet("responseTemplates", java.util.Map.class);
        }

        /**
         * The templates that are used to transform the integration response body.
         * Specify templates as key-value pairs, with a content type as the key and
         * a template as the value.
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         */
        @Override
        public void setResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("responseTemplates", value);
        }
    }
}
