package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-19T14:00:32.193Z")
public interface IRestApiResource extends software.amazon.jsii.JsiiSerializable {
    /**
     * The rest API that this resource is part of.
     * 
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     */
    software.amazon.awscdk.services.apigateway.RestApi getResourceApi();
    /**
     * The ID of the resource.
     */
    java.lang.String getResourceId();
    /**
     * The full path of this resuorce.
     */
    java.lang.String getResourcePath();
    /**
     * An integration to use as a default for all methods created within this
     * API unless an integration is specified.
     */
    software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration();
    /**
     * Method options to use as a default for all methods created within this
     * API unless custom options are specified.
     */
    software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions();
    /**
     * Defines a new method for this resource.
     * @return The newly created `Method` object.
     * @param httpMethod The HTTP method
     * @param target The target backend integration for this method
     * @param options Method options, such as authentication.
     */
    software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration target, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions options);
    /**
     * Defines a new method for this resource.
     * @return The newly created `Method` object.
     * @param httpMethod The HTTP method
     * @param target The target backend integration for this method
     */
    software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration target);
    /**
     * Defines a new method for this resource.
     * @return The newly created `Method` object.
     * @param httpMethod The HTTP method
     */
    software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod);
    /**
     * Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.
     * @param options Default integration and method options.
     */
    software.amazon.awscdk.services.apigateway.ProxyResource addProxy(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ResourceOptions options);
    /**
     * Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.
     */
    software.amazon.awscdk.services.apigateway.ProxyResource addProxy();
    /**
     * Defines a new child resource where this resource is the parent.
     * @return A Resource object
     * @param pathPart The path part for the child resource
     * @param options Resource options
     */
    software.amazon.awscdk.services.apigateway.Resource addResource(final java.lang.String pathPart, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ResourceOptions options);
    /**
     * Defines a new child resource where this resource is the parent.
     * @return A Resource object
     * @param pathPart The path part for the child resource
     */
    software.amazon.awscdk.services.apigateway.Resource addResource(final java.lang.String pathPart);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IRestApiResource {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The rest API that this resource is part of.
         * 
         * The reason we need the RestApi object itself and not just the ID is because the model
         * is being tracked by the top-level RestApi object for the purpose of calculating it's
         * hash to determine the ID of the deployment. This allows us to automatically update
         * the deployment when the model of the REST API changes.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.RestApi getResourceApi() {
            return this.jsiiGet("resourceApi", software.amazon.awscdk.services.apigateway.RestApi.class);
        }

        /**
         * The ID of the resource.
         */
        @Override
        public java.lang.String getResourceId() {
            return this.jsiiGet("resourceId", java.lang.String.class);
        }

        /**
         * The full path of this resuorce.
         */
        @Override
        public java.lang.String getResourcePath() {
            return this.jsiiGet("resourcePath", java.lang.String.class);
        }

        /**
         * An integration to use as a default for all methods created within this
         * API unless an integration is specified.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * Method options to use as a default for all methods created within this
         * API unless custom options are specified.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }

        /**
         * Defines a new method for this resource.
         * @return The newly created `Method` object.
         * @param httpMethod The HTTP method
         * @param target The target backend integration for this method
         * @param options Method options, such as authentication.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration target, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions options) {
            return this.jsiiCall("addMethod", software.amazon.awscdk.services.apigateway.Method.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(httpMethod, "httpMethod is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
        }

        /**
         * Defines a new method for this resource.
         * @return The newly created `Method` object.
         * @param httpMethod The HTTP method
         * @param target The target backend integration for this method
         */
        @Override
        public software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration target) {
            return this.jsiiCall("addMethod", software.amazon.awscdk.services.apigateway.Method.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(httpMethod, "httpMethod is required")), java.util.stream.Stream.of(target)).toArray());
        }

        /**
         * Defines a new method for this resource.
         * @return The newly created `Method` object.
         * @param httpMethod The HTTP method
         */
        @Override
        public software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod) {
            return this.jsiiCall("addMethod", software.amazon.awscdk.services.apigateway.Method.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(httpMethod, "httpMethod is required")).toArray());
        }

        /**
         * Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.
         * @param options Default integration and method options.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.ProxyResource addProxy(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ResourceOptions options) {
            return this.jsiiCall("addProxy", software.amazon.awscdk.services.apigateway.ProxyResource.class, java.util.stream.Stream.of(options).toArray());
        }

        /**
         * Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.ProxyResource addProxy() {
            return this.jsiiCall("addProxy", software.amazon.awscdk.services.apigateway.ProxyResource.class);
        }

        /**
         * Defines a new child resource where this resource is the parent.
         * @return A Resource object
         * @param pathPart The path part for the child resource
         * @param options Resource options
         */
        @Override
        public software.amazon.awscdk.services.apigateway.Resource addResource(final java.lang.String pathPart, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ResourceOptions options) {
            return this.jsiiCall("addResource", software.amazon.awscdk.services.apigateway.Resource.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(pathPart, "pathPart is required")), java.util.stream.Stream.of(options)).toArray());
        }

        /**
         * Defines a new child resource where this resource is the parent.
         * @return A Resource object
         * @param pathPart The path part for the child resource
         */
        @Override
        public software.amazon.awscdk.services.apigateway.Resource addResource(final java.lang.String pathPart) {
            return this.jsiiCall("addResource", software.amazon.awscdk.services.apigateway.Resource.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(pathPart, "pathPart is required")).toArray());
        }
    }
}
