package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-19T14:00:32.210Z")
public interface MethodProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
     */
    java.lang.String getHttpMethod();
    /**
     * The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
     */
    void setHttpMethod(final java.lang.String value);
    /**
     * The resource this method is associated with. For root resource methods,
     * specify the `RestApi` object.
     */
    software.amazon.awscdk.services.apigateway.IRestApiResource getResource();
    /**
     * The resource this method is associated with. For root resource methods,
     * specify the `RestApi` object.
     */
    void setResource(final software.amazon.awscdk.services.apigateway.IRestApiResource value);
    /**
     * The backend system that the method calls when it receives a request.
     */
    software.amazon.awscdk.services.apigateway.Integration getIntegration();
    /**
     * The backend system that the method calls when it receives a request.
     */
    void setIntegration(final software.amazon.awscdk.services.apigateway.Integration value);
    /**
     * Method options.
     */
    software.amazon.awscdk.services.apigateway.MethodOptions getOptions();
    /**
     * Method options.
     */
    void setOptions(final software.amazon.awscdk.services.apigateway.MethodOptions value);

    /**
     * @return a {@link Builder} of {@link MethodProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MethodProps}
     */
    final class Builder {
        private java.lang.String _httpMethod;
        private software.amazon.awscdk.services.apigateway.IRestApiResource _resource;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Integration _integration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodOptions _options;

        /**
         * Sets the value of HttpMethod
         * @param value The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
         * @return {@code this}
         */
        public Builder withHttpMethod(final java.lang.String value) {
            this._httpMethod = java.util.Objects.requireNonNull(value, "httpMethod is required");
            return this;
        }
        /**
         * Sets the value of Resource
         * @param value The resource this method is associated with. For root resource methods,
specify the `RestApi` object.
         * @return {@code this}
         */
        public Builder withResource(final software.amazon.awscdk.services.apigateway.IRestApiResource value) {
            this._resource = java.util.Objects.requireNonNull(value, "resource is required");
            return this;
        }
        /**
         * Sets the value of Integration
         * @param value The backend system that the method calls when it receives a request.
         * @return {@code this}
         */
        public Builder withIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this._integration = value;
            return this;
        }
        /**
         * Sets the value of Options
         * @param value Method options.
         * @return {@code this}
         */
        public Builder withOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this._options = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public MethodProps build() {
            return new MethodProps() {
                private java.lang.String $httpMethod = java.util.Objects.requireNonNull(_httpMethod, "httpMethod is required");
                private software.amazon.awscdk.services.apigateway.IRestApiResource $resource = java.util.Objects.requireNonNull(_resource, "resource is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.Integration $integration = _integration;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.MethodOptions $options = _options;

                @Override
                public java.lang.String getHttpMethod() {
                    return this.$httpMethod;
                }

                @Override
                public void setHttpMethod(final java.lang.String value) {
                    this.$httpMethod = java.util.Objects.requireNonNull(value, "httpMethod is required");
                }

                @Override
                public software.amazon.awscdk.services.apigateway.IRestApiResource getResource() {
                    return this.$resource;
                }

                @Override
                public void setResource(final software.amazon.awscdk.services.apigateway.IRestApiResource value) {
                    this.$resource = java.util.Objects.requireNonNull(value, "resource is required");
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Integration getIntegration() {
                    return this.$integration;
                }

                @Override
                public void setIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
                    this.$integration = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodOptions getOptions() {
                    return this.$options;
                }

                @Override
                public void setOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
                    this.$options = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.MethodProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
         */
        @Override
        public java.lang.String getHttpMethod() {
            return this.jsiiGet("httpMethod", java.lang.String.class);
        }

        /**
         * The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
         */
        @Override
        public void setHttpMethod(final java.lang.String value) {
            this.jsiiSet("httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
        }

        /**
         * The resource this method is associated with. For root resource methods,
         * specify the `RestApi` object.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.IRestApiResource getResource() {
            return this.jsiiGet("resource", software.amazon.awscdk.services.apigateway.IRestApiResource.class);
        }

        /**
         * The resource this method is associated with. For root resource methods,
         * specify the `RestApi` object.
         */
        @Override
        public void setResource(final software.amazon.awscdk.services.apigateway.IRestApiResource value) {
            this.jsiiSet("resource", java.util.Objects.requireNonNull(value, "resource is required"));
        }

        /**
         * The backend system that the method calls when it receives a request.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getIntegration() {
            return this.jsiiGet("integration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * The backend system that the method calls when it receives a request.
         */
        @Override
        public void setIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this.jsiiSet("integration", value);
        }

        /**
         * Method options.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getOptions() {
            return this.jsiiGet("options", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }

        /**
         * Method options.
         */
        @Override
        public void setOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this.jsiiSet("options", value);
        }
    }
}
