package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T12:18:18.394Z")
public interface DeploymentProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Rest API to deploy.
     */
    software.amazon.awscdk.services.apigateway.RestApiRef getApi();
    /**
     * The Rest API to deploy.
     */
    void setApi(final software.amazon.awscdk.services.apigateway.RestApiRef value);
    /**
     * A description of the purpose of the API Gateway deployment.
     */
    java.lang.String getDescription();
    /**
     * A description of the purpose of the API Gateway deployment.
     */
    void setDescription(final java.lang.String value);
    /**
     * When an API Gateway model is updated, a new deployment will automatically be created.
     * If this is true (default), the old API Gateway Deployment resource will not be deleted.
     * This will allow manually reverting back to a previous deployment in case for example
     * @default false
     */
    java.lang.Boolean getRetainDeployments();
    /**
     * When an API Gateway model is updated, a new deployment will automatically be created.
     * If this is true (default), the old API Gateway Deployment resource will not be deleted.
     * This will allow manually reverting back to a previous deployment in case for example
     * @default false
     */
    void setRetainDeployments(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link DeploymentProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DeploymentProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.apigateway.RestApiRef _api;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _retainDeployments;

        /**
         * Sets the value of Api
         * @param value The Rest API to deploy.
         * @return {@code this}
         */
        public Builder withApi(final software.amazon.awscdk.services.apigateway.RestApiRef value) {
            this._api = java.util.Objects.requireNonNull(value, "api is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the API Gateway deployment.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of RetainDeployments
         * @param value When an API Gateway model is updated, a new deployment will automatically be created.
If this is true (default), the old API Gateway Deployment resource will not be deleted.
This will allow manually reverting back to a previous deployment in case for example
         * @return {@code this}
         */
        public Builder withRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._retainDeployments = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public DeploymentProps build() {
            return new DeploymentProps() {
                private software.amazon.awscdk.services.apigateway.RestApiRef $api = java.util.Objects.requireNonNull(_api, "api is required");
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.lang.Boolean $retainDeployments = _retainDeployments;

                @Override
                public software.amazon.awscdk.services.apigateway.RestApiRef getApi() {
                    return this.$api;
                }

                @Override
                public void setApi(final software.amazon.awscdk.services.apigateway.RestApiRef value) {
                    this.$api = java.util.Objects.requireNonNull(value, "api is required");
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.lang.Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                @Override
                public void setRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$retainDeployments = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.DeploymentProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Rest API to deploy.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.RestApiRef getApi() {
            return this.jsiiGet("api", software.amazon.awscdk.services.apigateway.RestApiRef.class);
        }

        /**
         * The Rest API to deploy.
         */
        @Override
        public void setApi(final software.amazon.awscdk.services.apigateway.RestApiRef value) {
            this.jsiiSet("api", java.util.Objects.requireNonNull(value, "api is required"));
        }

        /**
         * A description of the purpose of the API Gateway deployment.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A description of the purpose of the API Gateway deployment.
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * When an API Gateway model is updated, a new deployment will automatically be created.
         * If this is true (default), the old API Gateway Deployment resource will not be deleted.
         * This will allow manually reverting back to a previous deployment in case for example
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getRetainDeployments() {
            return this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }

        /**
         * When an API Gateway model is updated, a new deployment will automatically be created.
         * If this is true (default), the old API Gateway Deployment resource will not be deleted.
         * This will allow manually reverting back to a previous deployment in case for example
         * @default false
         */
        @Override
        public void setRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("retainDeployments", value);
        }
    }
}
