package software.amazon.awscdk.services.apigateway.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T12:18:18.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.ApiKeyResource")
public class ApiKeyResource extends software.amazon.awscdk.Resource {
    protected ApiKeyResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::ApiKey``.
     * @param parent the ``cdk.Construct`` this ``ApiKeyResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ApiKeyResource``
     */
    public ApiKeyResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ApiGateway::ApiKey``.
     * @param parent the ``cdk.Construct`` this ``ApiKeyResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public ApiKeyResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(properties).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApiKeyId() {
        return this.jsiiGet("apiKeyId", java.lang.String.class);
    }

    public software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html
     */
    public static interface StageKeyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApiKeyResource.StageKeyProperty.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        java.lang.Object getRestApiId();
        /**
         * ``ApiKeyResource.StageKeyProperty.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        void setRestApiId(final java.lang.String value);
        /**
         * ``ApiKeyResource.StageKeyProperty.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        void setRestApiId(final software.amazon.awscdk.Token value);
        /**
         * ``ApiKeyResource.StageKeyProperty.StageName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        java.lang.Object getStageName();
        /**
         * ``ApiKeyResource.StageKeyProperty.StageName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        void setStageName(final java.lang.String value);
        /**
         * ``ApiKeyResource.StageKeyProperty.StageName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        void setStageName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link StageKeyProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StageKeyProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _restApiId;
            @javax.annotation.Nullable
            private java.lang.Object _stageName;

            /**
             * Sets the value of RestApiId
             * @param value ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @return {@code this}
             */
            public Builder withRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                this._restApiId = value;
                return this;
            }
            /**
             * Sets the value of RestApiId
             * @param value ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @return {@code this}
             */
            public Builder withRestApiId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._restApiId = value;
                return this;
            }
            /**
             * Sets the value of StageName
             * @param value ``ApiKeyResource.StageKeyProperty.StageName``
             * @return {@code this}
             */
            public Builder withStageName(@javax.annotation.Nullable final java.lang.String value) {
                this._stageName = value;
                return this;
            }
            /**
             * Sets the value of StageName
             * @param value ``ApiKeyResource.StageKeyProperty.StageName``
             * @return {@code this}
             */
            public Builder withStageName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._stageName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StageKeyProperty build() {
                return new StageKeyProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $restApiId = _restApiId;
                    @javax.annotation.Nullable
                    private java.lang.Object $stageName = _stageName;

                    @Override
                    public java.lang.Object getRestApiId() {
                        return this.$restApiId;
                    }

                    @Override
                    public void setRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$restApiId = value;
                    }

                    @Override
                    public void setRestApiId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$restApiId = value;
                    }

                    @Override
                    public java.lang.Object getStageName() {
                        return this.$stageName;
                    }

                    @Override
                    public void setStageName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$stageName = value;
                    }

                    @Override
                    public void setStageName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$stageName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResource.StageKeyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRestApiId() {
                return this.jsiiGet("restApiId", java.lang.Object.class);
            }

            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            @Override
            public void setRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("restApiId", value);
            }

            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            @Override
            public void setRestApiId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("restApiId", value);
            }

            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getStageName() {
                return this.jsiiGet("stageName", java.lang.Object.class);
            }

            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            @Override
            public void setStageName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("stageName", value);
            }

            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            @Override
            public void setStageName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("stageName", value);
            }
        }
    }
}
