package software.amazon.awscdk.services.apigateway.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T12:18:18.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.StageResource")
public class StageResource extends software.amazon.awscdk.Resource {
    protected StageResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.StageResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::Stage``.
     * @param parent the ``cdk.Construct`` this ``StageResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``StageResource``
     */
    public StageResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.apigateway.cloudformation.StageResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(properties).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.apigateway.cloudformation.StageResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.cloudformation.StageResourceProps.class);
    }

    public java.lang.String getStageName() {
        return this.jsiiGet("stageName", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``StageResource.AccessLogSettingProperty.DestinationArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        java.lang.Object getDestinationArn();
        /**
         * ``StageResource.AccessLogSettingProperty.DestinationArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        void setDestinationArn(final java.lang.String value);
        /**
         * ``StageResource.AccessLogSettingProperty.DestinationArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        void setDestinationArn(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.AccessLogSettingProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        java.lang.Object getFormat();
        /**
         * ``StageResource.AccessLogSettingProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        void setFormat(final java.lang.String value);
        /**
         * ``StageResource.AccessLogSettingProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        void setFormat(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _destinationArn;
            @javax.annotation.Nullable
            private java.lang.Object _format;

            /**
             * Sets the value of DestinationArn
             * @param value ``StageResource.AccessLogSettingProperty.DestinationArn``
             * @return {@code this}
             */
            public Builder withDestinationArn(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationArn = value;
                return this;
            }
            /**
             * Sets the value of DestinationArn
             * @param value ``StageResource.AccessLogSettingProperty.DestinationArn``
             * @return {@code this}
             */
            public Builder withDestinationArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._destinationArn = value;
                return this;
            }
            /**
             * Sets the value of Format
             * @param value ``StageResource.AccessLogSettingProperty.Format``
             * @return {@code this}
             */
            public Builder withFormat(@javax.annotation.Nullable final java.lang.String value) {
                this._format = value;
                return this;
            }
            /**
             * Sets the value of Format
             * @param value ``StageResource.AccessLogSettingProperty.Format``
             * @return {@code this}
             */
            public Builder withFormat(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._format = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccessLogSettingProperty build() {
                return new AccessLogSettingProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $destinationArn = _destinationArn;
                    @javax.annotation.Nullable
                    private java.lang.Object $format = _format;

                    @Override
                    public java.lang.Object getDestinationArn() {
                        return this.$destinationArn;
                    }

                    @Override
                    public void setDestinationArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationArn = value;
                    }

                    @Override
                    public void setDestinationArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$destinationArn = value;
                    }

                    @Override
                    public java.lang.Object getFormat() {
                        return this.$format;
                    }

                    @Override
                    public void setFormat(@javax.annotation.Nullable final java.lang.String value) {
                        this.$format = value;
                    }

                    @Override
                    public void setFormat(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$format = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.StageResource.AccessLogSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``StageResource.AccessLogSettingProperty.DestinationArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDestinationArn() {
                return this.jsiiGet("destinationArn", java.lang.Object.class);
            }

            /**
             * ``StageResource.AccessLogSettingProperty.DestinationArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
             */
            @Override
            public void setDestinationArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationArn", value);
            }

            /**
             * ``StageResource.AccessLogSettingProperty.DestinationArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
             */
            @Override
            public void setDestinationArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationArn", value);
            }

            /**
             * ``StageResource.AccessLogSettingProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFormat() {
                return this.jsiiGet("format", java.lang.Object.class);
            }

            /**
             * ``StageResource.AccessLogSettingProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
             */
            @Override
            public void setFormat(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("format", value);
            }

            /**
             * ``StageResource.AccessLogSettingProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
             */
            @Override
            public void setFormat(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("format", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html
     */
    public static interface CanarySettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``StageResource.CanarySettingProperty.DeploymentId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
         */
        java.lang.Object getDeploymentId();
        /**
         * ``StageResource.CanarySettingProperty.DeploymentId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
         */
        void setDeploymentId(final java.lang.String value);
        /**
         * ``StageResource.CanarySettingProperty.DeploymentId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
         */
        void setDeploymentId(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.CanarySettingProperty.PercentTraffic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
         */
        java.lang.Object getPercentTraffic();
        /**
         * ``StageResource.CanarySettingProperty.PercentTraffic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
         */
        void setPercentTraffic(final java.lang.Number value);
        /**
         * ``StageResource.CanarySettingProperty.PercentTraffic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
         */
        void setPercentTraffic(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.CanarySettingProperty.StageVariableOverrides``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
         */
        java.lang.Object getStageVariableOverrides();
        /**
         * ``StageResource.CanarySettingProperty.StageVariableOverrides``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
         */
        void setStageVariableOverrides(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.CanarySettingProperty.StageVariableOverrides``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
         */
        void setStageVariableOverrides(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``StageResource.CanarySettingProperty.UseStageCache``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
         */
        java.lang.Object getUseStageCache();
        /**
         * ``StageResource.CanarySettingProperty.UseStageCache``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
         */
        void setUseStageCache(final java.lang.Boolean value);
        /**
         * ``StageResource.CanarySettingProperty.UseStageCache``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
         */
        void setUseStageCache(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CanarySettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CanarySettingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deploymentId;
            @javax.annotation.Nullable
            private java.lang.Object _percentTraffic;
            @javax.annotation.Nullable
            private java.lang.Object _stageVariableOverrides;
            @javax.annotation.Nullable
            private java.lang.Object _useStageCache;

            /**
             * Sets the value of DeploymentId
             * @param value ``StageResource.CanarySettingProperty.DeploymentId``
             * @return {@code this}
             */
            public Builder withDeploymentId(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentId = value;
                return this;
            }
            /**
             * Sets the value of DeploymentId
             * @param value ``StageResource.CanarySettingProperty.DeploymentId``
             * @return {@code this}
             */
            public Builder withDeploymentId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deploymentId = value;
                return this;
            }
            /**
             * Sets the value of PercentTraffic
             * @param value ``StageResource.CanarySettingProperty.PercentTraffic``
             * @return {@code this}
             */
            public Builder withPercentTraffic(@javax.annotation.Nullable final java.lang.Number value) {
                this._percentTraffic = value;
                return this;
            }
            /**
             * Sets the value of PercentTraffic
             * @param value ``StageResource.CanarySettingProperty.PercentTraffic``
             * @return {@code this}
             */
            public Builder withPercentTraffic(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._percentTraffic = value;
                return this;
            }
            /**
             * Sets the value of StageVariableOverrides
             * @param value ``StageResource.CanarySettingProperty.StageVariableOverrides``
             * @return {@code this}
             */
            public Builder withStageVariableOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._stageVariableOverrides = value;
                return this;
            }
            /**
             * Sets the value of StageVariableOverrides
             * @param value ``StageResource.CanarySettingProperty.StageVariableOverrides``
             * @return {@code this}
             */
            public Builder withStageVariableOverrides(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._stageVariableOverrides = value;
                return this;
            }
            /**
             * Sets the value of UseStageCache
             * @param value ``StageResource.CanarySettingProperty.UseStageCache``
             * @return {@code this}
             */
            public Builder withUseStageCache(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._useStageCache = value;
                return this;
            }
            /**
             * Sets the value of UseStageCache
             * @param value ``StageResource.CanarySettingProperty.UseStageCache``
             * @return {@code this}
             */
            public Builder withUseStageCache(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._useStageCache = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanarySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CanarySettingProperty build() {
                return new CanarySettingProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deploymentId = _deploymentId;
                    @javax.annotation.Nullable
                    private java.lang.Object $percentTraffic = _percentTraffic;
                    @javax.annotation.Nullable
                    private java.lang.Object $stageVariableOverrides = _stageVariableOverrides;
                    @javax.annotation.Nullable
                    private java.lang.Object $useStageCache = _useStageCache;

                    @Override
                    public java.lang.Object getDeploymentId() {
                        return this.$deploymentId;
                    }

                    @Override
                    public void setDeploymentId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$deploymentId = value;
                    }

                    @Override
                    public void setDeploymentId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deploymentId = value;
                    }

                    @Override
                    public java.lang.Object getPercentTraffic() {
                        return this.$percentTraffic;
                    }

                    @Override
                    public void setPercentTraffic(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$percentTraffic = value;
                    }

                    @Override
                    public void setPercentTraffic(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$percentTraffic = value;
                    }

                    @Override
                    public java.lang.Object getStageVariableOverrides() {
                        return this.$stageVariableOverrides;
                    }

                    @Override
                    public void setStageVariableOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$stageVariableOverrides = value;
                    }

                    @Override
                    public void setStageVariableOverrides(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$stageVariableOverrides = value;
                    }

                    @Override
                    public java.lang.Object getUseStageCache() {
                        return this.$useStageCache;
                    }

                    @Override
                    public void setUseStageCache(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$useStageCache = value;
                    }

                    @Override
                    public void setUseStageCache(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$useStageCache = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.StageResource.CanarySettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``StageResource.CanarySettingProperty.DeploymentId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeploymentId() {
                return this.jsiiGet("deploymentId", java.lang.Object.class);
            }

            /**
             * ``StageResource.CanarySettingProperty.DeploymentId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
             */
            @Override
            public void setDeploymentId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentId", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.DeploymentId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
             */
            @Override
            public void setDeploymentId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deploymentId", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.PercentTraffic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPercentTraffic() {
                return this.jsiiGet("percentTraffic", java.lang.Object.class);
            }

            /**
             * ``StageResource.CanarySettingProperty.PercentTraffic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
             */
            @Override
            public void setPercentTraffic(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("percentTraffic", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.PercentTraffic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
             */
            @Override
            public void setPercentTraffic(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("percentTraffic", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.StageVariableOverrides``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getStageVariableOverrides() {
                return this.jsiiGet("stageVariableOverrides", java.lang.Object.class);
            }

            /**
             * ``StageResource.CanarySettingProperty.StageVariableOverrides``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
             */
            @Override
            public void setStageVariableOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("stageVariableOverrides", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.StageVariableOverrides``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
             */
            @Override
            public void setStageVariableOverrides(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("stageVariableOverrides", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.UseStageCache``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getUseStageCache() {
                return this.jsiiGet("useStageCache", java.lang.Object.class);
            }

            /**
             * ``StageResource.CanarySettingProperty.UseStageCache``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
             */
            @Override
            public void setUseStageCache(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("useStageCache", value);
            }

            /**
             * ``StageResource.CanarySettingProperty.UseStageCache``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
             */
            @Override
            public void setUseStageCache(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("useStageCache", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html
     */
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        java.lang.Object getCacheDataEncrypted();
        /**
         * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        void setCacheDataEncrypted(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        void setCacheDataEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        java.lang.Object getCacheTtlInSeconds();
        /**
         * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        void setCacheTtlInSeconds(final java.lang.Number value);
        /**
         * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        void setCacheTtlInSeconds(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        java.lang.Object getCachingEnabled();
        /**
         * ``StageResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        void setCachingEnabled(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        void setCachingEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        java.lang.Object getDataTraceEnabled();
        /**
         * ``StageResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        void setDataTraceEnabled(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        void setDataTraceEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        java.lang.Object getHttpMethod();
        /**
         * ``StageResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        void setHttpMethod(final java.lang.String value);
        /**
         * ``StageResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        void setHttpMethod(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        java.lang.Object getLoggingLevel();
        /**
         * ``StageResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        void setLoggingLevel(final java.lang.String value);
        /**
         * ``StageResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        void setLoggingLevel(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        java.lang.Object getMetricsEnabled();
        /**
         * ``StageResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        void setMetricsEnabled(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        void setMetricsEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        java.lang.Object getResourcePath();
        /**
         * ``StageResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        void setResourcePath(final java.lang.String value);
        /**
         * ``StageResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        void setResourcePath(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        java.lang.Object getThrottlingBurstLimit();
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final java.lang.Number value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        java.lang.Object getThrottlingRateLimit();
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        void setThrottlingRateLimit(final java.lang.Number value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        void setThrottlingRateLimit(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link MethodSettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MethodSettingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _cacheDataEncrypted;
            @javax.annotation.Nullable
            private java.lang.Object _cacheTtlInSeconds;
            @javax.annotation.Nullable
            private java.lang.Object _cachingEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _dataTraceEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _httpMethod;
            @javax.annotation.Nullable
            private java.lang.Object _loggingLevel;
            @javax.annotation.Nullable
            private java.lang.Object _metricsEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _resourcePath;
            @javax.annotation.Nullable
            private java.lang.Object _throttlingBurstLimit;
            @javax.annotation.Nullable
            private java.lang.Object _throttlingRateLimit;

            /**
             * Sets the value of CacheDataEncrypted
             * @param value ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @return {@code this}
             */
            public Builder withCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cacheDataEncrypted = value;
                return this;
            }
            /**
             * Sets the value of CacheDataEncrypted
             * @param value ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @return {@code this}
             */
            public Builder withCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheDataEncrypted = value;
                return this;
            }
            /**
             * Sets the value of CacheTtlInSeconds
             * @param value ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @return {@code this}
             */
            public Builder withCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * Sets the value of CacheTtlInSeconds
             * @param value ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @return {@code this}
             */
            public Builder withCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * Sets the value of CachingEnabled
             * @param value ``StageResource.MethodSettingProperty.CachingEnabled``
             * @return {@code this}
             */
            public Builder withCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cachingEnabled = value;
                return this;
            }
            /**
             * Sets the value of CachingEnabled
             * @param value ``StageResource.MethodSettingProperty.CachingEnabled``
             * @return {@code this}
             */
            public Builder withCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cachingEnabled = value;
                return this;
            }
            /**
             * Sets the value of DataTraceEnabled
             * @param value ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @return {@code this}
             */
            public Builder withDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._dataTraceEnabled = value;
                return this;
            }
            /**
             * Sets the value of DataTraceEnabled
             * @param value ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @return {@code this}
             */
            public Builder withDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._dataTraceEnabled = value;
                return this;
            }
            /**
             * Sets the value of HttpMethod
             * @param value ``StageResource.MethodSettingProperty.HttpMethod``
             * @return {@code this}
             */
            public Builder withHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this._httpMethod = value;
                return this;
            }
            /**
             * Sets the value of HttpMethod
             * @param value ``StageResource.MethodSettingProperty.HttpMethod``
             * @return {@code this}
             */
            public Builder withHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._httpMethod = value;
                return this;
            }
            /**
             * Sets the value of LoggingLevel
             * @param value ``StageResource.MethodSettingProperty.LoggingLevel``
             * @return {@code this}
             */
            public Builder withLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this._loggingLevel = value;
                return this;
            }
            /**
             * Sets the value of LoggingLevel
             * @param value ``StageResource.MethodSettingProperty.LoggingLevel``
             * @return {@code this}
             */
            public Builder withLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._loggingLevel = value;
                return this;
            }
            /**
             * Sets the value of MetricsEnabled
             * @param value ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @return {@code this}
             */
            public Builder withMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._metricsEnabled = value;
                return this;
            }
            /**
             * Sets the value of MetricsEnabled
             * @param value ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @return {@code this}
             */
            public Builder withMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._metricsEnabled = value;
                return this;
            }
            /**
             * Sets the value of ResourcePath
             * @param value ``StageResource.MethodSettingProperty.ResourcePath``
             * @return {@code this}
             */
            public Builder withResourcePath(@javax.annotation.Nullable final java.lang.String value) {
                this._resourcePath = value;
                return this;
            }
            /**
             * Sets the value of ResourcePath
             * @param value ``StageResource.MethodSettingProperty.ResourcePath``
             * @return {@code this}
             */
            public Builder withResourcePath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._resourcePath = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingBurstLimit
             * @param value ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @return {@code this}
             */
            public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this._throttlingBurstLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingBurstLimit
             * @param value ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @return {@code this}
             */
            public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._throttlingBurstLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingRateLimit
             * @param value ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @return {@code this}
             */
            public Builder withThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this._throttlingRateLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingRateLimit
             * @param value ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @return {@code this}
             */
            public Builder withThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._throttlingRateLimit = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MethodSettingProperty build() {
                return new MethodSettingProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $cacheDataEncrypted = _cacheDataEncrypted;
                    @javax.annotation.Nullable
                    private java.lang.Object $cacheTtlInSeconds = _cacheTtlInSeconds;
                    @javax.annotation.Nullable
                    private java.lang.Object $cachingEnabled = _cachingEnabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $dataTraceEnabled = _dataTraceEnabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $httpMethod = _httpMethod;
                    @javax.annotation.Nullable
                    private java.lang.Object $loggingLevel = _loggingLevel;
                    @javax.annotation.Nullable
                    private java.lang.Object $metricsEnabled = _metricsEnabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $resourcePath = _resourcePath;
                    @javax.annotation.Nullable
                    private java.lang.Object $throttlingBurstLimit = _throttlingBurstLimit;
                    @javax.annotation.Nullable
                    private java.lang.Object $throttlingRateLimit = _throttlingRateLimit;

                    @Override
                    public java.lang.Object getCacheDataEncrypted() {
                        return this.$cacheDataEncrypted;
                    }

                    @Override
                    public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$cacheDataEncrypted = value;
                    }

                    @Override
                    public void setCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cacheDataEncrypted = value;
                    }

                    @Override
                    public java.lang.Object getCacheTtlInSeconds() {
                        return this.$cacheTtlInSeconds;
                    }

                    @Override
                    public void setCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$cacheTtlInSeconds = value;
                    }

                    @Override
                    public void setCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cacheTtlInSeconds = value;
                    }

                    @Override
                    public java.lang.Object getCachingEnabled() {
                        return this.$cachingEnabled;
                    }

                    @Override
                    public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$cachingEnabled = value;
                    }

                    @Override
                    public void setCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cachingEnabled = value;
                    }

                    @Override
                    public java.lang.Object getDataTraceEnabled() {
                        return this.$dataTraceEnabled;
                    }

                    @Override
                    public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$dataTraceEnabled = value;
                    }

                    @Override
                    public void setDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$dataTraceEnabled = value;
                    }

                    @Override
                    public java.lang.Object getHttpMethod() {
                        return this.$httpMethod;
                    }

                    @Override
                    public void setHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                        this.$httpMethod = value;
                    }

                    @Override
                    public void setHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$httpMethod = value;
                    }

                    @Override
                    public java.lang.Object getLoggingLevel() {
                        return this.$loggingLevel;
                    }

                    @Override
                    public void setLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                        this.$loggingLevel = value;
                    }

                    @Override
                    public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$loggingLevel = value;
                    }

                    @Override
                    public java.lang.Object getMetricsEnabled() {
                        return this.$metricsEnabled;
                    }

                    @Override
                    public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$metricsEnabled = value;
                    }

                    @Override
                    public void setMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$metricsEnabled = value;
                    }

                    @Override
                    public java.lang.Object getResourcePath() {
                        return this.$resourcePath;
                    }

                    @Override
                    public void setResourcePath(@javax.annotation.Nullable final java.lang.String value) {
                        this.$resourcePath = value;
                    }

                    @Override
                    public void setResourcePath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$resourcePath = value;
                    }

                    @Override
                    public java.lang.Object getThrottlingBurstLimit() {
                        return this.$throttlingBurstLimit;
                    }

                    @Override
                    public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$throttlingBurstLimit = value;
                    }

                    @Override
                    public void setThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$throttlingBurstLimit = value;
                    }

                    @Override
                    public java.lang.Object getThrottlingRateLimit() {
                        return this.$throttlingRateLimit;
                    }

                    @Override
                    public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$throttlingRateLimit = value;
                    }

                    @Override
                    public void setThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$throttlingRateLimit = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.StageResource.MethodSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheDataEncrypted() {
                return this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            @Override
            public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            @Override
            public void setCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheTtlInSeconds() {
                return this.jsiiGet("cacheTtlInSeconds", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            @Override
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            @Override
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCachingEnabled() {
                return this.jsiiGet("cachingEnabled", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            @Override
            public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cachingEnabled", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            @Override
            public void setCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cachingEnabled", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDataTraceEnabled() {
                return this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            @Override
            public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("dataTraceEnabled", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            @Override
            public void setDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataTraceEnabled", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHttpMethod() {
                return this.jsiiGet("httpMethod", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            @Override
            public void setHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpMethod", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            @Override
            public void setHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpMethod", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLoggingLevel() {
                return this.jsiiGet("loggingLevel", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            @Override
            public void setLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("loggingLevel", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            @Override
            public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("loggingLevel", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMetricsEnabled() {
                return this.jsiiGet("metricsEnabled", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            @Override
            public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("metricsEnabled", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            @Override
            public void setMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("metricsEnabled", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResourcePath() {
                return this.jsiiGet("resourcePath", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            @Override
            public void setResourcePath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourcePath", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            @Override
            public void setResourcePath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourcePath", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingBurstLimit() {
                return this.jsiiGet("throttlingBurstLimit", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            @Override
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            @Override
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingRateLimit() {
                return this.jsiiGet("throttlingRateLimit", java.lang.Object.class);
            }

            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            @Override
            public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingRateLimit", value);
            }

            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            @Override
            public void setThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
        }
    }
}
