package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T17:58:32.925Z")
public interface RestApiProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {
    /**
     * The source of the API key for metering requests according to a usage
     * plan.
     * @default undefined metering is disabled
     */
    software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType();
    /**
     * The source of the API key for metering requests according to a usage
     * plan.
     * @default undefined metering is disabled
     */
    void setApiKeySourceType(final software.amazon.awscdk.services.apigateway.ApiKeySourceType value);
    /**
     * The list of binary media mine-types that are supported by the RestApi
     * resource, such as "image/png" or "application/octet-stream"
     * @default By default, RestApi supports only UTF-8-encoded text payloads
     */
    java.util.List<java.lang.String> getBinaryMediaTypes();
    /**
     * The list of binary media mine-types that are supported by the RestApi
     * resource, such as "image/png" or "application/octet-stream"
     * @default By default, RestApi supports only UTF-8-encoded text payloads
     */
    void setBinaryMediaTypes(final java.util.List<java.lang.String> value);
    /**
     * The ID of the API Gateway RestApi resource that you want to clone.
     */
    software.amazon.awscdk.services.apigateway.RestApiRef getCloneFrom();
    /**
     * The ID of the API Gateway RestApi resource that you want to clone.
     */
    void setCloneFrom(final software.amazon.awscdk.services.apigateway.RestApiRef value);
    /**
     * Automatically configure an AWS CloudWatch role for API Gateway.
     * @default true
     */
    java.lang.Boolean getCloudWatchRole();
    /**
     * Automatically configure an AWS CloudWatch role for API Gateway.
     * @default true
     */
    void setCloudWatchRole(final java.lang.Boolean value);
    /**
     * Indicates if a Deployment should be automatically created for this API,
     * and recreated when the API model (resources, methods) changes.
     * 
     * Since API Gateway deployments are immutable, When this option is enabled
     * (by default), an AWS::ApiGateway::Deployment resource will automatically
     * created with a logical ID that hashes the API model (methods, resources
     * and options). This means that when the model changes, the logical ID of
     * this CloudFormation resource will change, and a new deployment will be
     * created.
     * 
     * If this is set, `latestDeployment` will refer to the `Deployment` object
     * and `deploymentStage` will refer to a `Stage` that points to this
     * deployment. To customize the stage options, use the `deployStageOptions`
     * property.
     * 
     * A CloudFormation Output will also be defined with the root URL endpoint
     * of this REST API.
     * @default true
     */
    java.lang.Boolean getDeploy();
    /**
     * Indicates if a Deployment should be automatically created for this API,
     * and recreated when the API model (resources, methods) changes.
     * 
     * Since API Gateway deployments are immutable, When this option is enabled
     * (by default), an AWS::ApiGateway::Deployment resource will automatically
     * created with a logical ID that hashes the API model (methods, resources
     * and options). This means that when the model changes, the logical ID of
     * this CloudFormation resource will change, and a new deployment will be
     * created.
     * 
     * If this is set, `latestDeployment` will refer to the `Deployment` object
     * and `deploymentStage` will refer to a `Stage` that points to this
     * deployment. To customize the stage options, use the `deployStageOptions`
     * property.
     * 
     * A CloudFormation Output will also be defined with the root URL endpoint
     * of this REST API.
     * @default true
     */
    void setDeploy(final java.lang.Boolean value);
    /**
     * Options for the API Gateway stage that will always point to the latest
     * deployment when `deploy` is enabled. If `deploy` is disabled,
     * this value cannot be set.
     * @default defaults based on defaults of `StageOptions`
     */
    software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions();
    /**
     * Options for the API Gateway stage that will always point to the latest
     * deployment when `deploy` is enabled. If `deploy` is disabled,
     * this value cannot be set.
     * @default defaults based on defaults of `StageOptions`
     */
    void setDeployOptions(final software.amazon.awscdk.services.apigateway.StageOptions value);
    /**
     * A description of the purpose of this API Gateway RestApi resource.
     * @default No description
     */
    java.lang.String getDescription();
    /**
     * A description of the purpose of this API Gateway RestApi resource.
     * @default No description
     */
    void setDescription(final java.lang.String value);
    /**
     * A list of the endpoint types of the API. Use this property when creating
     * an API.
     */
    java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes();
    /**
     * A list of the endpoint types of the API. Use this property when creating
     * an API.
     */
    void setEndpointTypes(final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> value);
    /**
     * Indicates whether to roll back the resource if a warning occurs while API
     * Gateway is creating the RestApi resource.
     * @default false
     */
    java.lang.Boolean getFailOnWarnings();
    /**
     * Indicates whether to roll back the resource if a warning occurs while API
     * Gateway is creating the RestApi resource.
     * @default false
     */
    void setFailOnWarnings(final java.lang.Boolean value);
    /**
     * A nullable integer that is used to enable compression (with non-negative
     * between 0 and 10485760 (10M) bytes, inclusive) or disable compression
     * (when undefined) on an API. When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is
     * smaller than this value. Setting it to zero allows compression for any
     * payload size.
     * @default undefined compression is disabled
     */
    java.lang.Number getMinimumCompressionSize();
    /**
     * A nullable integer that is used to enable compression (with non-negative
     * between 0 and 10485760 (10M) bytes, inclusive) or disable compression
     * (when undefined) on an API. When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is
     * smaller than this value. Setting it to zero allows compression for any
     * payload size.
     * @default undefined compression is disabled
     */
    void setMinimumCompressionSize(final java.lang.Number value);
    /**
     * Custom header parameters for the request.
     * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
     */
    java.util.Map<java.lang.String, java.lang.String> getParameters();
    /**
     * Custom header parameters for the request.
     * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
     */
    void setParameters(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * A policy document that contains the permissions for this RestApi
     */
    software.amazon.awscdk.services.iam.PolicyDocument getPolicy();
    /**
     * A policy document that contains the permissions for this RestApi
     */
    void setPolicy(final software.amazon.awscdk.services.iam.PolicyDocument value);
    /**
     * A name for the API Gateway RestApi resource.
     * @default construct-id defaults to the id of the RestApi construct
     */
    java.lang.String getRestApiName();
    /**
     * A name for the API Gateway RestApi resource.
     * @default construct-id defaults to the id of the RestApi construct
     */
    void setRestApiName(final java.lang.String value);
    /**
     * Retains old deployment resources when the API changes. This allows
     * manually reverting stages to point to old deployments via the AWS
     * Console.
     * @default false
     */
    java.lang.Boolean getRetainDeployments();
    /**
     * Retains old deployment resources when the API changes. This allows
     * manually reverting stages to point to old deployments via the AWS
     * Console.
     * @default false
     */
    void setRetainDeployments(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link RestApiProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RestApiProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ApiKeySourceType _apiKeySourceType;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _binaryMediaTypes;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.RestApiRef _cloneFrom;
        @javax.annotation.Nullable
        private java.lang.Boolean _cloudWatchRole;
        @javax.annotation.Nullable
        private java.lang.Boolean _deploy;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.StageOptions _deployOptions;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> _endpointTypes;
        @javax.annotation.Nullable
        private java.lang.Boolean _failOnWarnings;
        @javax.annotation.Nullable
        private java.lang.Number _minimumCompressionSize;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _parameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.PolicyDocument _policy;
        @javax.annotation.Nullable
        private java.lang.String _restApiName;
        @javax.annotation.Nullable
        private java.lang.Boolean _retainDeployments;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Integration _defaultIntegration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodOptions _defaultMethodOptions;

        /**
         * Sets the value of ApiKeySourceType
         * @param value The source of the API key for metering requests according to a usage
plan.
         * @return {@code this}
         */
        public Builder withApiKeySourceType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ApiKeySourceType value) {
            this._apiKeySourceType = value;
            return this;
        }
        /**
         * Sets the value of BinaryMediaTypes
         * @param value The list of binary media mine-types that are supported by the RestApi
resource, such as "image/png" or "application/octet-stream"
         * @return {@code this}
         */
        public Builder withBinaryMediaTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._binaryMediaTypes = value;
            return this;
        }
        /**
         * Sets the value of CloneFrom
         * @param value The ID of the API Gateway RestApi resource that you want to clone.
         * @return {@code this}
         */
        public Builder withCloneFrom(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.RestApiRef value) {
            this._cloneFrom = value;
            return this;
        }
        /**
         * Sets the value of CloudWatchRole
         * @param value Automatically configure an AWS CloudWatch role for API Gateway.
         * @return {@code this}
         */
        public Builder withCloudWatchRole(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cloudWatchRole = value;
            return this;
        }
        /**
         * Sets the value of Deploy
         * @param value Indicates if a Deployment should be automatically created for this API,
and recreated when the API model (resources, methods) changes.

Since API Gateway deployments are immutable, When this option is enabled
(by default), an AWS::ApiGateway::Deployment resource will automatically
created with a logical ID that hashes the API model (methods, resources
and options). This means that when the model changes, the logical ID of
this CloudFormation resource will change, and a new deployment will be
created.

If this is set, `latestDeployment` will refer to the `Deployment` object
and `deploymentStage` will refer to a `Stage` that points to this
deployment. To customize the stage options, use the `deployStageOptions`
property.

A CloudFormation Output will also be defined with the root URL endpoint
of this REST API.
         * @return {@code this}
         */
        public Builder withDeploy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deploy = value;
            return this;
        }
        /**
         * Sets the value of DeployOptions
         * @param value Options for the API Gateway stage that will always point to the latest
deployment when `deploy` is enabled. If `deploy` is disabled,
this value cannot be set.
         * @return {@code this}
         */
        public Builder withDeployOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.StageOptions value) {
            this._deployOptions = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of this API Gateway RestApi resource.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of EndpointTypes
         * @param value A list of the endpoint types of the API. Use this property when creating
an API.
         * @return {@code this}
         */
        public Builder withEndpointTypes(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> value) {
            this._endpointTypes = value;
            return this;
        }
        /**
         * Sets the value of FailOnWarnings
         * @param value Indicates whether to roll back the resource if a warning occurs while API
Gateway is creating the RestApi resource.
         * @return {@code this}
         */
        public Builder withFailOnWarnings(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._failOnWarnings = value;
            return this;
        }
        /**
         * Sets the value of MinimumCompressionSize
         * @param value A nullable integer that is used to enable compression (with non-negative
between 0 and 10485760 (10M) bytes, inclusive) or disable compression
(when undefined) on an API. When compression is enabled, compression or
decompression is not applied on the payload if the payload size is
smaller than this value. Setting it to zero allows compression for any
payload size.
         * @return {@code this}
         */
        public Builder withMinimumCompressionSize(@javax.annotation.Nullable final java.lang.Number value) {
            this._minimumCompressionSize = value;
            return this;
        }
        /**
         * Sets the value of Parameters
         * @param value Custom header parameters for the request.
         * @return {@code this}
         */
        public Builder withParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._parameters = value;
            return this;
        }
        /**
         * Sets the value of Policy
         * @param value A policy document that contains the permissions for this RestApi
         * @return {@code this}
         */
        public Builder withPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyDocument value) {
            this._policy = value;
            return this;
        }
        /**
         * Sets the value of RestApiName
         * @param value A name for the API Gateway RestApi resource.
         * @return {@code this}
         */
        public Builder withRestApiName(@javax.annotation.Nullable final java.lang.String value) {
            this._restApiName = value;
            return this;
        }
        /**
         * Sets the value of RetainDeployments
         * @param value Retains old deployment resources when the API changes. This allows
manually reverting stages to point to old deployments via the AWS
Console.
         * @return {@code this}
         */
        public Builder withRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._retainDeployments = value;
            return this;
        }
        /**
         * Sets the value of DefaultIntegration
         * @param value An integration to use as a default for all methods created within this
API unless an integration is specified.
         * @return {@code this}
         */
        public Builder withDefaultIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this._defaultIntegration = value;
            return this;
        }
        /**
         * Sets the value of DefaultMethodOptions
         * @param value Method options to use as a default for all methods created within this
API unless custom options are specified.
         * @return {@code this}
         */
        public Builder withDefaultMethodOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public RestApiProps build() {
            return new RestApiProps() {
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.ApiKeySourceType $apiKeySourceType = _apiKeySourceType;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $binaryMediaTypes = _binaryMediaTypes;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.RestApiRef $cloneFrom = _cloneFrom;
                @javax.annotation.Nullable
                private java.lang.Boolean $cloudWatchRole = _cloudWatchRole;
                @javax.annotation.Nullable
                private java.lang.Boolean $deploy = _deploy;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.StageOptions $deployOptions = _deployOptions;
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> $endpointTypes = _endpointTypes;
                @javax.annotation.Nullable
                private java.lang.Boolean $failOnWarnings = _failOnWarnings;
                @javax.annotation.Nullable
                private java.lang.Number $minimumCompressionSize = _minimumCompressionSize;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $parameters = _parameters;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.iam.PolicyDocument $policy = _policy;
                @javax.annotation.Nullable
                private java.lang.String $restApiName = _restApiName;
                @javax.annotation.Nullable
                private java.lang.Boolean $retainDeployments = _retainDeployments;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.Integration $defaultIntegration = _defaultIntegration;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.MethodOptions $defaultMethodOptions = _defaultMethodOptions;

                @Override
                public software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
                    return this.$apiKeySourceType;
                }

                @Override
                public void setApiKeySourceType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ApiKeySourceType value) {
                    this.$apiKeySourceType = value;
                }

                @Override
                public java.util.List<java.lang.String> getBinaryMediaTypes() {
                    return this.$binaryMediaTypes;
                }

                @Override
                public void setBinaryMediaTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$binaryMediaTypes = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.RestApiRef getCloneFrom() {
                    return this.$cloneFrom;
                }

                @Override
                public void setCloneFrom(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.RestApiRef value) {
                    this.$cloneFrom = value;
                }

                @Override
                public java.lang.Boolean getCloudWatchRole() {
                    return this.$cloudWatchRole;
                }

                @Override
                public void setCloudWatchRole(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$cloudWatchRole = value;
                }

                @Override
                public java.lang.Boolean getDeploy() {
                    return this.$deploy;
                }

                @Override
                public void setDeploy(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$deploy = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
                    return this.$deployOptions;
                }

                @Override
                public void setDeployOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.StageOptions value) {
                    this.$deployOptions = value;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
                    return this.$endpointTypes;
                }

                @Override
                public void setEndpointTypes(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> value) {
                    this.$endpointTypes = value;
                }

                @Override
                public java.lang.Boolean getFailOnWarnings() {
                    return this.$failOnWarnings;
                }

                @Override
                public void setFailOnWarnings(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$failOnWarnings = value;
                }

                @Override
                public java.lang.Number getMinimumCompressionSize() {
                    return this.$minimumCompressionSize;
                }

                @Override
                public void setMinimumCompressionSize(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$minimumCompressionSize = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getParameters() {
                    return this.$parameters;
                }

                @Override
                public void setParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$parameters = value;
                }

                @Override
                public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
                    return this.$policy;
                }

                @Override
                public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyDocument value) {
                    this.$policy = value;
                }

                @Override
                public java.lang.String getRestApiName() {
                    return this.$restApiName;
                }

                @Override
                public void setRestApiName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$restApiName = value;
                }

                @Override
                public java.lang.Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                @Override
                public void setRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$retainDeployments = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.RestApiProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The source of the API key for metering requests according to a usage
         * plan.
         * @default undefined metering is disabled
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
            return this.jsiiGet("apiKeySourceType", software.amazon.awscdk.services.apigateway.ApiKeySourceType.class);
        }

        /**
         * The source of the API key for metering requests according to a usage
         * plan.
         * @default undefined metering is disabled
         */
        @Override
        public void setApiKeySourceType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ApiKeySourceType value) {
            this.jsiiSet("apiKeySourceType", value);
        }

        /**
         * The list of binary media mine-types that are supported by the RestApi
         * resource, such as "image/png" or "application/octet-stream"
         * @default By default, RestApi supports only UTF-8-encoded text payloads
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.jsiiGet("binaryMediaTypes", java.util.List.class);
        }

        /**
         * The list of binary media mine-types that are supported by the RestApi
         * resource, such as "image/png" or "application/octet-stream"
         * @default By default, RestApi supports only UTF-8-encoded text payloads
         */
        @Override
        public void setBinaryMediaTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("binaryMediaTypes", value);
        }

        /**
         * The ID of the API Gateway RestApi resource that you want to clone.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.RestApiRef getCloneFrom() {
            return this.jsiiGet("cloneFrom", software.amazon.awscdk.services.apigateway.RestApiRef.class);
        }

        /**
         * The ID of the API Gateway RestApi resource that you want to clone.
         */
        @Override
        public void setCloneFrom(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.RestApiRef value) {
            this.jsiiSet("cloneFrom", value);
        }

        /**
         * Automatically configure an AWS CloudWatch role for API Gateway.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getCloudWatchRole() {
            return this.jsiiGet("cloudWatchRole", java.lang.Boolean.class);
        }

        /**
         * Automatically configure an AWS CloudWatch role for API Gateway.
         * @default true
         */
        @Override
        public void setCloudWatchRole(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("cloudWatchRole", value);
        }

        /**
         * Indicates if a Deployment should be automatically created for this API,
         * and recreated when the API model (resources, methods) changes.
         * 
         * Since API Gateway deployments are immutable, When this option is enabled
         * (by default), an AWS::ApiGateway::Deployment resource will automatically
         * created with a logical ID that hashes the API model (methods, resources
         * and options). This means that when the model changes, the logical ID of
         * this CloudFormation resource will change, and a new deployment will be
         * created.
         * 
         * If this is set, `latestDeployment` will refer to the `Deployment` object
         * and `deploymentStage` will refer to a `Stage` that points to this
         * deployment. To customize the stage options, use the `deployStageOptions`
         * property.
         * 
         * A CloudFormation Output will also be defined with the root URL endpoint
         * of this REST API.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeploy() {
            return this.jsiiGet("deploy", java.lang.Boolean.class);
        }

        /**
         * Indicates if a Deployment should be automatically created for this API,
         * and recreated when the API model (resources, methods) changes.
         * 
         * Since API Gateway deployments are immutable, When this option is enabled
         * (by default), an AWS::ApiGateway::Deployment resource will automatically
         * created with a logical ID that hashes the API model (methods, resources
         * and options). This means that when the model changes, the logical ID of
         * this CloudFormation resource will change, and a new deployment will be
         * created.
         * 
         * If this is set, `latestDeployment` will refer to the `Deployment` object
         * and `deploymentStage` will refer to a `Stage` that points to this
         * deployment. To customize the stage options, use the `deployStageOptions`
         * property.
         * 
         * A CloudFormation Output will also be defined with the root URL endpoint
         * of this REST API.
         * @default true
         */
        @Override
        public void setDeploy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("deploy", value);
        }

        /**
         * Options for the API Gateway stage that will always point to the latest
         * deployment when `deploy` is enabled. If `deploy` is disabled,
         * this value cannot be set.
         * @default defaults based on defaults of `StageOptions`
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
            return this.jsiiGet("deployOptions", software.amazon.awscdk.services.apigateway.StageOptions.class);
        }

        /**
         * Options for the API Gateway stage that will always point to the latest
         * deployment when `deploy` is enabled. If `deploy` is disabled,
         * this value cannot be set.
         * @default defaults based on defaults of `StageOptions`
         */
        @Override
        public void setDeployOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.StageOptions value) {
            this.jsiiSet("deployOptions", value);
        }

        /**
         * A description of the purpose of this API Gateway RestApi resource.
         * @default No description
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A description of the purpose of this API Gateway RestApi resource.
         * @default No description
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * A list of the endpoint types of the API. Use this property when creating
         * an API.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
            return this.jsiiGet("endpointTypes", java.util.List.class);
        }

        /**
         * A list of the endpoint types of the API. Use this property when creating
         * an API.
         */
        @Override
        public void setEndpointTypes(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> value) {
            this.jsiiSet("endpointTypes", value);
        }

        /**
         * Indicates whether to roll back the resource if a warning occurs while API
         * Gateway is creating the RestApi resource.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getFailOnWarnings() {
            return this.jsiiGet("failOnWarnings", java.lang.Boolean.class);
        }

        /**
         * Indicates whether to roll back the resource if a warning occurs while API
         * Gateway is creating the RestApi resource.
         * @default false
         */
        @Override
        public void setFailOnWarnings(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("failOnWarnings", value);
        }

        /**
         * A nullable integer that is used to enable compression (with non-negative
         * between 0 and 10485760 (10M) bytes, inclusive) or disable compression
         * (when undefined) on an API. When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is
         * smaller than this value. Setting it to zero allows compression for any
         * payload size.
         * @default undefined compression is disabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMinimumCompressionSize() {
            return this.jsiiGet("minimumCompressionSize", java.lang.Number.class);
        }

        /**
         * A nullable integer that is used to enable compression (with non-negative
         * between 0 and 10485760 (10M) bytes, inclusive) or disable compression
         * (when undefined) on an API. When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is
         * smaller than this value. Setting it to zero allows compression for any
         * payload size.
         * @default undefined compression is disabled
         */
        @Override
        public void setMinimumCompressionSize(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("minimumCompressionSize", value);
        }

        /**
         * Custom header parameters for the request.
         * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.jsiiGet("parameters", java.util.Map.class);
        }

        /**
         * Custom header parameters for the request.
         * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
         */
        @Override
        public void setParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("parameters", value);
        }

        /**
         * A policy document that contains the permissions for this RestApi
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.jsiiGet("policy", software.amazon.awscdk.services.iam.PolicyDocument.class);
        }

        /**
         * A policy document that contains the permissions for this RestApi
         */
        @Override
        public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyDocument value) {
            this.jsiiSet("policy", value);
        }

        /**
         * A name for the API Gateway RestApi resource.
         * @default construct-id defaults to the id of the RestApi construct
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRestApiName() {
            return this.jsiiGet("restApiName", java.lang.String.class);
        }

        /**
         * A name for the API Gateway RestApi resource.
         * @default construct-id defaults to the id of the RestApi construct
         */
        @Override
        public void setRestApiName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("restApiName", value);
        }

        /**
         * Retains old deployment resources when the API changes. This allows
         * manually reverting stages to point to old deployments via the AWS
         * Console.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getRetainDeployments() {
            return this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }

        /**
         * Retains old deployment resources when the API changes. This allows
         * manually reverting stages to point to old deployments via the AWS
         * Console.
         * @default false
         */
        @Override
        public void setRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("retainDeployments", value);
        }

        /**
         * An integration to use as a default for all methods created within this
         * API unless an integration is specified.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * Method options to use as a default for all methods created within this
         * API unless custom options are specified.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }
    }
}
