package software.amazon.awscdk.services.apigateway;

/**
 * Represents a REST API in Amazon API Gateway.
 * 
 * Use `addResource` and `addMethod` to configure the API model.
 * 
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-06T17:21:49.857Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApi")
public class RestApi extends software.amazon.awscdk.services.apigateway.RestApiRef implements software.amazon.awscdk.IDependable {
    protected RestApi(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public RestApi(final software.amazon.awscdk.Construct parent, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.RestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    public RestApi(final software.amazon.awscdk.Construct parent, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    /**
     * @default "*" returns the execute API ARN for all methods/resources in this API.
     * @return The "execute-api" ARN.
     * @param method The method (default `*`)
     * @param path The resource path. Must start with '/' (default `*`)
     * @param stage The stage (default `*`)
     */
    public java.lang.String executeApiArn(@javax.annotation.Nullable final java.lang.String method, @javax.annotation.Nullable final java.lang.String path, @javax.annotation.Nullable final java.lang.String stage) {
        return this.jsiiCall("executeApiArn", java.lang.String.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(method), java.util.stream.Stream.of(path)), java.util.stream.Stream.of(stage)).toArray());
    }

    /**
     * @default "*" returns the execute API ARN for all methods/resources in this API.
     * @return The "execute-api" ARN.
     * @param method The method (default `*`)
     * @param path The resource path. Must start with '/' (default `*`)
     */
    public java.lang.String executeApiArn(@javax.annotation.Nullable final java.lang.String method, @javax.annotation.Nullable final java.lang.String path) {
        return this.jsiiCall("executeApiArn", java.lang.String.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(method), java.util.stream.Stream.of(path)).toArray());
    }

    /**
     * @default "*" returns the execute API ARN for all methods/resources in this API.
     * @return The "execute-api" ARN.
     * @param method The method (default `*`)
     */
    public java.lang.String executeApiArn(@javax.annotation.Nullable final java.lang.String method) {
        return this.jsiiCall("executeApiArn", java.lang.String.class, java.util.stream.Stream.of(method).toArray());
    }

    /**
     * @default "*" returns the execute API ARN for all methods/resources in this API.
     * @return The "execute-api" ARN.
     */
    public java.lang.String executeApiArn() {
        return this.jsiiCall("executeApiArn", java.lang.String.class);
    }

    /**
     * Returns the URL for an HTTP path.
     * 
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     */
    public java.lang.String urlForPath(@javax.annotation.Nullable final java.lang.String path) {
        return this.jsiiCall("urlForPath", java.lang.String.class, java.util.stream.Stream.of(path).toArray());
    }

    /**
     * Returns the URL for an HTTP path.
     * 
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     */
    public java.lang.String urlForPath() {
        return this.jsiiCall("urlForPath", java.lang.String.class);
    }

    /**
     * Performs validation of the REST API.
     */
    @Override
    public java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * Allows taking a dependency on this construct.
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    /**
     * The ID of this API Gateway RestApi.
     */
    @Override
    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * Represents the root resource ("/") of this API. Use it to define the API model:
     * 
     *     api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
     *     api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"
     */
    public software.amazon.awscdk.services.apigateway.IRestApiResource getRoot() {
        return this.jsiiGet("root", software.amazon.awscdk.services.apigateway.IRestApiResource.class);
    }

    /**
     * The deployed root URL of this REST API.
     */
    public java.lang.String getUrl() {
        return this.jsiiGet("url", java.lang.String.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * 
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
        return this.jsiiGet("deploymentStage", software.amazon.awscdk.services.apigateway.Stage.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * 
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    public void setDeploymentStage(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Stage value) {
        this.jsiiSet("deploymentStage", value);
    }

    /**
     * API Gateway deployment that represents the latest changes of the API.
     * This resource will be automatically updated every time the REST API model changes.
     * This will be undefined if `deploy` is false.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
        return this.jsiiGet("latestDeployment", software.amazon.awscdk.services.apigateway.Deployment.class);
    }

    /**
     * API Gateway deployment that represents the latest changes of the API.
     * This resource will be automatically updated every time the REST API model changes.
     * This will be undefined if `deploy` is false.
     */
    public void setLatestDeployment(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Deployment value) {
        this.jsiiSet("latestDeployment", value);
    }
}
