package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-06T17:21:49.877Z")
public interface StageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.StageOptions {
    /**
     * The deployment that this stage points to.
     */
    software.amazon.awscdk.services.apigateway.Deployment getDeployment();
    /**
     * The deployment that this stage points to.
     */
    void setDeployment(final software.amazon.awscdk.services.apigateway.Deployment value);

    /**
     * @return a {@link Builder} of {@link StageProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StageProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.apigateway.Deployment _deployment;
        @javax.annotation.Nullable
        private java.lang.Boolean _cacheClusterEnabled;
        @javax.annotation.Nullable
        private java.lang.String _cacheClusterSize;
        @javax.annotation.Nullable
        private java.lang.String _clientCertificateId;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _documentationVersion;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> _methodOptions;
        @javax.annotation.Nullable
        private java.lang.String _stageName;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _variables;
        @javax.annotation.Nullable
        private java.lang.Boolean _cacheDataEncrypted;
        @javax.annotation.Nullable
        private java.lang.Number _cacheTtlSeconds;
        @javax.annotation.Nullable
        private java.lang.Boolean _cachingEnabled;
        @javax.annotation.Nullable
        private java.lang.Boolean _dataTraceEnabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodLoggingLevel _loggingLevel;
        @javax.annotation.Nullable
        private java.lang.Boolean _metricsEnabled;
        @javax.annotation.Nullable
        private java.lang.Number _throttlingBurstLimit;
        @javax.annotation.Nullable
        private java.lang.Number _throttlingRateLimit;

        /**
         * Sets the value of Deployment
         * @param value The deployment that this stage points to.
         * @return {@code this}
         */
        public Builder withDeployment(final software.amazon.awscdk.services.apigateway.Deployment value) {
            this._deployment = java.util.Objects.requireNonNull(value, "deployment is required");
            return this;
        }
        /**
         * Sets the value of CacheClusterEnabled
         * @param value Indicates whether cache clustering is enabled for the stage.
         * @return {@code this}
         */
        public Builder withCacheClusterEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cacheClusterEnabled = value;
            return this;
        }
        /**
         * Sets the value of CacheClusterSize
         * @param value The stage's cache cluster size.
         * @return {@code this}
         */
        public Builder withCacheClusterSize(@javax.annotation.Nullable final java.lang.String value) {
            this._cacheClusterSize = value;
            return this;
        }
        /**
         * Sets the value of ClientCertificateId
         * @param value The identifier of the client certificate that API Gateway uses to call
your integration endpoints in the stage.
         * @return {@code this}
         */
        public Builder withClientCertificateId(@javax.annotation.Nullable final java.lang.String value) {
            this._clientCertificateId = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the stage.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of DocumentationVersion
         * @param value The version identifier of the API documentation snapshot.
         * @return {@code this}
         */
        public Builder withDocumentationVersion(@javax.annotation.Nullable final java.lang.String value) {
            this._documentationVersion = value;
            return this;
        }
        /**
         * Sets the value of MethodOptions
         * @param value Method deployment options for specific resources/methods. These will
override common options defined in `StageOptions#methodOptions`.
         * @return {@code this}
         */
        public Builder withMethodOptions(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> value) {
            this._methodOptions = value;
            return this;
        }
        /**
         * Sets the value of StageName
         * @param value The name of the stage, which API Gateway uses as the first path segment
in the invoked Uniform Resource Identifier (URI).
         * @return {@code this}
         */
        public Builder withStageName(@javax.annotation.Nullable final java.lang.String value) {
            this._stageName = value;
            return this;
        }
        /**
         * Sets the value of Variables
         * @param value A map that defines the stage variables. Variable names must consist of
alphanumeric characters, and the values must match the following regular
expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
         * @return {@code this}
         */
        public Builder withVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._variables = value;
            return this;
        }
        /**
         * Sets the value of CacheDataEncrypted
         * @param value Indicates whether the cached responses are encrypted.
         * @return {@code this}
         */
        public Builder withCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cacheDataEncrypted = value;
            return this;
        }
        /**
         * Sets the value of CacheTtlSeconds
         * @param value Specifies the time to live (TTL), in seconds, for cached responses. The
higher the TTL, the longer the response will be cached.
         * @return {@code this}
         */
        public Builder withCacheTtlSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this._cacheTtlSeconds = value;
            return this;
        }
        /**
         * Sets the value of CachingEnabled
         * @param value Specifies whether responses should be cached and returned for requests. A
cache cluster must be enabled on the stage for responses to be cached.
         * @return {@code this}
         */
        public Builder withCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cachingEnabled = value;
            return this;
        }
        /**
         * Sets the value of DataTraceEnabled
         * @param value Specifies whether data trace logging is enabled for this method, which
effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        public Builder withDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._dataTraceEnabled = value;
            return this;
        }
        /**
         * Sets the value of LoggingLevel
         * @param value Specifies the logging level for this method, which effects the log
entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        public Builder withLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodLoggingLevel value) {
            this._loggingLevel = value;
            return this;
        }
        /**
         * Sets the value of MetricsEnabled
         * @param value Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @return {@code this}
         */
        public Builder withMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._metricsEnabled = value;
            return this;
        }
        /**
         * Sets the value of ThrottlingBurstLimit
         * @param value Specifies the throttling burst limit.
         * @return {@code this}
         */
        public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._throttlingBurstLimit = value;
            return this;
        }
        /**
         * Sets the value of ThrottlingRateLimit
         * @param value Specifies the throttling rate limit.
         * @return {@code this}
         */
        public Builder withThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._throttlingRateLimit = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public StageProps build() {
            return new StageProps() {
                private software.amazon.awscdk.services.apigateway.Deployment $deployment = java.util.Objects.requireNonNull(_deployment, "deployment is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $cacheClusterEnabled = _cacheClusterEnabled;
                @javax.annotation.Nullable
                private java.lang.String $cacheClusterSize = _cacheClusterSize;
                @javax.annotation.Nullable
                private java.lang.String $clientCertificateId = _clientCertificateId;
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.lang.String $documentationVersion = _documentationVersion;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> $methodOptions = _methodOptions;
                @javax.annotation.Nullable
                private java.lang.String $stageName = _stageName;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $variables = _variables;
                @javax.annotation.Nullable
                private java.lang.Boolean $cacheDataEncrypted = _cacheDataEncrypted;
                @javax.annotation.Nullable
                private java.lang.Number $cacheTtlSeconds = _cacheTtlSeconds;
                @javax.annotation.Nullable
                private java.lang.Boolean $cachingEnabled = _cachingEnabled;
                @javax.annotation.Nullable
                private java.lang.Boolean $dataTraceEnabled = _dataTraceEnabled;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.MethodLoggingLevel $loggingLevel = _loggingLevel;
                @javax.annotation.Nullable
                private java.lang.Boolean $metricsEnabled = _metricsEnabled;
                @javax.annotation.Nullable
                private java.lang.Number $throttlingBurstLimit = _throttlingBurstLimit;
                @javax.annotation.Nullable
                private java.lang.Number $throttlingRateLimit = _throttlingRateLimit;

                @Override
                public software.amazon.awscdk.services.apigateway.Deployment getDeployment() {
                    return this.$deployment;
                }

                @Override
                public void setDeployment(final software.amazon.awscdk.services.apigateway.Deployment value) {
                    this.$deployment = java.util.Objects.requireNonNull(value, "deployment is required");
                }

                @Override
                public java.lang.Boolean getCacheClusterEnabled() {
                    return this.$cacheClusterEnabled;
                }

                @Override
                public void setCacheClusterEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$cacheClusterEnabled = value;
                }

                @Override
                public java.lang.String getCacheClusterSize() {
                    return this.$cacheClusterSize;
                }

                @Override
                public void setCacheClusterSize(@javax.annotation.Nullable final java.lang.String value) {
                    this.$cacheClusterSize = value;
                }

                @Override
                public java.lang.String getClientCertificateId() {
                    return this.$clientCertificateId;
                }

                @Override
                public void setClientCertificateId(@javax.annotation.Nullable final java.lang.String value) {
                    this.$clientCertificateId = value;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.lang.String getDocumentationVersion() {
                    return this.$documentationVersion;
                }

                @Override
                public void setDocumentationVersion(@javax.annotation.Nullable final java.lang.String value) {
                    this.$documentationVersion = value;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
                    return this.$methodOptions;
                }

                @Override
                public void setMethodOptions(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> value) {
                    this.$methodOptions = value;
                }

                @Override
                public java.lang.String getStageName() {
                    return this.$stageName;
                }

                @Override
                public void setStageName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$stageName = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getVariables() {
                    return this.$variables;
                }

                @Override
                public void setVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$variables = value;
                }

                @Override
                public java.lang.Boolean getCacheDataEncrypted() {
                    return this.$cacheDataEncrypted;
                }

                @Override
                public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$cacheDataEncrypted = value;
                }

                @Override
                public java.lang.Number getCacheTtlSeconds() {
                    return this.$cacheTtlSeconds;
                }

                @Override
                public void setCacheTtlSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$cacheTtlSeconds = value;
                }

                @Override
                public java.lang.Boolean getCachingEnabled() {
                    return this.$cachingEnabled;
                }

                @Override
                public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$cachingEnabled = value;
                }

                @Override
                public java.lang.Boolean getDataTraceEnabled() {
                    return this.$dataTraceEnabled;
                }

                @Override
                public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$dataTraceEnabled = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
                    return this.$loggingLevel;
                }

                @Override
                public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodLoggingLevel value) {
                    this.$loggingLevel = value;
                }

                @Override
                public java.lang.Boolean getMetricsEnabled() {
                    return this.$metricsEnabled;
                }

                @Override
                public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$metricsEnabled = value;
                }

                @Override
                public java.lang.Number getThrottlingBurstLimit() {
                    return this.$throttlingBurstLimit;
                }

                @Override
                public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$throttlingBurstLimit = value;
                }

                @Override
                public java.lang.Number getThrottlingRateLimit() {
                    return this.$throttlingRateLimit;
                }

                @Override
                public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$throttlingRateLimit = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.StageProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The deployment that this stage points to.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.Deployment getDeployment() {
            return this.jsiiGet("deployment", software.amazon.awscdk.services.apigateway.Deployment.class);
        }

        /**
         * The deployment that this stage points to.
         */
        @Override
        public void setDeployment(final software.amazon.awscdk.services.apigateway.Deployment value) {
            this.jsiiSet("deployment", java.util.Objects.requireNonNull(value, "deployment is required"));
        }

        /**
         * Indicates whether cache clustering is enabled for the stage.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getCacheClusterEnabled() {
            return this.jsiiGet("cacheClusterEnabled", java.lang.Boolean.class);
        }

        /**
         * Indicates whether cache clustering is enabled for the stage.
         */
        @Override
        public void setCacheClusterEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("cacheClusterEnabled", value);
        }

        /**
         * The stage's cache cluster size.
         * @default 0.5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCacheClusterSize() {
            return this.jsiiGet("cacheClusterSize", java.lang.String.class);
        }

        /**
         * The stage's cache cluster size.
         * @default 0.5
         */
        @Override
        public void setCacheClusterSize(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cacheClusterSize", value);
        }

        /**
         * The identifier of the client certificate that API Gateway uses to call
         * your integration endpoints in the stage.
         * @default None
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getClientCertificateId() {
            return this.jsiiGet("clientCertificateId", java.lang.String.class);
        }

        /**
         * The identifier of the client certificate that API Gateway uses to call
         * your integration endpoints in the stage.
         * @default None
         */
        @Override
        public void setClientCertificateId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("clientCertificateId", value);
        }

        /**
         * A description of the purpose of the stage.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A description of the purpose of the stage.
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * The version identifier of the API documentation snapshot.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDocumentationVersion() {
            return this.jsiiGet("documentationVersion", java.lang.String.class);
        }

        /**
         * The version identifier of the API documentation snapshot.
         */
        @Override
        public void setDocumentationVersion(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("documentationVersion", value);
        }

        /**
         * Method deployment options for specific resources/methods. These will
         * override common options defined in `StageOptions#methodOptions`.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
            return this.jsiiGet("methodOptions", java.util.Map.class);
        }

        /**
         * Method deployment options for specific resources/methods. These will
         * override common options defined in `StageOptions#methodOptions`.
         */
        @Override
        public void setMethodOptions(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> value) {
            this.jsiiSet("methodOptions", value);
        }

        /**
         * The name of the stage, which API Gateway uses as the first path segment
         * in the invoked Uniform Resource Identifier (URI).
         * @default "prod"
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getStageName() {
            return this.jsiiGet("stageName", java.lang.String.class);
        }

        /**
         * The name of the stage, which API Gateway uses as the first path segment
         * in the invoked Uniform Resource Identifier (URI).
         * @default "prod"
         */
        @Override
        public void setStageName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("stageName", value);
        }

        /**
         * A map that defines the stage variables. Variable names must consist of
         * alphanumeric characters, and the values must match the following regular
         * expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getVariables() {
            return this.jsiiGet("variables", java.util.Map.class);
        }

        /**
         * A map that defines the stage variables. Variable names must consist of
         * alphanumeric characters, and the values must match the following regular
         * expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
         */
        @Override
        public void setVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("variables", value);
        }

        /**
         * Indicates whether the cached responses are encrypted.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getCacheDataEncrypted() {
            return this.jsiiGet("cacheDataEncrypted", java.lang.Boolean.class);
        }

        /**
         * Indicates whether the cached responses are encrypted.
         * @default false
         */
        @Override
        public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("cacheDataEncrypted", value);
        }

        /**
         * Specifies the time to live (TTL), in seconds, for cached responses. The
         * higher the TTL, the longer the response will be cached.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getCacheTtlSeconds() {
            return this.jsiiGet("cacheTtlSeconds", java.lang.Number.class);
        }

        /**
         * Specifies the time to live (TTL), in seconds, for cached responses. The
         * higher the TTL, the longer the response will be cached.
         */
        @Override
        public void setCacheTtlSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("cacheTtlSeconds", value);
        }

        /**
         * Specifies whether responses should be cached and returned for requests. A
         * cache cluster must be enabled on the stage for responses to be cached.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getCachingEnabled() {
            return this.jsiiGet("cachingEnabled", java.lang.Boolean.class);
        }

        /**
         * Specifies whether responses should be cached and returned for requests. A
         * cache cluster must be enabled on the stage for responses to be cached.
         */
        @Override
        public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("cachingEnabled", value);
        }

        /**
         * Specifies whether data trace logging is enabled for this method, which
         * effects the log entries pushed to Amazon CloudWatch Logs.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDataTraceEnabled() {
            return this.jsiiGet("dataTraceEnabled", java.lang.Boolean.class);
        }

        /**
         * Specifies whether data trace logging is enabled for this method, which
         * effects the log entries pushed to Amazon CloudWatch Logs.
         * @default false
         */
        @Override
        public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("dataTraceEnabled", value);
        }

        /**
         * Specifies the logging level for this method, which effects the log
         * entries pushed to Amazon CloudWatch Logs.
         * @default Off
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
            return this.jsiiGet("loggingLevel", software.amazon.awscdk.services.apigateway.MethodLoggingLevel.class);
        }

        /**
         * Specifies the logging level for this method, which effects the log
         * entries pushed to Amazon CloudWatch Logs.
         * @default Off
         */
        @Override
        public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodLoggingLevel value) {
            this.jsiiSet("loggingLevel", value);
        }

        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getMetricsEnabled() {
            return this.jsiiGet("metricsEnabled", java.lang.Boolean.class);
        }

        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @default false
         */
        @Override
        public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("metricsEnabled", value);
        }

        /**
         * Specifies the throttling burst limit.
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getThrottlingBurstLimit() {
            return this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
        }

        /**
         * Specifies the throttling burst limit.
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
         */
        @Override
        public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("throttlingBurstLimit", value);
        }

        /**
         * Specifies the throttling rate limit.
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getThrottlingRateLimit() {
            return this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
        }

        /**
         * Specifies the throttling rate limit.
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
         */
        @Override
        public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("throttlingRateLimit", value);
        }
    }
}
