package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-21T12:43:40.777Z")
public interface IntegrationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies an API method integration type.
     */
    software.amazon.awscdk.services.apigateway.IntegrationType getType();
    /**
     * Specifies an API method integration type.
     */
    void setType(final software.amazon.awscdk.services.apigateway.IntegrationType value);
    /**
     * The integration's HTTP method type.
     * Required unless you use a MOCK integration.
     */
    java.lang.String getIntegrationHttpMethod();
    /**
     * The integration's HTTP method type.
     * Required unless you use a MOCK integration.
     */
    void setIntegrationHttpMethod(final java.lang.String value);
    /**
     * Integration options.
     */
    software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions();
    /**
     * Integration options.
     */
    void setOptions(final software.amazon.awscdk.services.apigateway.IntegrationOptions value);
    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * 
     * - If you specify HTTP for the `type` property, specify the API endpoint URL.
     * - If you specify MOCK for the `type` property, don't specify this property.
     * - If you specify AWS for the `type` property, specify an AWS service that
     *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
     *    For example, a Lambda function URI follows this form:
     *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
     *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
     * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
     */
    java.lang.Object getUri();
    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * 
     * - If you specify HTTP for the `type` property, specify the API endpoint URL.
     * - If you specify MOCK for the `type` property, don't specify this property.
     * - If you specify AWS for the `type` property, specify an AWS service that
     *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
     *    For example, a Lambda function URI follows this form:
     *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
     *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
     * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
     */
    void setUri(final java.lang.Object value);

    /**
     * @return a {@link Builder} of {@link IntegrationProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IntegrationProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.apigateway.IntegrationType _type;
        @javax.annotation.Nullable
        private java.lang.String _integrationHttpMethod;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IntegrationOptions _options;
        @javax.annotation.Nullable
        private java.lang.Object _uri;

        /**
         * Sets the value of Type
         * @param value Specifies an API method integration type.
         * @return {@code this}
         */
        public Builder withType(final software.amazon.awscdk.services.apigateway.IntegrationType value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of IntegrationHttpMethod
         * @param value The integration's HTTP method type.
Required unless you use a MOCK integration.
         * @return {@code this}
         */
        public Builder withIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
            this._integrationHttpMethod = value;
            return this;
        }
        /**
         * Sets the value of Options
         * @param value Integration options.
         * @return {@code this}
         */
        public Builder withOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IntegrationOptions value) {
            this._options = value;
            return this;
        }
        /**
         * Sets the value of Uri
         * @param value The Uniform Resource Identifier (URI) for the integration.

- If you specify HTTP for the `type` property, specify the API endpoint URL.
- If you specify MOCK for the `type` property, don't specify this property.
- If you specify AWS for the `type` property, specify an AWS service that
   follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
   For example, a Lambda function URI follows this form:
   arn:aws:apigateway:region:lambda:path/path. The path is usually in the
   form /2015-03-31/functions/LambdaFunctionARN/invocations.
         * @return {@code this}
         */
        public Builder withUri(@javax.annotation.Nullable final java.lang.Object value) {
            this._uri = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public IntegrationProps build() {
            return new IntegrationProps() {
                private software.amazon.awscdk.services.apigateway.IntegrationType $type = java.util.Objects.requireNonNull(_type, "type is required");
                @javax.annotation.Nullable
                private java.lang.String $integrationHttpMethod = _integrationHttpMethod;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.IntegrationOptions $options = _options;
                @javax.annotation.Nullable
                private java.lang.Object $uri = _uri;

                @Override
                public software.amazon.awscdk.services.apigateway.IntegrationType getType() {
                    return this.$type;
                }

                @Override
                public void setType(final software.amazon.awscdk.services.apigateway.IntegrationType value) {
                    this.$type = java.util.Objects.requireNonNull(value, "type is required");
                }

                @Override
                public java.lang.String getIntegrationHttpMethod() {
                    return this.$integrationHttpMethod;
                }

                @Override
                public void setIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                    this.$integrationHttpMethod = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
                    return this.$options;
                }

                @Override
                public void setOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IntegrationOptions value) {
                    this.$options = value;
                }

                @Override
                public java.lang.Object getUri() {
                    return this.$uri;
                }

                @Override
                public void setUri(@javax.annotation.Nullable final java.lang.Object value) {
                    this.$uri = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IntegrationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies an API method integration type.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationType getType() {
            return this.jsiiGet("type", software.amazon.awscdk.services.apigateway.IntegrationType.class);
        }

        /**
         * Specifies an API method integration type.
         */
        @Override
        public void setType(final software.amazon.awscdk.services.apigateway.IntegrationType value) {
            this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
        }

        /**
         * The integration's HTTP method type.
         * Required unless you use a MOCK integration.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getIntegrationHttpMethod() {
            return this.jsiiGet("integrationHttpMethod", java.lang.String.class);
        }

        /**
         * The integration's HTTP method type.
         * Required unless you use a MOCK integration.
         */
        @Override
        public void setIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("integrationHttpMethod", value);
        }

        /**
         * Integration options.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
        }

        /**
         * Integration options.
         */
        @Override
        public void setOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IntegrationOptions value) {
            this.jsiiSet("options", value);
        }

        /**
         * The Uniform Resource Identifier (URI) for the integration.
         * 
         * - If you specify HTTP for the `type` property, specify the API endpoint URL.
         * - If you specify MOCK for the `type` property, don't specify this property.
         * - If you specify AWS for the `type` property, specify an AWS service that
         *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
         *    For example, a Lambda function URI follows this form:
         *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
         *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
         * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getUri() {
            return this.jsiiGet("uri", java.lang.Object.class);
        }

        /**
         * The Uniform Resource Identifier (URI) for the integration.
         * 
         * - If you specify HTTP for the `type` property, specify the API endpoint URL.
         * - If you specify MOCK for the `type` property, don't specify this property.
         * - If you specify AWS for the `type` property, specify an AWS service that
         *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
         *    For example, a Lambda function URI follows this form:
         *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
         *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
         * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
         */
        @Override
        public void setUri(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("uri", value);
        }
    }
}
