package software.amazon.awscdk.services.apigateway.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-13T10:28:35.837Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.RestApiResource")
public class RestApiResource extends software.amazon.awscdk.Resource {
    protected RestApiResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.RestApiResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::RestApi``.
     * @param parent the ``cdk.Construct`` this ``RestApiResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``RestApiResource``
     */
    public RestApiResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.cloudformation.RestApiResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ApiGateway::RestApi``.
     * @param parent the ``cdk.Construct`` this ``RestApiResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public RestApiResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.apigateway.cloudformation.RestApiResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.cloudformation.RestApiResourceProps.class);
    }

    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute RootResourceId
     */
    public java.lang.String getRestApiRootResourceId() {
        return this.jsiiGet("restApiRootResourceId", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     */
    public static interface EndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RestApiResource.EndpointConfigurationProperty.Types``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        java.lang.Object getTypes();
        /**
         * ``RestApiResource.EndpointConfigurationProperty.Types``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        void setTypes(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.EndpointConfigurationProperty.Types``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        void setTypes(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link EndpointConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EndpointConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _types;

            /**
             * Sets the value of Types
             * @param value ``RestApiResource.EndpointConfigurationProperty.Types``
             * @return {@code this}
             */
            public Builder withTypes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._types = value;
                return this;
            }
            /**
             * Sets the value of Types
             * @param value ``RestApiResource.EndpointConfigurationProperty.Types``
             * @return {@code this}
             */
            public Builder withTypes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._types = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EndpointConfigurationProperty build() {
                return new EndpointConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $types = _types;

                    @Override
                    public java.lang.Object getTypes() {
                        return this.$types;
                    }

                    @Override
                    public void setTypes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$types = value;
                    }

                    @Override
                    public void setTypes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$types = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.RestApiResource.EndpointConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTypes() {
                return this.jsiiGet("types", java.lang.Object.class);
            }

            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            @Override
            public void setTypes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("types", value);
            }

            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            @Override
            public void setTypes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("types", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RestApiResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        java.lang.Object getBucket();
        /**
         * ``RestApiResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        void setBucket(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        java.lang.Object getETag();
        /**
         * ``RestApiResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        void setETag(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        void setETag(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        java.lang.Object getKey();
        /**
         * ``RestApiResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        java.lang.Object getVersion();
        /**
         * ``RestApiResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        void setVersion(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _bucket;
            @javax.annotation.Nullable
            private java.lang.Object _eTag;
            @javax.annotation.Nullable
            private java.lang.Object _key;
            @javax.annotation.Nullable
            private java.lang.Object _version;

            /**
             * Sets the value of Bucket
             * @param value ``RestApiResource.S3LocationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(@javax.annotation.Nullable final java.lang.String value) {
                this._bucket = value;
                return this;
            }
            /**
             * Sets the value of Bucket
             * @param value ``RestApiResource.S3LocationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._bucket = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value ``RestApiResource.S3LocationProperty.ETag``
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final java.lang.String value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value ``RestApiResource.S3LocationProperty.ETag``
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``RestApiResource.S3LocationProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``RestApiResource.S3LocationProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``RestApiResource.S3LocationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``RestApiResource.S3LocationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $bucket = _bucket;
                    @javax.annotation.Nullable
                    private java.lang.Object $eTag = _eTag;
                    @javax.annotation.Nullable
                    private java.lang.Object $key = _key;
                    @javax.annotation.Nullable
                    private java.lang.Object $version = _version;

                    @Override
                    public java.lang.Object getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(@javax.annotation.Nullable final java.lang.String value) {
                        this.$bucket = value;
                    }

                    @Override
                    public void setBucket(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$bucket = value;
                    }

                    @Override
                    public java.lang.Object getETag() {
                        return this.$eTag;
                    }

                    @Override
                    public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                        this.$eTag = value;
                    }

                    @Override
                    public void setETag(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$eTag = value;
                    }

                    @Override
                    public java.lang.Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                        this.$key = value;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$key = value;
                    }

                    @Override
                    public java.lang.Object getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                        this.$version = value;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$version = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.RestApiResource.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBucket() {
                return this.jsiiGet("bucket", java.lang.Object.class);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            @Override
            public void setBucket(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bucket", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            @Override
            public void setBucket(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucket", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getETag() {
                return this.jsiiGet("eTag", java.lang.Object.class);
            }

            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            @Override
            public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("eTag", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            @Override
            public void setETag(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("eTag", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }

            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("version", value);
            }
        }
    }
}
