/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IRestApiResource;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.ResourceOptions;
import software.amazon.jsii.JsiiSerializable;

public interface ResourceProps
extends JsiiSerializable,
ResourceOptions {
    public IRestApiResource getParent();

    public void setParent(IRestApiResource var1);

    public String getPathPart();

    public void setPathPart(String var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IRestApiResource _parent;
        private String _pathPart;
        @Nullable
        private Integration _defaultIntegration;
        @Nullable
        private MethodOptions _defaultMethodOptions;

        public Builder withParent(IRestApiResource value) {
            this._parent = Objects.requireNonNull(value, "parent is required");
            return this;
        }

        public Builder withPathPart(String value) {
            this._pathPart = Objects.requireNonNull(value, "pathPart is required");
            return this;
        }

        public Builder withDefaultIntegration(@Nullable Integration value) {
            this._defaultIntegration = value;
            return this;
        }

        public Builder withDefaultMethodOptions(@Nullable MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        public ResourceProps build() {
            return new ResourceProps(){
                private IRestApiResource $parent;
                private String $pathPart;
                @Nullable
                private final Integration $defaultIntegration;
                @Nullable
                private final MethodOptions $defaultMethodOptions;
                {
                    this.$parent = Objects.requireNonNull(_parent, "parent is required");
                    this.$pathPart = Objects.requireNonNull(_pathPart, "pathPart is required");
                    this.$defaultIntegration = _defaultIntegration;
                    this.$defaultMethodOptions = _defaultMethodOptions;
                }

                @Override
                public IRestApiResource getParent() {
                    return this.$parent;
                }

                @Override
                public void setParent(IRestApiResource value) {
                    this.$parent = Objects.requireNonNull(value, "parent is required");
                }

                @Override
                public String getPathPart() {
                    return this.$pathPart;
                }

                @Override
                public void setPathPart(String value) {
                    this.$pathPart = Objects.requireNonNull(value, "pathPart is required");
                }

                @Override
                public Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }
            };
        }
    }
}

