package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-02-28T10:07:20.606Z")
public interface IntegrationOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * A list of request parameters whose values are to be cached. It determines
     * request parameters that will make it into the cache key.
     */
    java.util.List<java.lang.String> getCacheKeyParameters();
    /**
     * A list of request parameters whose values are to be cached. It determines
     * request parameters that will make it into the cache key.
     */
    void setCacheKeyParameters(final java.util.List<java.lang.String> value);
    /**
     * An API-specific tag group of related cached parameters.
     */
    java.lang.String getCacheNamespace();
    /**
     * An API-specific tag group of related cached parameters.
     */
    void setCacheNamespace(final java.lang.String value);
    /**
     * The type of network connection to the integration endpoint.
     * @default ConnectionType.Internet
     */
    software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType();
    /**
     * The type of network connection to the integration endpoint.
     * @default ConnectionType.Internet
     */
    void setConnectionType(final software.amazon.awscdk.services.apigateway.ConnectionType value);
    /**
     * Specifies how to handle request payload content type conversions.
     * @default none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the `passthroughBehaviors` property is configured to support payload pass-through.
     */
    software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling();
    /**
     * Specifies how to handle request payload content type conversions.
     * @default none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the `passthroughBehaviors` property is configured to support payload pass-through.
     */
    void setContentHandling(final software.amazon.awscdk.services.apigateway.ContentHandling value);
    /**
     * Requires that the caller's identity be passed through from the request.
     * @default Caller identity is not passed through
     */
    java.lang.Boolean getCredentialsPassthrough();
    /**
     * Requires that the caller's identity be passed through from the request.
     * @default Caller identity is not passed through
     */
    void setCredentialsPassthrough(final java.lang.Boolean value);
    /**
     * An IAM role that API Gateway assumes.
     * 
     * Mutually exclusive with `credentialsPassThrough`.
     * @default A role is not assumed
     */
    software.amazon.awscdk.services.iam.Role getCredentialsRole();
    /**
     * An IAM role that API Gateway assumes.
     * 
     * Mutually exclusive with `credentialsPassThrough`.
     * @default A role is not assumed
     */
    void setCredentialsRole(final software.amazon.awscdk.services.iam.Role value);
    /**
     * The response that API Gateway provides after a method's backend completes
     * processing a request. API Gateway intercepts the response from the
     * backend so that you can control how API Gateway surfaces backend
     * responses. For example, you can map the backend status codes to codes
     * that you define.
     */
    java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses();
    /**
     * The response that API Gateway provides after a method's backend completes
     * processing a request. API Gateway intercepts the response from the
     * backend so that you can control how API Gateway surfaces backend
     * responses. For example, you can map the backend status codes to codes
     * that you define.
     */
    void setIntegrationResponses(final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> value);
    /**
     * Specifies the pass-through behavior for incoming requests based on the
     * Content-Type header in the request, and the available mapping templates
     * specified as the requestTemplates property on the Integration resource.
     * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
     * NEVER.
     */
    software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior();
    /**
     * Specifies the pass-through behavior for incoming requests based on the
     * Content-Type header in the request, and the available mapping templates
     * specified as the requestTemplates property on the Integration resource.
     * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
     * NEVER.
     */
    void setPassthroughBehavior(final software.amazon.awscdk.services.apigateway.PassthroughBehavior value);
    /**
     * The request parameters that API Gateway sends with the backend request.
     * Specify request parameters as key-value pairs (string-to-string
     * mappings), with a destination as the key and a source as the value.
     * 
     * Specify the destination by using the following pattern
     * integration.request.location.name, where location is querystring, path,
     * or header, and name is a valid, unique parameter name.
     * 
     * The source must be an existing method request parameter or a static
     * value. You must enclose static values in single quotation marks and
     * pre-encode these values based on their destination in the request.
     */
    java.util.Map<java.lang.String, java.lang.String> getRequestParameters();
    /**
     * The request parameters that API Gateway sends with the backend request.
     * Specify request parameters as key-value pairs (string-to-string
     * mappings), with a destination as the key and a source as the value.
     * 
     * Specify the destination by using the following pattern
     * integration.request.location.name, where location is querystring, path,
     * or header, and name is a valid, unique parameter name.
     * 
     * The source must be an existing method request parameter or a static
     * value. You must enclose static values in single quotation marks and
     * pre-encode these values based on their destination in the request.
     */
    void setRequestParameters(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * A map of Apache Velocity templates that are applied on the request
     * payload. The template that API Gateway uses is based on the value of the
     * Content-Type header that's sent by the client. The content type value is
     * the key, and the template is the value (specified as a string), such as
     * the following snippet:
     * 
     *    { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    java.util.Map<java.lang.String, java.lang.String> getRequestTemplates();
    /**
     * A map of Apache Velocity templates that are applied on the request
     * payload. The template that API Gateway uses is based on the value of the
     * Content-Type header that's sent by the client. The content type value is
     * the key, and the template is the value (specified as a string), such as
     * the following snippet:
     * 
     *    { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    void setRequestTemplates(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * The VpcLink used for the integration.
     * Required if connectionType is VPC_LINK
     */
    software.amazon.awscdk.services.apigateway.VpcLink getVpcLink();
    /**
     * The VpcLink used for the integration.
     * Required if connectionType is VPC_LINK
     */
    void setVpcLink(final software.amazon.awscdk.services.apigateway.VpcLink value);

    /**
     * @return a {@link Builder} of {@link IntegrationOptions}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IntegrationOptions}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _cacheKeyParameters;
        @javax.annotation.Nullable
        private java.lang.String _cacheNamespace;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ConnectionType _connectionType;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ContentHandling _contentHandling;
        @javax.annotation.Nullable
        private java.lang.Boolean _credentialsPassthrough;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.Role _credentialsRole;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> _integrationResponses;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.PassthroughBehavior _passthroughBehavior;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _requestParameters;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _requestTemplates;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.VpcLink _vpcLink;

        /**
         * Sets the value of CacheKeyParameters
         * @param value A list of request parameters whose values are to be cached. It determines
request parameters that will make it into the cache key.
         * @return {@code this}
         */
        public Builder withCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._cacheKeyParameters = value;
            return this;
        }
        /**
         * Sets the value of CacheNamespace
         * @param value An API-specific tag group of related cached parameters.
         * @return {@code this}
         */
        public Builder withCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
            this._cacheNamespace = value;
            return this;
        }
        /**
         * Sets the value of ConnectionType
         * @param value The type of network connection to the integration endpoint.
         * @return {@code this}
         */
        public Builder withConnectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ConnectionType value) {
            this._connectionType = value;
            return this;
        }
        /**
         * Sets the value of ContentHandling
         * @param value Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        public Builder withContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
            this._contentHandling = value;
            return this;
        }
        /**
         * Sets the value of CredentialsPassthrough
         * @param value Requires that the caller's identity be passed through from the request.
         * @return {@code this}
         */
        public Builder withCredentialsPassthrough(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._credentialsPassthrough = value;
            return this;
        }
        /**
         * Sets the value of CredentialsRole
         * @param value An IAM role that API Gateway assumes.

Mutually exclusive with `credentialsPassThrough`.
         * @return {@code this}
         */
        public Builder withCredentialsRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this._credentialsRole = value;
            return this;
        }
        /**
         * Sets the value of IntegrationResponses
         * @param value The response that API Gateway provides after a method's backend completes
processing a request. API Gateway intercepts the response from the
backend so that you can control how API Gateway surfaces backend
responses. For example, you can map the backend status codes to codes
that you define.
         * @return {@code this}
         */
        public Builder withIntegrationResponses(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> value) {
            this._integrationResponses = value;
            return this;
        }
        /**
         * Sets the value of PassthroughBehavior
         * @param value Specifies the pass-through behavior for incoming requests based on the
Content-Type header in the request, and the available mapping templates
specified as the requestTemplates property on the Integration resource.
There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
NEVER.
         * @return {@code this}
         */
        public Builder withPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.PassthroughBehavior value) {
            this._passthroughBehavior = value;
            return this;
        }
        /**
         * Sets the value of RequestParameters
         * @param value The request parameters that API Gateway sends with the backend request.
Specify request parameters as key-value pairs (string-to-string
mappings), with a destination as the key and a source as the value.

Specify the destination by using the following pattern
integration.request.location.name, where location is querystring, path,
or header, and name is a valid, unique parameter name.

The source must be an existing method request parameter or a static
value. You must enclose static values in single quotation marks and
pre-encode these values based on their destination in the request.
         * @return {@code this}
         */
        public Builder withRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._requestParameters = value;
            return this;
        }
        /**
         * Sets the value of RequestTemplates
         * @param value A map of Apache Velocity templates that are applied on the request
payload. The template that API Gateway uses is based on the value of the
Content-Type header that's sent by the client. The content type value is
the key, and the template is the value (specified as a string), such as
the following snippet:

   { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
         * @return {@code this}
         */
        public Builder withRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._requestTemplates = value;
            return this;
        }
        /**
         * Sets the value of VpcLink
         * @param value The VpcLink used for the integration.
Required if connectionType is VPC_LINK
         * @return {@code this}
         */
        public Builder withVpcLink(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.VpcLink value) {
            this._vpcLink = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        public IntegrationOptions build() {
            return new IntegrationOptions() {
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $cacheKeyParameters = _cacheKeyParameters;
                @javax.annotation.Nullable
                private java.lang.String $cacheNamespace = _cacheNamespace;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.ConnectionType $connectionType = _connectionType;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.ContentHandling $contentHandling = _contentHandling;
                @javax.annotation.Nullable
                private java.lang.Boolean $credentialsPassthrough = _credentialsPassthrough;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.iam.Role $credentialsRole = _credentialsRole;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> $integrationResponses = _integrationResponses;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.PassthroughBehavior $passthroughBehavior = _passthroughBehavior;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $requestParameters = _requestParameters;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $requestTemplates = _requestTemplates;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.apigateway.VpcLink $vpcLink = _vpcLink;

                @Override
                public java.util.List<java.lang.String> getCacheKeyParameters() {
                    return this.$cacheKeyParameters;
                }

                @Override
                public void setCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$cacheKeyParameters = value;
                }

                @Override
                public java.lang.String getCacheNamespace() {
                    return this.$cacheNamespace;
                }

                @Override
                public void setCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
                    this.$cacheNamespace = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
                    return this.$connectionType;
                }

                @Override
                public void setConnectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ConnectionType value) {
                    this.$connectionType = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
                    return this.$contentHandling;
                }

                @Override
                public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
                    this.$contentHandling = value;
                }

                @Override
                public java.lang.Boolean getCredentialsPassthrough() {
                    return this.$credentialsPassthrough;
                }

                @Override
                public void setCredentialsPassthrough(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$credentialsPassthrough = value;
                }

                @Override
                public software.amazon.awscdk.services.iam.Role getCredentialsRole() {
                    return this.$credentialsRole;
                }

                @Override
                public void setCredentialsRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
                    this.$credentialsRole = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
                    return this.$integrationResponses;
                }

                @Override
                public void setIntegrationResponses(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> value) {
                    this.$integrationResponses = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
                    return this.$passthroughBehavior;
                }

                @Override
                public void setPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.PassthroughBehavior value) {
                    this.$passthroughBehavior = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$requestParameters = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
                    return this.$requestTemplates;
                }

                @Override
                public void setRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$requestTemplates = value;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.VpcLink getVpcLink() {
                    return this.$vpcLink;
                }

                @Override
                public void setVpcLink(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.VpcLink value) {
                    this.$vpcLink = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IntegrationOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A list of request parameters whose values are to be cached. It determines
         * request parameters that will make it into the cache key.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getCacheKeyParameters() {
            return this.jsiiGet("cacheKeyParameters", java.util.List.class);
        }

        /**
         * A list of request parameters whose values are to be cached. It determines
         * request parameters that will make it into the cache key.
         */
        @Override
        public void setCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("cacheKeyParameters", value);
        }

        /**
         * An API-specific tag group of related cached parameters.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCacheNamespace() {
            return this.jsiiGet("cacheNamespace", java.lang.String.class);
        }

        /**
         * An API-specific tag group of related cached parameters.
         */
        @Override
        public void setCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cacheNamespace", value);
        }

        /**
         * The type of network connection to the integration endpoint.
         * @default ConnectionType.Internet
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
            return this.jsiiGet("connectionType", software.amazon.awscdk.services.apigateway.ConnectionType.class);
        }

        /**
         * The type of network connection to the integration endpoint.
         * @default ConnectionType.Internet
         */
        @Override
        public void setConnectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ConnectionType value) {
            this.jsiiSet("connectionType", value);
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * @default none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the `passthroughBehaviors` property is configured to support payload pass-through.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.jsiiGet("contentHandling", software.amazon.awscdk.services.apigateway.ContentHandling.class);
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * @default none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the `passthroughBehaviors` property is configured to support payload pass-through.
         */
        @Override
        public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
            this.jsiiSet("contentHandling", value);
        }

        /**
         * Requires that the caller's identity be passed through from the request.
         * @default Caller identity is not passed through
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getCredentialsPassthrough() {
            return this.jsiiGet("credentialsPassthrough", java.lang.Boolean.class);
        }

        /**
         * Requires that the caller's identity be passed through from the request.
         * @default Caller identity is not passed through
         */
        @Override
        public void setCredentialsPassthrough(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("credentialsPassthrough", value);
        }

        /**
         * An IAM role that API Gateway assumes.
         * 
         * Mutually exclusive with `credentialsPassThrough`.
         * @default A role is not assumed
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getCredentialsRole() {
            return this.jsiiGet("credentialsRole", software.amazon.awscdk.services.iam.Role.class);
        }

        /**
         * An IAM role that API Gateway assumes.
         * 
         * Mutually exclusive with `credentialsPassThrough`.
         * @default A role is not assumed
         */
        @Override
        public void setCredentialsRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this.jsiiSet("credentialsRole", value);
        }

        /**
         * The response that API Gateway provides after a method's backend completes
         * processing a request. API Gateway intercepts the response from the
         * backend so that you can control how API Gateway surfaces backend
         * responses. For example, you can map the backend status codes to codes
         * that you define.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
            return this.jsiiGet("integrationResponses", java.util.List.class);
        }

        /**
         * The response that API Gateway provides after a method's backend completes
         * processing a request. API Gateway intercepts the response from the
         * backend so that you can control how API Gateway surfaces backend
         * responses. For example, you can map the backend status codes to codes
         * that you define.
         */
        @Override
        public void setIntegrationResponses(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> value) {
            this.jsiiSet("integrationResponses", value);
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the
         * Content-Type header in the request, and the available mapping templates
         * specified as the requestTemplates property on the Integration resource.
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         * NEVER.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
            return this.jsiiGet("passthroughBehavior", software.amazon.awscdk.services.apigateway.PassthroughBehavior.class);
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the
         * Content-Type header in the request, and the available mapping templates
         * specified as the requestTemplates property on the Integration resource.
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         * NEVER.
         */
        @Override
        public void setPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.PassthroughBehavior value) {
            this.jsiiSet("passthroughBehavior", value);
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * Specify request parameters as key-value pairs (string-to-string
         * mappings), with a destination as the key and a source as the value.
         * 
         * Specify the destination by using the following pattern
         * integration.request.location.name, where location is querystring, path,
         * or header, and name is a valid, unique parameter name.
         * 
         * The source must be an existing method request parameter or a static
         * value. You must enclose static values in single quotation marks and
         * pre-encode these values based on their destination in the request.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.jsiiGet("requestParameters", java.util.Map.class);
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * Specify request parameters as key-value pairs (string-to-string
         * mappings), with a destination as the key and a source as the value.
         * 
         * Specify the destination by using the following pattern
         * integration.request.location.name, where location is querystring, path,
         * or header, and name is a valid, unique parameter name.
         * 
         * The source must be an existing method request parameter or a static
         * value. You must enclose static values in single quotation marks and
         * pre-encode these values based on their destination in the request.
         */
        @Override
        public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("requestParameters", value);
        }

        /**
         * A map of Apache Velocity templates that are applied on the request
         * payload. The template that API Gateway uses is based on the value of the
         * Content-Type header that's sent by the client. The content type value is
         * the key, and the template is the value (specified as a string), such as
         * the following snippet:
         * 
         *    { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.jsiiGet("requestTemplates", java.util.Map.class);
        }

        /**
         * A map of Apache Velocity templates that are applied on the request
         * payload. The template that API Gateway uses is based on the value of the
         * Content-Type header that's sent by the client. The content type value is
         * the key, and the template is the value (specified as a string), such as
         * the following snippet:
         * 
         *    { "application/json": "{\n  \"statusCode\": \"200\"\n}" }
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         */
        @Override
        public void setRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("requestTemplates", value);
        }

        /**
         * The VpcLink used for the integration.
         * Required if connectionType is VPC_LINK
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.VpcLink getVpcLink() {
            return this.jsiiGet("vpcLink", software.amazon.awscdk.services.apigateway.VpcLink.class);
        }

        /**
         * The VpcLink used for the integration.
         * Required if connectionType is VPC_LINK
         */
        @Override
        public void setVpcLink(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.VpcLink value) {
            this.jsiiSet("vpcLink", value);
        }
    }
}
