package software.amazon.awscdk.services.apigateway;

/**
 * Properties for a VpcLink
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-02-28T10:07:20.626Z")
public interface VpcLinkProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The network load balancers of the VPC targeted by the VPC link.
     * The network load balancers must be owned by the same AWS account of the API owner.
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets();
    /**
     * The network load balancers of the VPC targeted by the VPC link.
     * The network load balancers must be owned by the same AWS account of the API owner.
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> value);
    /**
     * The description of the VPC link.
     * @default no description
     */
    java.lang.String getDescription();
    /**
     * The description of the VPC link.
     * @default no description
     */
    void setDescription(final java.lang.String value);
    /**
     * The name used to label and identify the VPC link.
     * @default automatically generated name
     */
    java.lang.String getName();
    /**
     * The name used to label and identify the VPC link.
     * @default automatically generated name
     */
    void setName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link VpcLinkProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcLinkProps}
     */
    final class Builder {
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> _targets;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _name;

        /**
         * Sets the value of Targets
         * @param value The network load balancers of the VPC targeted by the VPC link.
The network load balancers must be owned by the same AWS account of the API owner.
         * @return {@code this}
         */
        public Builder withTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> value) {
            this._targets = java.util.Objects.requireNonNull(value, "targets is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value The description of the VPC link.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Name
         * @param value The name used to label and identify the VPC link.
         * @return {@code this}
         */
        public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
            this._name = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcLinkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcLinkProps build() {
            return new VpcLinkProps() {
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> $targets = java.util.Objects.requireNonNull(_targets, "targets is required");
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.lang.String $name = _name;

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> value) {
                    this.$targets = java.util.Objects.requireNonNull(value, "targets is required");
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public void setName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$name = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.VpcLinkProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The network load balancers of the VPC targeted by the VPC link.
         * The network load balancers must be owned by the same AWS account of the API owner.
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * The network load balancers of the VPC targeted by the VPC link.
         * The network load balancers must be owned by the same AWS account of the API owner.
         */
        @Override
        public void setTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> value) {
            this.jsiiSet("targets", java.util.Objects.requireNonNull(value, "targets is required"));
        }

        /**
         * The description of the VPC link.
         * @default no description
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * The description of the VPC link.
         * @default no description
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * The name used to label and identify the VPC link.
         * @default automatically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * The name used to label and identify the VPC link.
         * @default automatically generated name
         */
        @Override
        public void setName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("name", value);
        }
    }
}
