package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T13:00:46.070Z")
public interface MethodResponse extends software.amazon.jsii.JsiiSerializable {
    /**
     * The method response's status code, which you map to an IntegrationResponse.
     * Required.
     */
    java.lang.String getStatusCode();
    /**
     * The method response's status code, which you map to an IntegrationResponse.
     * Required.
     */
    void setStatusCode(final java.lang.String value);
    /**
     * The resources used for the response's content type. Specify response models as
     * key-value pairs (string-to-string maps), with a content type as the key and a Model
     * resource name as the value.
     * @default None
     */
    java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels();
    /**
     * The resources used for the response's content type. Specify response models as
     * key-value pairs (string-to-string maps), with a content type as the key and a Model
     * resource name as the value.
     * @default None
     */
    void setResponseModels(final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> value);
    /**
     * Response parameters that API Gateway sends to the client that called a method.
     * Specify response parameters as key-value pairs (string-to-Boolean maps), with
     * a destination as the key and a Boolean as the value. Specify the destination
     * using the following pattern: method.response.header.name, where the name is a
     * valid, unique header name. The Boolean specifies whether a parameter is required.
     * @default None
     */
    java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters();
    /**
     * Response parameters that API Gateway sends to the client that called a method.
     * Specify response parameters as key-value pairs (string-to-Boolean maps), with
     * a destination as the key and a Boolean as the value. Specify the destination
     * using the following pattern: method.response.header.name, where the name is a
     * valid, unique header name. The Boolean specifies whether a parameter is required.
     * @default None
     */
    void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Boolean> value);

    /**
     * @return a {@link Builder} of {@link MethodResponse}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MethodResponse}
     */
    final class Builder {
        private java.lang.String _statusCode;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> _responseModels;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Boolean> _responseParameters;

        /**
         * Sets the value of StatusCode
         * @param value The method response's status code, which you map to an IntegrationResponse.
Required.
         * @return {@code this}
         */
        public Builder withStatusCode(final java.lang.String value) {
            this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
            return this;
        }
        /**
         * Sets the value of ResponseModels
         * @param value The resources used for the response's content type. Specify response models as
key-value pairs (string-to-string maps), with a content type as the key and a Model
resource name as the value.
         * @return {@code this}
         */
        public Builder withResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> value) {
            this._responseModels = value;
            return this;
        }
        /**
         * Sets the value of ResponseParameters
         * @param value Response parameters that API Gateway sends to the client that called a method.
Specify response parameters as key-value pairs (string-to-Boolean maps), with
a destination as the key and a Boolean as the value. Specify the destination
using the following pattern: method.response.header.name, where the name is a
valid, unique header name. The Boolean specifies whether a parameter is required.
         * @return {@code this}
         */
        public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Boolean> value) {
            this._responseParameters = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        public MethodResponse build() {
            return new MethodResponse() {
                private java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> $responseModels = _responseModels;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.Boolean> $responseParameters = _responseParameters;

                @Override
                public java.lang.String getStatusCode() {
                    return this.$statusCode;
                }

                @Override
                public void setStatusCode(final java.lang.String value) {
                    this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
                    return this.$responseModels;
                }

                @Override
                public void setResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> value) {
                    this.$responseModels = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
                    return this.$responseParameters;
                }

                @Override
                public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Boolean> value) {
                    this.$responseParameters = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.MethodResponse {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The method response's status code, which you map to an IntegrationResponse.
         * Required.
         */
        @Override
        public java.lang.String getStatusCode() {
            return this.jsiiGet("statusCode", java.lang.String.class);
        }

        /**
         * The method response's status code, which you map to an IntegrationResponse.
         * Required.
         */
        @Override
        public void setStatusCode(final java.lang.String value) {
            this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
        }

        /**
         * The resources used for the response's content type. Specify response models as
         * key-value pairs (string-to-string maps), with a content type as the key and a Model
         * resource name as the value.
         * @default None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
            return this.jsiiGet("responseModels", java.util.Map.class);
        }

        /**
         * The resources used for the response's content type. Specify response models as
         * key-value pairs (string-to-string maps), with a content type as the key and a Model
         * resource name as the value.
         * @default None
         */
        @Override
        public void setResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> value) {
            this.jsiiSet("responseModels", value);
        }

        /**
         * Response parameters that API Gateway sends to the client that called a method.
         * Specify response parameters as key-value pairs (string-to-Boolean maps), with
         * a destination as the key and a Boolean as the value. Specify the destination
         * using the following pattern: method.response.header.name, where the name is a
         * valid, unique header name. The Boolean specifies whether a parameter is required.
         * @default None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
            return this.jsiiGet("responseParameters", java.util.Map.class);
        }

        /**
         * Response parameters that API Gateway sends to the client that called a method.
         * Specify response parameters as key-value pairs (string-to-Boolean maps), with
         * a destination as the key and a Boolean as the value. Specify the destination
         * using the following pattern: method.response.header.name, where the name is a
         * valid, unique header name. The Boolean specifies whether a parameter is required.
         * @default None
         */
        @Override
        public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Boolean> value) {
            this.jsiiSet("responseParameters", value);
        }
    }
}
