package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:34.721Z")
public interface AwsIntegrationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the integrated AWS service (e.g. `s3`)
     */
    java.lang.String getService();
    /**
     * The AWS action to perform in the integration.
     * 
     * Use `actionParams` to specify key-value params for the action.
     * 
     * Mutually exclusive with `path`.
     */
    java.lang.String getAction();
    /**
     * Parameters for the action.
     * 
     * `action` must be set, and `path` must be undefined.
     * The action params will be URL encoded.
     */
    java.util.Map<java.lang.String, java.lang.String> getActionParameters();
    /**
     * Integration options, such as content handling, request/response mapping, etc.
     */
    software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions();
    /**
     * The path to use for path-base APIs.
     * 
     * For example, for S3 GET, you can set path to `bucket/key`.
     * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
     * 
     * Mutually exclusive with the `action` options.
     */
    java.lang.String getPath();
    /**
     * Use AWS_PROXY integration.
     * @default false
     */
    java.lang.Boolean getProxy();
    /**
     * A designated subdomain supported by certain AWS service for fast
     * host-name lookup.
     */
    java.lang.String getSubdomain();

    /**
     * @return a {@link Builder} of {@link AwsIntegrationProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AwsIntegrationProps}
     */
    final class Builder {
        private java.lang.String _service;
        @javax.annotation.Nullable
        private java.lang.String _action;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _actionParameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IntegrationOptions _options;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.Boolean _proxy;
        @javax.annotation.Nullable
        private java.lang.String _subdomain;

        /**
         * Sets the value of Service
         * @param value The name of the integrated AWS service (e.g. `s3`)
         * @return {@code this}
         */
        public Builder withService(final java.lang.String value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of Action
         * @param value The AWS action to perform in the integration.

Use `actionParams` to specify key-value params for the action.

Mutually exclusive with `path`.
         * @return {@code this}
         */
        public Builder withAction(@javax.annotation.Nullable final java.lang.String value) {
            this._action = value;
            return this;
        }
        /**
         * Sets the value of ActionParameters
         * @param value Parameters for the action.

`action` must be set, and `path` must be undefined.
The action params will be URL encoded.
         * @return {@code this}
         */
        public Builder withActionParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._actionParameters = value;
            return this;
        }
        /**
         * Sets the value of Options
         * @param value Integration options, such as content handling, request/response mapping, etc.
         * @return {@code this}
         */
        public Builder withOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IntegrationOptions value) {
            this._options = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path to use for path-base APIs.

For example, for S3 GET, you can set path to `bucket/key`.
For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`

Mutually exclusive with the `action` options.
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of Proxy
         * @param value Use AWS_PROXY integration.
         * @return {@code this}
         */
        public Builder withProxy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._proxy = value;
            return this;
        }
        /**
         * Sets the value of Subdomain
         * @param value A designated subdomain supported by certain AWS service for fast
host-name lookup.
         * @return {@code this}
         */
        public Builder withSubdomain(@javax.annotation.Nullable final java.lang.String value) {
            this._subdomain = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AwsIntegrationProps build() {
            return new AwsIntegrationProps() {
                private final java.lang.String $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.lang.String $action = _action;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $actionParameters = _actionParameters;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.IntegrationOptions $options = _options;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;
                @javax.annotation.Nullable
                private final java.lang.Boolean $proxy = _proxy;
                @javax.annotation.Nullable
                private final java.lang.String $subdomain = _subdomain;

                @Override
                public java.lang.String getService() {
                    return this.$service;
                }

                @Override
                public java.lang.String getAction() {
                    return this.$action;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
                    return this.$actionParameters;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
                    return this.$options;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.Boolean getProxy() {
                    return this.$proxy;
                }

                @Override
                public java.lang.String getSubdomain() {
                    return this.$subdomain;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("service", om.valueToTree(this.getService()));
                    obj.set("action", om.valueToTree(this.getAction()));
                    obj.set("actionParameters", om.valueToTree(this.getActionParameters()));
                    obj.set("options", om.valueToTree(this.getOptions()));
                    obj.set("path", om.valueToTree(this.getPath()));
                    obj.set("proxy", om.valueToTree(this.getProxy()));
                    obj.set("subdomain", om.valueToTree(this.getSubdomain()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.AwsIntegrationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the integrated AWS service (e.g. `s3`)
         */
        @Override
        public java.lang.String getService() {
            return this.jsiiGet("service", java.lang.String.class);
        }

        /**
         * The AWS action to perform in the integration.
         * 
         * Use `actionParams` to specify key-value params for the action.
         * 
         * Mutually exclusive with `path`.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAction() {
            return this.jsiiGet("action", java.lang.String.class);
        }

        /**
         * Parameters for the action.
         * 
         * `action` must be set, and `path` must be undefined.
         * The action params will be URL encoded.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
            return this.jsiiGet("actionParameters", java.util.Map.class);
        }

        /**
         * Integration options, such as content handling, request/response mapping, etc.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
        }

        /**
         * The path to use for path-base APIs.
         * 
         * For example, for S3 GET, you can set path to `bucket/key`.
         * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
         * 
         * Mutually exclusive with the `action` options.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * Use AWS_PROXY integration.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getProxy() {
            return this.jsiiGet("proxy", java.lang.Boolean.class);
        }

        /**
         * A designated subdomain supported by certain AWS service for fast
         * host-name lookup.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getSubdomain() {
            return this.jsiiGet("subdomain", java.lang.String.class);
        }
    }
}
