package software.amazon.awscdk.services.apigateway;

/**
 * @cloudformationResource AWS::ApiGateway::ApiKey
 * A CloudFormation `AWS::ApiGateway::ApiKey`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:34.728Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnApiKey")
public class CfnApiKey extends software.amazon.awscdk.CfnResource {
    protected CfnApiKey(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnApiKey.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ApiGateway::ApiKey`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnApiKey(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.CfnApiKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    /**
     * Create a new `AWS::ApiGateway::ApiKey`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     */
    public CfnApiKey(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApiKeyId() {
        return this.jsiiGet("apiKeyId", java.lang.String.class);
    }

    public software.amazon.awscdk.services.apigateway.CfnApiKeyProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.CfnApiKeyProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html
     */
    public static interface StageKeyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApiKey.StageKeyProperty.RestApiId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        java.lang.String getRestApiId();
        /**
         * `CfnApiKey.StageKeyProperty.StageName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        java.lang.String getStageName();

        /**
         * @return a {@link Builder} of {@link StageKeyProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StageKeyProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _restApiId;
            @javax.annotation.Nullable
            private java.lang.String _stageName;

            /**
             * Sets the value of RestApiId
             * @param value `CfnApiKey.StageKeyProperty.RestApiId`
             * @return {@code this}
             */
            public Builder withRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                this._restApiId = value;
                return this;
            }
            /**
             * Sets the value of StageName
             * @param value `CfnApiKey.StageKeyProperty.StageName`
             * @return {@code this}
             */
            public Builder withStageName(@javax.annotation.Nullable final java.lang.String value) {
                this._stageName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StageKeyProperty build() {
                return new StageKeyProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $restApiId = _restApiId;
                    @javax.annotation.Nullable
                    private final java.lang.String $stageName = _stageName;

                    @Override
                    public java.lang.String getRestApiId() {
                        return this.$restApiId;
                    }

                    @Override
                    public java.lang.String getStageName() {
                        return this.$stageName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("restApiId", om.valueToTree(this.getRestApiId()));
                        obj.set("stageName", om.valueToTree(this.getStageName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnApiKey.StageKeyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApiKey.StageKeyProperty.RestApiId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRestApiId() {
                return this.jsiiGet("restApiId", java.lang.String.class);
            }

            /**
             * `CfnApiKey.StageKeyProperty.StageName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getStageName() {
                return this.jsiiGet("stageName", java.lang.String.class);
            }
        }
    }
}
