package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGatewayV2::IntegrationResponse`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:34.766Z")
public interface CfnIntegrationResponseV2Props extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ApiId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid
     */
    java.lang.String getApiId();
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid
     */
    java.lang.String getIntegrationId();
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey
     */
    java.lang.String getIntegrationResponseKey();
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy
     */
    java.lang.String getContentHandlingStrategy();
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters
     */
    java.lang.Object getResponseParameters();
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates
     */
    java.lang.Object getResponseTemplates();
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression
     */
    java.lang.String getTemplateSelectionExpression();

    /**
     * @return a {@link Builder} of {@link CfnIntegrationResponseV2Props}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnIntegrationResponseV2Props}
     */
    final class Builder {
        private java.lang.String _apiId;
        private java.lang.String _integrationId;
        private java.lang.String _integrationResponseKey;
        @javax.annotation.Nullable
        private java.lang.String _contentHandlingStrategy;
        @javax.annotation.Nullable
        private java.lang.Object _responseParameters;
        @javax.annotation.Nullable
        private java.lang.Object _responseTemplates;
        @javax.annotation.Nullable
        private java.lang.String _templateSelectionExpression;

        /**
         * Sets the value of ApiId
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.ApiId`
         * @return {@code this}
         */
        public Builder withApiId(final java.lang.String value) {
            this._apiId = java.util.Objects.requireNonNull(value, "apiId is required");
            return this;
        }
        /**
         * Sets the value of IntegrationId
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.IntegrationId`
         * @return {@code this}
         */
        public Builder withIntegrationId(final java.lang.String value) {
            this._integrationId = java.util.Objects.requireNonNull(value, "integrationId is required");
            return this;
        }
        /**
         * Sets the value of IntegrationResponseKey
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey`
         * @return {@code this}
         */
        public Builder withIntegrationResponseKey(final java.lang.String value) {
            this._integrationResponseKey = java.util.Objects.requireNonNull(value, "integrationResponseKey is required");
            return this;
        }
        /**
         * Sets the value of ContentHandlingStrategy
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy`
         * @return {@code this}
         */
        public Builder withContentHandlingStrategy(@javax.annotation.Nullable final java.lang.String value) {
            this._contentHandlingStrategy = value;
            return this;
        }
        /**
         * Sets the value of ResponseParameters
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters`
         * @return {@code this}
         */
        public Builder withResponseParameters(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
            this._responseParameters = value;
            return this;
        }
        /**
         * Sets the value of ResponseParameters
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters`
         * @return {@code this}
         */
        public Builder withResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._responseParameters = value;
            return this;
        }
        /**
         * Sets the value of ResponseTemplates
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates`
         * @return {@code this}
         */
        public Builder withResponseTemplates(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
            this._responseTemplates = value;
            return this;
        }
        /**
         * Sets the value of ResponseTemplates
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates`
         * @return {@code this}
         */
        public Builder withResponseTemplates(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._responseTemplates = value;
            return this;
        }
        /**
         * Sets the value of TemplateSelectionExpression
         * @param value `AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression`
         * @return {@code this}
         */
        public Builder withTemplateSelectionExpression(@javax.annotation.Nullable final java.lang.String value) {
            this._templateSelectionExpression = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationResponseV2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnIntegrationResponseV2Props build() {
            return new CfnIntegrationResponseV2Props() {
                private final java.lang.String $apiId = java.util.Objects.requireNonNull(_apiId, "apiId is required");
                private final java.lang.String $integrationId = java.util.Objects.requireNonNull(_integrationId, "integrationId is required");
                private final java.lang.String $integrationResponseKey = java.util.Objects.requireNonNull(_integrationResponseKey, "integrationResponseKey is required");
                @javax.annotation.Nullable
                private final java.lang.String $contentHandlingStrategy = _contentHandlingStrategy;
                @javax.annotation.Nullable
                private final java.lang.Object $responseParameters = _responseParameters;
                @javax.annotation.Nullable
                private final java.lang.Object $responseTemplates = _responseTemplates;
                @javax.annotation.Nullable
                private final java.lang.String $templateSelectionExpression = _templateSelectionExpression;

                @Override
                public java.lang.String getApiId() {
                    return this.$apiId;
                }

                @Override
                public java.lang.String getIntegrationId() {
                    return this.$integrationId;
                }

                @Override
                public java.lang.String getIntegrationResponseKey() {
                    return this.$integrationResponseKey;
                }

                @Override
                public java.lang.String getContentHandlingStrategy() {
                    return this.$contentHandlingStrategy;
                }

                @Override
                public java.lang.Object getResponseParameters() {
                    return this.$responseParameters;
                }

                @Override
                public java.lang.Object getResponseTemplates() {
                    return this.$responseTemplates;
                }

                @Override
                public java.lang.String getTemplateSelectionExpression() {
                    return this.$templateSelectionExpression;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("apiId", om.valueToTree(this.getApiId()));
                    obj.set("integrationId", om.valueToTree(this.getIntegrationId()));
                    obj.set("integrationResponseKey", om.valueToTree(this.getIntegrationResponseKey()));
                    obj.set("contentHandlingStrategy", om.valueToTree(this.getContentHandlingStrategy()));
                    obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                    obj.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                    obj.set("templateSelectionExpression", om.valueToTree(this.getTemplateSelectionExpression()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnIntegrationResponseV2Props {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.ApiId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid
         */
        @Override
        public java.lang.String getApiId() {
            return this.jsiiGet("apiId", java.lang.String.class);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid
         */
        @Override
        public java.lang.String getIntegrationId() {
            return this.jsiiGet("integrationId", java.lang.String.class);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey
         */
        @Override
        public java.lang.String getIntegrationResponseKey() {
            return this.jsiiGet("integrationResponseKey", java.lang.String.class);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getContentHandlingStrategy() {
            return this.jsiiGet("contentHandlingStrategy", java.lang.String.class);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getResponseParameters() {
            return this.jsiiGet("responseParameters", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getResponseTemplates() {
            return this.jsiiGet("responseTemplates", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTemplateSelectionExpression() {
            return this.jsiiGet("templateSelectionExpression", java.lang.String.class);
        }
    }
}
