/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.apigateway.CfnMethod;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnMethodProps
extends JsiiSerializable {
    public String getHttpMethod();

    public String getResourceId();

    public String getRestApiId();

    public Object getApiKeyRequired();

    public List<String> getAuthorizationScopes();

    public String getAuthorizationType();

    public String getAuthorizerId();

    public Object getIntegration();

    public Object getMethodResponses();

    public String getOperationName();

    public Object getRequestModels();

    public Object getRequestParameters();

    public String getRequestValidatorId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _httpMethod;
        private String _resourceId;
        private String _restApiId;
        @Nullable
        private Object _apiKeyRequired;
        @Nullable
        private List<String> _authorizationScopes;
        @Nullable
        private String _authorizationType;
        @Nullable
        private String _authorizerId;
        @Nullable
        private Object _integration;
        @Nullable
        private Object _methodResponses;
        @Nullable
        private String _operationName;
        @Nullable
        private Object _requestModels;
        @Nullable
        private Object _requestParameters;
        @Nullable
        private String _requestValidatorId;

        public Builder withHttpMethod(String value) {
            this._httpMethod = Objects.requireNonNull(value, "httpMethod is required");
            return this;
        }

        public Builder withResourceId(String value) {
            this._resourceId = Objects.requireNonNull(value, "resourceId is required");
            return this;
        }

        public Builder withRestApiId(String value) {
            this._restApiId = Objects.requireNonNull(value, "restApiId is required");
            return this;
        }

        public Builder withApiKeyRequired(@Nullable Boolean value) {
            this._apiKeyRequired = value;
            return this;
        }

        public Builder withApiKeyRequired(@Nullable Token value) {
            this._apiKeyRequired = value;
            return this;
        }

        public Builder withAuthorizationScopes(@Nullable List<String> value) {
            this._authorizationScopes = value;
            return this;
        }

        public Builder withAuthorizationType(@Nullable String value) {
            this._authorizationType = value;
            return this;
        }

        public Builder withAuthorizerId(@Nullable String value) {
            this._authorizerId = value;
            return this;
        }

        public Builder withIntegration(@Nullable Token value) {
            this._integration = value;
            return this;
        }

        public Builder withIntegration(@Nullable CfnMethod.IntegrationProperty value) {
            this._integration = value;
            return this;
        }

        public Builder withMethodResponses(@Nullable Token value) {
            this._methodResponses = value;
            return this;
        }

        public Builder withMethodResponses(@Nullable List<Object> value) {
            this._methodResponses = value;
            return this;
        }

        public Builder withOperationName(@Nullable String value) {
            this._operationName = value;
            return this;
        }

        public Builder withRequestModels(@Nullable Token value) {
            this._requestModels = value;
            return this;
        }

        public Builder withRequestModels(@Nullable Map<String, String> value) {
            this._requestModels = value;
            return this;
        }

        public Builder withRequestParameters(@Nullable Token value) {
            this._requestParameters = value;
            return this;
        }

        public Builder withRequestParameters(@Nullable Map<String, Object> value) {
            this._requestParameters = value;
            return this;
        }

        public Builder withRequestValidatorId(@Nullable String value) {
            this._requestValidatorId = value;
            return this;
        }

        public CfnMethodProps build() {
            return new CfnMethodProps(){
                private final String $httpMethod;
                private final String $resourceId;
                private final String $restApiId;
                @Nullable
                private final Object $apiKeyRequired;
                @Nullable
                private final List<String> $authorizationScopes;
                @Nullable
                private final String $authorizationType;
                @Nullable
                private final String $authorizerId;
                @Nullable
                private final Object $integration;
                @Nullable
                private final Object $methodResponses;
                @Nullable
                private final String $operationName;
                @Nullable
                private final Object $requestModels;
                @Nullable
                private final Object $requestParameters;
                @Nullable
                private final String $requestValidatorId;
                {
                    this.$httpMethod = Objects.requireNonNull(_httpMethod, "httpMethod is required");
                    this.$resourceId = Objects.requireNonNull(_resourceId, "resourceId is required");
                    this.$restApiId = Objects.requireNonNull(_restApiId, "restApiId is required");
                    this.$apiKeyRequired = _apiKeyRequired;
                    this.$authorizationScopes = _authorizationScopes;
                    this.$authorizationType = _authorizationType;
                    this.$authorizerId = _authorizerId;
                    this.$integration = _integration;
                    this.$methodResponses = _methodResponses;
                    this.$operationName = _operationName;
                    this.$requestModels = _requestModels;
                    this.$requestParameters = _requestParameters;
                    this.$requestValidatorId = _requestValidatorId;
                }

                @Override
                public String getHttpMethod() {
                    return this.$httpMethod;
                }

                @Override
                public String getResourceId() {
                    return this.$resourceId;
                }

                @Override
                public String getRestApiId() {
                    return this.$restApiId;
                }

                @Override
                public Object getApiKeyRequired() {
                    return this.$apiKeyRequired;
                }

                @Override
                public List<String> getAuthorizationScopes() {
                    return this.$authorizationScopes;
                }

                @Override
                public String getAuthorizationType() {
                    return this.$authorizationType;
                }

                @Override
                public String getAuthorizerId() {
                    return this.$authorizerId;
                }

                @Override
                public Object getIntegration() {
                    return this.$integration;
                }

                @Override
                public Object getMethodResponses() {
                    return this.$methodResponses;
                }

                @Override
                public String getOperationName() {
                    return this.$operationName;
                }

                @Override
                public Object getRequestModels() {
                    return this.$requestModels;
                }

                @Override
                public Object getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public String getRequestValidatorId() {
                    return this.$requestValidatorId;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("httpMethod", om.valueToTree((Object)this.getHttpMethod()));
                    obj.set("resourceId", om.valueToTree((Object)this.getResourceId()));
                    obj.set("restApiId", om.valueToTree((Object)this.getRestApiId()));
                    obj.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
                    obj.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
                    obj.set("authorizationType", om.valueToTree((Object)this.getAuthorizationType()));
                    obj.set("authorizerId", om.valueToTree((Object)this.getAuthorizerId()));
                    obj.set("integration", om.valueToTree(this.getIntegration()));
                    obj.set("methodResponses", om.valueToTree(this.getMethodResponses()));
                    obj.set("operationName", om.valueToTree((Object)this.getOperationName()));
                    obj.set("requestModels", om.valueToTree(this.getRequestModels()));
                    obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                    obj.set("requestValidatorId", om.valueToTree((Object)this.getRequestValidatorId()));
                    return obj;
                }
            };
        }
    }
}

