/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnRouteV2Props
extends JsiiSerializable {
    public String getApiId();

    public String getRouteKey();

    public Object getApiKeyRequired();

    public List<String> getAuthorizationScopes();

    public String getAuthorizationType();

    public String getAuthorizerId();

    public String getModelSelectionExpression();

    public String getOperationName();

    public Object getRequestModels();

    public Object getRequestParameters();

    public String getRouteResponseSelectionExpression();

    public String getTarget();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _apiId;
        private String _routeKey;
        @Nullable
        private Object _apiKeyRequired;
        @Nullable
        private List<String> _authorizationScopes;
        @Nullable
        private String _authorizationType;
        @Nullable
        private String _authorizerId;
        @Nullable
        private String _modelSelectionExpression;
        @Nullable
        private String _operationName;
        @Nullable
        private Object _requestModels;
        @Nullable
        private Object _requestParameters;
        @Nullable
        private String _routeResponseSelectionExpression;
        @Nullable
        private String _target;

        public Builder withApiId(String value) {
            this._apiId = Objects.requireNonNull(value, "apiId is required");
            return this;
        }

        public Builder withRouteKey(String value) {
            this._routeKey = Objects.requireNonNull(value, "routeKey is required");
            return this;
        }

        public Builder withApiKeyRequired(@Nullable Boolean value) {
            this._apiKeyRequired = value;
            return this;
        }

        public Builder withApiKeyRequired(@Nullable Token value) {
            this._apiKeyRequired = value;
            return this;
        }

        public Builder withAuthorizationScopes(@Nullable List<String> value) {
            this._authorizationScopes = value;
            return this;
        }

        public Builder withAuthorizationType(@Nullable String value) {
            this._authorizationType = value;
            return this;
        }

        public Builder withAuthorizerId(@Nullable String value) {
            this._authorizerId = value;
            return this;
        }

        public Builder withModelSelectionExpression(@Nullable String value) {
            this._modelSelectionExpression = value;
            return this;
        }

        public Builder withOperationName(@Nullable String value) {
            this._operationName = value;
            return this;
        }

        public Builder withRequestModels(@Nullable ObjectNode value) {
            this._requestModels = value;
            return this;
        }

        public Builder withRequestModels(@Nullable Token value) {
            this._requestModels = value;
            return this;
        }

        public Builder withRequestParameters(@Nullable ObjectNode value) {
            this._requestParameters = value;
            return this;
        }

        public Builder withRequestParameters(@Nullable Token value) {
            this._requestParameters = value;
            return this;
        }

        public Builder withRouteResponseSelectionExpression(@Nullable String value) {
            this._routeResponseSelectionExpression = value;
            return this;
        }

        public Builder withTarget(@Nullable String value) {
            this._target = value;
            return this;
        }

        public CfnRouteV2Props build() {
            return new CfnRouteV2Props(){
                private final String $apiId;
                private final String $routeKey;
                @Nullable
                private final Object $apiKeyRequired;
                @Nullable
                private final List<String> $authorizationScopes;
                @Nullable
                private final String $authorizationType;
                @Nullable
                private final String $authorizerId;
                @Nullable
                private final String $modelSelectionExpression;
                @Nullable
                private final String $operationName;
                @Nullable
                private final Object $requestModels;
                @Nullable
                private final Object $requestParameters;
                @Nullable
                private final String $routeResponseSelectionExpression;
                @Nullable
                private final String $target;
                {
                    this.$apiId = Objects.requireNonNull(_apiId, "apiId is required");
                    this.$routeKey = Objects.requireNonNull(_routeKey, "routeKey is required");
                    this.$apiKeyRequired = _apiKeyRequired;
                    this.$authorizationScopes = _authorizationScopes;
                    this.$authorizationType = _authorizationType;
                    this.$authorizerId = _authorizerId;
                    this.$modelSelectionExpression = _modelSelectionExpression;
                    this.$operationName = _operationName;
                    this.$requestModels = _requestModels;
                    this.$requestParameters = _requestParameters;
                    this.$routeResponseSelectionExpression = _routeResponseSelectionExpression;
                    this.$target = _target;
                }

                @Override
                public String getApiId() {
                    return this.$apiId;
                }

                @Override
                public String getRouteKey() {
                    return this.$routeKey;
                }

                @Override
                public Object getApiKeyRequired() {
                    return this.$apiKeyRequired;
                }

                @Override
                public List<String> getAuthorizationScopes() {
                    return this.$authorizationScopes;
                }

                @Override
                public String getAuthorizationType() {
                    return this.$authorizationType;
                }

                @Override
                public String getAuthorizerId() {
                    return this.$authorizerId;
                }

                @Override
                public String getModelSelectionExpression() {
                    return this.$modelSelectionExpression;
                }

                @Override
                public String getOperationName() {
                    return this.$operationName;
                }

                @Override
                public Object getRequestModels() {
                    return this.$requestModels;
                }

                @Override
                public Object getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public String getRouteResponseSelectionExpression() {
                    return this.$routeResponseSelectionExpression;
                }

                @Override
                public String getTarget() {
                    return this.$target;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("apiId", om.valueToTree((Object)this.getApiId()));
                    obj.set("routeKey", om.valueToTree((Object)this.getRouteKey()));
                    obj.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
                    obj.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
                    obj.set("authorizationType", om.valueToTree((Object)this.getAuthorizationType()));
                    obj.set("authorizerId", om.valueToTree((Object)this.getAuthorizerId()));
                    obj.set("modelSelectionExpression", om.valueToTree((Object)this.getModelSelectionExpression()));
                    obj.set("operationName", om.valueToTree((Object)this.getOperationName()));
                    obj.set("requestModels", om.valueToTree(this.getRequestModels()));
                    obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                    obj.set("routeResponseSelectionExpression", om.valueToTree((Object)this.getRouteResponseSelectionExpression()));
                    obj.set("target", om.valueToTree((Object)this.getTarget()));
                    return obj;
                }
            };
        }
    }
}

