package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Deployment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:05:16.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDeployment")
public class CfnDeployment extends software.amazon.awscdk.CfnResource {
    protected CfnDeployment(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnDeployment.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ApiGateway::Deployment`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnDeployment(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnDeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getDeploymentId() {
        return this.jsiiGet("deploymentId", java.lang.String.class);
    }

    public software.amazon.awscdk.services.apigateway.CfnDeploymentProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.CfnDeploymentProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html
     */
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeployment.AccessLogSettingProperty.DestinationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn
         */
        java.lang.String getDestinationArn();
        /**
         * `CfnDeployment.AccessLogSettingProperty.Format`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format
         */
        java.lang.String getFormat();

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _destinationArn;
            @javax.annotation.Nullable
            private java.lang.String _format;

            /**
             * Sets the value of DestinationArn
             * @param value `CfnDeployment.AccessLogSettingProperty.DestinationArn`.
             * @return {@code this}
             */
            public Builder withDestinationArn(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationArn = value;
                return this;
            }
            /**
             * Sets the value of Format
             * @param value `CfnDeployment.AccessLogSettingProperty.Format`.
             * @return {@code this}
             */
            public Builder withFormat(@javax.annotation.Nullable final java.lang.String value) {
                this._format = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccessLogSettingProperty build() {
                return new AccessLogSettingProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $destinationArn = _destinationArn;
                    @javax.annotation.Nullable
                    private final java.lang.String $format = _format;

                    @Override
                    public java.lang.String getDestinationArn() {
                        return this.$destinationArn;
                    }

                    @Override
                    public java.lang.String getFormat() {
                        return this.$format;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                        obj.set("format", om.valueToTree(this.getFormat()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnDeployment.AccessLogSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeployment.AccessLogSettingProperty.DestinationArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDestinationArn() {
                return this.jsiiGet("destinationArn", java.lang.String.class);
            }

            /**
             * `CfnDeployment.AccessLogSettingProperty.Format`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getFormat() {
                return this.jsiiGet("format", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html
     */
    public static interface CanarySettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeployment.CanarySettingProperty.PercentTraffic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic
         */
        java.lang.Object getPercentTraffic();
        /**
         * `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides
         */
        java.lang.Object getStageVariableOverrides();
        /**
         * `CfnDeployment.CanarySettingProperty.UseStageCache`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache
         */
        java.lang.Object getUseStageCache();

        /**
         * @return a {@link Builder} of {@link CanarySettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CanarySettingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _percentTraffic;
            @javax.annotation.Nullable
            private java.lang.Object _stageVariableOverrides;
            @javax.annotation.Nullable
            private java.lang.Object _useStageCache;

            /**
             * Sets the value of PercentTraffic
             * @param value `CfnDeployment.CanarySettingProperty.PercentTraffic`.
             * @return {@code this}
             */
            public Builder withPercentTraffic(@javax.annotation.Nullable final java.lang.Number value) {
                this._percentTraffic = value;
                return this;
            }
            /**
             * Sets the value of PercentTraffic
             * @param value `CfnDeployment.CanarySettingProperty.PercentTraffic`.
             * @return {@code this}
             */
            public Builder withPercentTraffic(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._percentTraffic = value;
                return this;
            }
            /**
             * Sets the value of StageVariableOverrides
             * @param value `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            public Builder withStageVariableOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._stageVariableOverrides = value;
                return this;
            }
            /**
             * Sets the value of StageVariableOverrides
             * @param value `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            public Builder withStageVariableOverrides(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._stageVariableOverrides = value;
                return this;
            }
            /**
             * Sets the value of UseStageCache
             * @param value `CfnDeployment.CanarySettingProperty.UseStageCache`.
             * @return {@code this}
             */
            public Builder withUseStageCache(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._useStageCache = value;
                return this;
            }
            /**
             * Sets the value of UseStageCache
             * @param value `CfnDeployment.CanarySettingProperty.UseStageCache`.
             * @return {@code this}
             */
            public Builder withUseStageCache(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._useStageCache = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanarySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CanarySettingProperty build() {
                return new CanarySettingProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $percentTraffic = _percentTraffic;
                    @javax.annotation.Nullable
                    private final java.lang.Object $stageVariableOverrides = _stageVariableOverrides;
                    @javax.annotation.Nullable
                    private final java.lang.Object $useStageCache = _useStageCache;

                    @Override
                    public java.lang.Object getPercentTraffic() {
                        return this.$percentTraffic;
                    }

                    @Override
                    public java.lang.Object getStageVariableOverrides() {
                        return this.$stageVariableOverrides;
                    }

                    @Override
                    public java.lang.Object getUseStageCache() {
                        return this.$useStageCache;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                        obj.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                        obj.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnDeployment.CanarySettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeployment.CanarySettingProperty.PercentTraffic`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPercentTraffic() {
                return this.jsiiGet("percentTraffic", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.CanarySettingProperty.StageVariableOverrides`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getStageVariableOverrides() {
                return this.jsiiGet("stageVariableOverrides", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.CanarySettingProperty.UseStageCache`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getUseStageCache() {
                return this.jsiiGet("useStageCache", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html
     */
    public static interface DeploymentCanarySettingsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic
         */
        java.lang.Object getPercentTraffic();
        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides
         */
        java.lang.Object getStageVariableOverrides();
        /**
         * `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache
         */
        java.lang.Object getUseStageCache();

        /**
         * @return a {@link Builder} of {@link DeploymentCanarySettingsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentCanarySettingsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _percentTraffic;
            @javax.annotation.Nullable
            private java.lang.Object _stageVariableOverrides;
            @javax.annotation.Nullable
            private java.lang.Object _useStageCache;

            /**
             * Sets the value of PercentTraffic
             * @param value `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
             * @return {@code this}
             */
            public Builder withPercentTraffic(@javax.annotation.Nullable final java.lang.Number value) {
                this._percentTraffic = value;
                return this;
            }
            /**
             * Sets the value of PercentTraffic
             * @param value `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
             * @return {@code this}
             */
            public Builder withPercentTraffic(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._percentTraffic = value;
                return this;
            }
            /**
             * Sets the value of StageVariableOverrides
             * @param value `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            public Builder withStageVariableOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._stageVariableOverrides = value;
                return this;
            }
            /**
             * Sets the value of StageVariableOverrides
             * @param value `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            public Builder withStageVariableOverrides(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._stageVariableOverrides = value;
                return this;
            }
            /**
             * Sets the value of UseStageCache
             * @param value `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
             * @return {@code this}
             */
            public Builder withUseStageCache(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._useStageCache = value;
                return this;
            }
            /**
             * Sets the value of UseStageCache
             * @param value `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
             * @return {@code this}
             */
            public Builder withUseStageCache(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._useStageCache = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentCanarySettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentCanarySettingsProperty build() {
                return new DeploymentCanarySettingsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $percentTraffic = _percentTraffic;
                    @javax.annotation.Nullable
                    private final java.lang.Object $stageVariableOverrides = _stageVariableOverrides;
                    @javax.annotation.Nullable
                    private final java.lang.Object $useStageCache = _useStageCache;

                    @Override
                    public java.lang.Object getPercentTraffic() {
                        return this.$percentTraffic;
                    }

                    @Override
                    public java.lang.Object getStageVariableOverrides() {
                        return this.$stageVariableOverrides;
                    }

                    @Override
                    public java.lang.Object getUseStageCache() {
                        return this.$useStageCache;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                        obj.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                        obj.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPercentTraffic() {
                return this.jsiiGet("percentTraffic", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getStageVariableOverrides() {
                return this.jsiiGet("stageVariableOverrides", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getUseStageCache() {
                return this.jsiiGet("useStageCache", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html
     */
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
         */
        java.lang.Object getCacheDataEncrypted();
        /**
         * `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
         */
        java.lang.Object getCacheTtlInSeconds();
        /**
         * `CfnDeployment.MethodSettingProperty.CachingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
         */
        java.lang.Object getCachingEnabled();
        /**
         * `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
         */
        java.lang.Object getDataTraceEnabled();
        /**
         * `CfnDeployment.MethodSettingProperty.HttpMethod`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
         */
        java.lang.String getHttpMethod();
        /**
         * `CfnDeployment.MethodSettingProperty.LoggingLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
         */
        java.lang.String getLoggingLevel();
        /**
         * `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
         */
        java.lang.Object getMetricsEnabled();
        /**
         * `CfnDeployment.MethodSettingProperty.ResourcePath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
         */
        java.lang.String getResourcePath();
        /**
         * `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
         */
        java.lang.Object getThrottlingBurstLimit();
        /**
         * `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
         */
        java.lang.Object getThrottlingRateLimit();

        /**
         * @return a {@link Builder} of {@link MethodSettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MethodSettingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _cacheDataEncrypted;
            @javax.annotation.Nullable
            private java.lang.Object _cacheTtlInSeconds;
            @javax.annotation.Nullable
            private java.lang.Object _cachingEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _dataTraceEnabled;
            @javax.annotation.Nullable
            private java.lang.String _httpMethod;
            @javax.annotation.Nullable
            private java.lang.String _loggingLevel;
            @javax.annotation.Nullable
            private java.lang.Object _metricsEnabled;
            @javax.annotation.Nullable
            private java.lang.String _resourcePath;
            @javax.annotation.Nullable
            private java.lang.Object _throttlingBurstLimit;
            @javax.annotation.Nullable
            private java.lang.Object _throttlingRateLimit;

            /**
             * Sets the value of CacheDataEncrypted
             * @param value `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            public Builder withCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cacheDataEncrypted = value;
                return this;
            }
            /**
             * Sets the value of CacheDataEncrypted
             * @param value `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            public Builder withCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheDataEncrypted = value;
                return this;
            }
            /**
             * Sets the value of CacheTtlInSeconds
             * @param value `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            public Builder withCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * Sets the value of CacheTtlInSeconds
             * @param value `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            public Builder withCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * Sets the value of CachingEnabled
             * @param value `CfnDeployment.MethodSettingProperty.CachingEnabled`.
             * @return {@code this}
             */
            public Builder withCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cachingEnabled = value;
                return this;
            }
            /**
             * Sets the value of CachingEnabled
             * @param value `CfnDeployment.MethodSettingProperty.CachingEnabled`.
             * @return {@code this}
             */
            public Builder withCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cachingEnabled = value;
                return this;
            }
            /**
             * Sets the value of DataTraceEnabled
             * @param value `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            public Builder withDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._dataTraceEnabled = value;
                return this;
            }
            /**
             * Sets the value of DataTraceEnabled
             * @param value `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            public Builder withDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._dataTraceEnabled = value;
                return this;
            }
            /**
             * Sets the value of HttpMethod
             * @param value `CfnDeployment.MethodSettingProperty.HttpMethod`.
             * @return {@code this}
             */
            public Builder withHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this._httpMethod = value;
                return this;
            }
            /**
             * Sets the value of LoggingLevel
             * @param value `CfnDeployment.MethodSettingProperty.LoggingLevel`.
             * @return {@code this}
             */
            public Builder withLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this._loggingLevel = value;
                return this;
            }
            /**
             * Sets the value of MetricsEnabled
             * @param value `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
             * @return {@code this}
             */
            public Builder withMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._metricsEnabled = value;
                return this;
            }
            /**
             * Sets the value of MetricsEnabled
             * @param value `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
             * @return {@code this}
             */
            public Builder withMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._metricsEnabled = value;
                return this;
            }
            /**
             * Sets the value of ResourcePath
             * @param value `CfnDeployment.MethodSettingProperty.ResourcePath`.
             * @return {@code this}
             */
            public Builder withResourcePath(@javax.annotation.Nullable final java.lang.String value) {
                this._resourcePath = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingBurstLimit
             * @param value `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this._throttlingBurstLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingBurstLimit
             * @param value `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._throttlingBurstLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingRateLimit
             * @param value `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this._throttlingRateLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingRateLimit
             * @param value `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._throttlingRateLimit = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MethodSettingProperty build() {
                return new MethodSettingProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $cacheDataEncrypted = _cacheDataEncrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cacheTtlInSeconds = _cacheTtlInSeconds;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cachingEnabled = _cachingEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.Object $dataTraceEnabled = _dataTraceEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.String $httpMethod = _httpMethod;
                    @javax.annotation.Nullable
                    private final java.lang.String $loggingLevel = _loggingLevel;
                    @javax.annotation.Nullable
                    private final java.lang.Object $metricsEnabled = _metricsEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.String $resourcePath = _resourcePath;
                    @javax.annotation.Nullable
                    private final java.lang.Object $throttlingBurstLimit = _throttlingBurstLimit;
                    @javax.annotation.Nullable
                    private final java.lang.Object $throttlingRateLimit = _throttlingRateLimit;

                    @Override
                    public java.lang.Object getCacheDataEncrypted() {
                        return this.$cacheDataEncrypted;
                    }

                    @Override
                    public java.lang.Object getCacheTtlInSeconds() {
                        return this.$cacheTtlInSeconds;
                    }

                    @Override
                    public java.lang.Object getCachingEnabled() {
                        return this.$cachingEnabled;
                    }

                    @Override
                    public java.lang.Object getDataTraceEnabled() {
                        return this.$dataTraceEnabled;
                    }

                    @Override
                    public java.lang.String getHttpMethod() {
                        return this.$httpMethod;
                    }

                    @Override
                    public java.lang.String getLoggingLevel() {
                        return this.$loggingLevel;
                    }

                    @Override
                    public java.lang.Object getMetricsEnabled() {
                        return this.$metricsEnabled;
                    }

                    @Override
                    public java.lang.String getResourcePath() {
                        return this.$resourcePath;
                    }

                    @Override
                    public java.lang.Object getThrottlingBurstLimit() {
                        return this.$throttlingBurstLimit;
                    }

                    @Override
                    public java.lang.Object getThrottlingRateLimit() {
                        return this.$throttlingRateLimit;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                        obj.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                        obj.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                        obj.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                        obj.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                        obj.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                        obj.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                        obj.set("resourcePath", om.valueToTree(this.getResourcePath()));
                        obj.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                        obj.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnDeployment.MethodSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.CacheDataEncrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheDataEncrypted() {
                return this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.CacheTtlInSeconds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheTtlInSeconds() {
                return this.jsiiGet("cacheTtlInSeconds", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.CachingEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCachingEnabled() {
                return this.jsiiGet("cachingEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.DataTraceEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDataTraceEnabled() {
                return this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.HttpMethod`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHttpMethod() {
                return this.jsiiGet("httpMethod", java.lang.String.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.LoggingLevel`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLoggingLevel() {
                return this.jsiiGet("loggingLevel", java.lang.String.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.MetricsEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMetricsEnabled() {
                return this.jsiiGet("metricsEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.ResourcePath`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getResourcePath() {
                return this.jsiiGet("resourcePath", java.lang.String.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingBurstLimit() {
                return this.jsiiGet("throttlingBurstLimit", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.MethodSettingProperty.ThrottlingRateLimit`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingRateLimit() {
                return this.jsiiGet("throttlingRateLimit", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html
     */
    public static interface StageDescriptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting
         */
        java.lang.Object getAccessLogSetting();
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
         */
        java.lang.Object getCacheClusterEnabled();
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheClusterSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
         */
        java.lang.String getCacheClusterSize();
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
         */
        java.lang.Object getCacheDataEncrypted();
        /**
         * `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
         */
        java.lang.Object getCacheTtlInSeconds();
        /**
         * `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
         */
        java.lang.Object getCachingEnabled();
        /**
         * `CfnDeployment.StageDescriptionProperty.CanarySetting`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting
         */
        java.lang.Object getCanarySetting();
        /**
         * `CfnDeployment.StageDescriptionProperty.ClientCertificateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
         */
        java.lang.String getClientCertificateId();
        /**
         * `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
         */
        java.lang.Object getDataTraceEnabled();
        /**
         * `CfnDeployment.StageDescriptionProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
         */
        java.lang.String getDescription();
        /**
         * `CfnDeployment.StageDescriptionProperty.DocumentationVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
         */
        java.lang.String getDocumentationVersion();
        /**
         * `CfnDeployment.StageDescriptionProperty.LoggingLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
         */
        java.lang.String getLoggingLevel();
        /**
         * `CfnDeployment.StageDescriptionProperty.MethodSettings`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
         */
        java.lang.Object getMethodSettings();
        /**
         * `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
         */
        java.lang.Object getMetricsEnabled();
        /**
         * `CfnDeployment.StageDescriptionProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-tags
         */
        java.util.List<software.amazon.awscdk.CfnTag> getTags();
        /**
         * `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
         */
        java.lang.Object getThrottlingBurstLimit();
        /**
         * `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
         */
        java.lang.Object getThrottlingRateLimit();
        /**
         * `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled
         */
        java.lang.Object getTracingEnabled();
        /**
         * `CfnDeployment.StageDescriptionProperty.Variables`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
         */
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link StageDescriptionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StageDescriptionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _accessLogSetting;
            @javax.annotation.Nullable
            private java.lang.Object _cacheClusterEnabled;
            @javax.annotation.Nullable
            private java.lang.String _cacheClusterSize;
            @javax.annotation.Nullable
            private java.lang.Object _cacheDataEncrypted;
            @javax.annotation.Nullable
            private java.lang.Object _cacheTtlInSeconds;
            @javax.annotation.Nullable
            private java.lang.Object _cachingEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _canarySetting;
            @javax.annotation.Nullable
            private java.lang.String _clientCertificateId;
            @javax.annotation.Nullable
            private java.lang.Object _dataTraceEnabled;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.String _documentationVersion;
            @javax.annotation.Nullable
            private java.lang.String _loggingLevel;
            @javax.annotation.Nullable
            private java.lang.Object _methodSettings;
            @javax.annotation.Nullable
            private java.lang.Object _metricsEnabled;
            @javax.annotation.Nullable
            private java.util.List<software.amazon.awscdk.CfnTag> _tags;
            @javax.annotation.Nullable
            private java.lang.Object _throttlingBurstLimit;
            @javax.annotation.Nullable
            private java.lang.Object _throttlingRateLimit;
            @javax.annotation.Nullable
            private java.lang.Object _tracingEnabled;
            @javax.annotation.Nullable
            private java.lang.Object _variables;

            /**
             * Sets the value of AccessLogSetting
             * @param value `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
             * @return {@code this}
             */
            public Builder withAccessLogSetting(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._accessLogSetting = value;
                return this;
            }
            /**
             * Sets the value of AccessLogSetting
             * @param value `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
             * @return {@code this}
             */
            public Builder withAccessLogSetting(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.CfnDeployment.AccessLogSettingProperty value) {
                this._accessLogSetting = value;
                return this;
            }
            /**
             * Sets the value of CacheClusterEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
             * @return {@code this}
             */
            public Builder withCacheClusterEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cacheClusterEnabled = value;
                return this;
            }
            /**
             * Sets the value of CacheClusterEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
             * @return {@code this}
             */
            public Builder withCacheClusterEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheClusterEnabled = value;
                return this;
            }
            /**
             * Sets the value of CacheClusterSize
             * @param value `CfnDeployment.StageDescriptionProperty.CacheClusterSize`.
             * @return {@code this}
             */
            public Builder withCacheClusterSize(@javax.annotation.Nullable final java.lang.String value) {
                this._cacheClusterSize = value;
                return this;
            }
            /**
             * Sets the value of CacheDataEncrypted
             * @param value `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            public Builder withCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cacheDataEncrypted = value;
                return this;
            }
            /**
             * Sets the value of CacheDataEncrypted
             * @param value `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            public Builder withCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheDataEncrypted = value;
                return this;
            }
            /**
             * Sets the value of CacheTtlInSeconds
             * @param value `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            public Builder withCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * Sets the value of CacheTtlInSeconds
             * @param value `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            public Builder withCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * Sets the value of CachingEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
             * @return {@code this}
             */
            public Builder withCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._cachingEnabled = value;
                return this;
            }
            /**
             * Sets the value of CachingEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
             * @return {@code this}
             */
            public Builder withCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cachingEnabled = value;
                return this;
            }
            /**
             * Sets the value of CanarySetting
             * @param value `CfnDeployment.StageDescriptionProperty.CanarySetting`.
             * @return {@code this}
             */
            public Builder withCanarySetting(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._canarySetting = value;
                return this;
            }
            /**
             * Sets the value of CanarySetting
             * @param value `CfnDeployment.StageDescriptionProperty.CanarySetting`.
             * @return {@code this}
             */
            public Builder withCanarySetting(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.CfnDeployment.CanarySettingProperty value) {
                this._canarySetting = value;
                return this;
            }
            /**
             * Sets the value of ClientCertificateId
             * @param value `CfnDeployment.StageDescriptionProperty.ClientCertificateId`.
             * @return {@code this}
             */
            public Builder withClientCertificateId(@javax.annotation.Nullable final java.lang.String value) {
                this._clientCertificateId = value;
                return this;
            }
            /**
             * Sets the value of DataTraceEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            public Builder withDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._dataTraceEnabled = value;
                return this;
            }
            /**
             * Sets the value of DataTraceEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            public Builder withDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._dataTraceEnabled = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnDeployment.StageDescriptionProperty.Description`.
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DocumentationVersion
             * @param value `CfnDeployment.StageDescriptionProperty.DocumentationVersion`.
             * @return {@code this}
             */
            public Builder withDocumentationVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._documentationVersion = value;
                return this;
            }
            /**
             * Sets the value of LoggingLevel
             * @param value `CfnDeployment.StageDescriptionProperty.LoggingLevel`.
             * @return {@code this}
             */
            public Builder withLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this._loggingLevel = value;
                return this;
            }
            /**
             * Sets the value of MethodSettings
             * @param value `CfnDeployment.StageDescriptionProperty.MethodSettings`.
             * @return {@code this}
             */
            public Builder withMethodSettings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._methodSettings = value;
                return this;
            }
            /**
             * Sets the value of MethodSettings
             * @param value `CfnDeployment.StageDescriptionProperty.MethodSettings`.
             * @return {@code this}
             */
            public Builder withMethodSettings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._methodSettings = value;
                return this;
            }
            /**
             * Sets the value of MetricsEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
             * @return {@code this}
             */
            public Builder withMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._metricsEnabled = value;
                return this;
            }
            /**
             * Sets the value of MetricsEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
             * @return {@code this}
             */
            public Builder withMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._metricsEnabled = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value `CfnDeployment.StageDescriptionProperty.Tags`.
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
                this._tags = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingBurstLimit
             * @param value `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this._throttlingBurstLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingBurstLimit
             * @param value `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._throttlingBurstLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingRateLimit
             * @param value `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this._throttlingRateLimit = value;
                return this;
            }
            /**
             * Sets the value of ThrottlingRateLimit
             * @param value `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            public Builder withThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._throttlingRateLimit = value;
                return this;
            }
            /**
             * Sets the value of TracingEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
             * @return {@code this}
             */
            public Builder withTracingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._tracingEnabled = value;
                return this;
            }
            /**
             * Sets the value of TracingEnabled
             * @param value `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
             * @return {@code this}
             */
            public Builder withTracingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tracingEnabled = value;
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnDeployment.StageDescriptionProperty.Variables`.
             * @return {@code this}
             */
            public Builder withVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._variables = value;
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnDeployment.StageDescriptionProperty.Variables`.
             * @return {@code this}
             */
            public Builder withVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._variables = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StageDescriptionProperty build() {
                return new StageDescriptionProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $accessLogSetting = _accessLogSetting;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cacheClusterEnabled = _cacheClusterEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.String $cacheClusterSize = _cacheClusterSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cacheDataEncrypted = _cacheDataEncrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cacheTtlInSeconds = _cacheTtlInSeconds;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cachingEnabled = _cachingEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.Object $canarySetting = _canarySetting;
                    @javax.annotation.Nullable
                    private final java.lang.String $clientCertificateId = _clientCertificateId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $dataTraceEnabled = _dataTraceEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.String $documentationVersion = _documentationVersion;
                    @javax.annotation.Nullable
                    private final java.lang.String $loggingLevel = _loggingLevel;
                    @javax.annotation.Nullable
                    private final java.lang.Object $methodSettings = _methodSettings;
                    @javax.annotation.Nullable
                    private final java.lang.Object $metricsEnabled = _metricsEnabled;
                    @javax.annotation.Nullable
                    private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;
                    @javax.annotation.Nullable
                    private final java.lang.Object $throttlingBurstLimit = _throttlingBurstLimit;
                    @javax.annotation.Nullable
                    private final java.lang.Object $throttlingRateLimit = _throttlingRateLimit;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tracingEnabled = _tracingEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.Object $variables = _variables;

                    @Override
                    public java.lang.Object getAccessLogSetting() {
                        return this.$accessLogSetting;
                    }

                    @Override
                    public java.lang.Object getCacheClusterEnabled() {
                        return this.$cacheClusterEnabled;
                    }

                    @Override
                    public java.lang.String getCacheClusterSize() {
                        return this.$cacheClusterSize;
                    }

                    @Override
                    public java.lang.Object getCacheDataEncrypted() {
                        return this.$cacheDataEncrypted;
                    }

                    @Override
                    public java.lang.Object getCacheTtlInSeconds() {
                        return this.$cacheTtlInSeconds;
                    }

                    @Override
                    public java.lang.Object getCachingEnabled() {
                        return this.$cachingEnabled;
                    }

                    @Override
                    public java.lang.Object getCanarySetting() {
                        return this.$canarySetting;
                    }

                    @Override
                    public java.lang.String getClientCertificateId() {
                        return this.$clientCertificateId;
                    }

                    @Override
                    public java.lang.Object getDataTraceEnabled() {
                        return this.$dataTraceEnabled;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.String getDocumentationVersion() {
                        return this.$documentationVersion;
                    }

                    @Override
                    public java.lang.String getLoggingLevel() {
                        return this.$loggingLevel;
                    }

                    @Override
                    public java.lang.Object getMethodSettings() {
                        return this.$methodSettings;
                    }

                    @Override
                    public java.lang.Object getMetricsEnabled() {
                        return this.$metricsEnabled;
                    }

                    @Override
                    public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                        return this.$tags;
                    }

                    @Override
                    public java.lang.Object getThrottlingBurstLimit() {
                        return this.$throttlingBurstLimit;
                    }

                    @Override
                    public java.lang.Object getThrottlingRateLimit() {
                        return this.$throttlingRateLimit;
                    }

                    @Override
                    public java.lang.Object getTracingEnabled() {
                        return this.$tracingEnabled;
                    }

                    @Override
                    public java.lang.Object getVariables() {
                        return this.$variables;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
                        obj.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
                        obj.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
                        obj.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                        obj.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                        obj.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                        obj.set("canarySetting", om.valueToTree(this.getCanarySetting()));
                        obj.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
                        obj.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                        obj.set("description", om.valueToTree(this.getDescription()));
                        obj.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
                        obj.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                        obj.set("methodSettings", om.valueToTree(this.getMethodSettings()));
                        obj.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                        obj.set("tags", om.valueToTree(this.getTags()));
                        obj.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                        obj.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                        obj.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
                        obj.set("variables", om.valueToTree(this.getVariables()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnDeployment.StageDescriptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.AccessLogSetting`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAccessLogSetting() {
                return this.jsiiGet("accessLogSetting", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.CacheClusterEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheClusterEnabled() {
                return this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.CacheClusterSize`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCacheClusterSize() {
                return this.jsiiGet("cacheClusterSize", java.lang.String.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.CacheDataEncrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheDataEncrypted() {
                return this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheTtlInSeconds() {
                return this.jsiiGet("cacheTtlInSeconds", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.CachingEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCachingEnabled() {
                return this.jsiiGet("cachingEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.CanarySetting`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCanarySetting() {
                return this.jsiiGet("canarySetting", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.ClientCertificateId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getClientCertificateId() {
                return this.jsiiGet("clientCertificateId", java.lang.String.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.DataTraceEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDataTraceEnabled() {
                return this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.DocumentationVersion`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDocumentationVersion() {
                return this.jsiiGet("documentationVersion", java.lang.String.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.LoggingLevel`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLoggingLevel() {
                return this.jsiiGet("loggingLevel", java.lang.String.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.MethodSettings`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMethodSettings() {
                return this.jsiiGet("methodSettings", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.MetricsEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMetricsEnabled() {
                return this.jsiiGet("metricsEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.Tags`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-tags
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.jsiiGet("tags", java.util.List.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingBurstLimit() {
                return this.jsiiGet("throttlingBurstLimit", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingRateLimit() {
                return this.jsiiGet("throttlingRateLimit", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.TracingEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTracingEnabled() {
                return this.jsiiGet("tracingEnabled", java.lang.Object.class);
            }

            /**
             * `CfnDeployment.StageDescriptionProperty.Variables`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
        }
    }
}
