package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::DocumentationPart`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:05:16.113Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDocumentationPart")
public class CfnDocumentationPart extends software.amazon.awscdk.CfnResource {
    protected CfnDocumentationPart(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnDocumentationPart.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ApiGateway::DocumentationPart`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnDocumentationPart(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnDocumentationPartProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getDocumentationPartId() {
        return this.jsiiGet("documentationPartId", java.lang.String.class);
    }

    public software.amazon.awscdk.services.apigateway.CfnDocumentationPartProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.CfnDocumentationPartProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html
     */
    public static interface LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDocumentationPart.LocationProperty.Method`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
         */
        java.lang.String getMethod();
        /**
         * `CfnDocumentationPart.LocationProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
         */
        java.lang.String getName();
        /**
         * `CfnDocumentationPart.LocationProperty.Path`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
         */
        java.lang.String getPath();
        /**
         * `CfnDocumentationPart.LocationProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
         */
        java.lang.String getStatusCode();
        /**
         * `CfnDocumentationPart.LocationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
         */
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LocationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _method;
            @javax.annotation.Nullable
            private java.lang.String _name;
            @javax.annotation.Nullable
            private java.lang.String _path;
            @javax.annotation.Nullable
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.String _type;

            /**
             * Sets the value of Method
             * @param value `CfnDocumentationPart.LocationProperty.Method`.
             * @return {@code this}
             */
            public Builder withMethod(@javax.annotation.Nullable final java.lang.String value) {
                this._method = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value `CfnDocumentationPart.LocationProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value `CfnDocumentationPart.LocationProperty.Path`.
             * @return {@code this}
             */
            public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
                this._path = value;
                return this;
            }
            /**
             * Sets the value of StatusCode
             * @param value `CfnDocumentationPart.LocationProperty.StatusCode`.
             * @return {@code this}
             */
            public Builder withStatusCode(@javax.annotation.Nullable final java.lang.String value) {
                this._statusCode = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnDocumentationPart.LocationProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LocationProperty build() {
                return new LocationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $method = _method;
                    @javax.annotation.Nullable
                    private final java.lang.String $name = _name;
                    @javax.annotation.Nullable
                    private final java.lang.String $path = _path;
                    @javax.annotation.Nullable
                    private final java.lang.String $statusCode = _statusCode;
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;

                    @Override
                    public java.lang.String getMethod() {
                        return this.$method;
                    }

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public java.lang.String getPath() {
                        return this.$path;
                    }

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("method", om.valueToTree(this.getMethod()));
                        obj.set("name", om.valueToTree(this.getName()));
                        obj.set("path", om.valueToTree(this.getPath()));
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnDocumentationPart.LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDocumentationPart.LocationProperty.Method`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMethod() {
                return this.jsiiGet("method", java.lang.String.class);
            }

            /**
             * `CfnDocumentationPart.LocationProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * `CfnDocumentationPart.LocationProperty.Path`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPath() {
                return this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * `CfnDocumentationPart.LocationProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnDocumentationPart.LocationProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
}
