package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::Method`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:13:10.620Z")
public interface CfnMethodProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    java.lang.String getHttpMethod();
    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    java.lang.String getResourceId();
    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    java.lang.String getRestApiId();
    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    java.lang.Object getApiKeyRequired();
    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    java.util.List<java.lang.String> getAuthorizationScopes();
    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    java.lang.String getAuthorizationType();
    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    java.lang.String getAuthorizerId();
    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    java.lang.Object getIntegration();
    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    java.lang.Object getMethodResponses();
    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    java.lang.String getOperationName();
    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    java.lang.Object getRequestModels();
    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    java.lang.Object getRequestParameters();
    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    java.lang.String getRequestValidatorId();

    /**
     * @return a {@link Builder} of {@link CfnMethodProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnMethodProps}
     */
    final class Builder {
        private java.lang.String _httpMethod;
        private java.lang.String _resourceId;
        private java.lang.String _restApiId;
        @javax.annotation.Nullable
        private java.lang.Object _apiKeyRequired;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _authorizationScopes;
        @javax.annotation.Nullable
        private java.lang.String _authorizationType;
        @javax.annotation.Nullable
        private java.lang.String _authorizerId;
        @javax.annotation.Nullable
        private java.lang.Object _integration;
        @javax.annotation.Nullable
        private java.lang.Object _methodResponses;
        @javax.annotation.Nullable
        private java.lang.String _operationName;
        @javax.annotation.Nullable
        private java.lang.Object _requestModels;
        @javax.annotation.Nullable
        private java.lang.Object _requestParameters;
        @javax.annotation.Nullable
        private java.lang.String _requestValidatorId;

        /**
         * Sets the value of HttpMethod
         * @param value `AWS::ApiGateway::Method.HttpMethod`.
         * @return {@code this}
         */
        public Builder withHttpMethod(final java.lang.String value) {
            this._httpMethod = java.util.Objects.requireNonNull(value, "httpMethod is required");
            return this;
        }
        /**
         * Sets the value of ResourceId
         * @param value `AWS::ApiGateway::Method.ResourceId`.
         * @return {@code this}
         */
        public Builder withResourceId(final java.lang.String value) {
            this._resourceId = java.util.Objects.requireNonNull(value, "resourceId is required");
            return this;
        }
        /**
         * Sets the value of RestApiId
         * @param value `AWS::ApiGateway::Method.RestApiId`.
         * @return {@code this}
         */
        public Builder withRestApiId(final java.lang.String value) {
            this._restApiId = java.util.Objects.requireNonNull(value, "restApiId is required");
            return this;
        }
        /**
         * Sets the value of ApiKeyRequired
         * @param value `AWS::ApiGateway::Method.ApiKeyRequired`.
         * @return {@code this}
         */
        public Builder withApiKeyRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._apiKeyRequired = value;
            return this;
        }
        /**
         * Sets the value of ApiKeyRequired
         * @param value `AWS::ApiGateway::Method.ApiKeyRequired`.
         * @return {@code this}
         */
        public Builder withApiKeyRequired(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._apiKeyRequired = value;
            return this;
        }
        /**
         * Sets the value of AuthorizationScopes
         * @param value `AWS::ApiGateway::Method.AuthorizationScopes`.
         * @return {@code this}
         */
        public Builder withAuthorizationScopes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._authorizationScopes = value;
            return this;
        }
        /**
         * Sets the value of AuthorizationType
         * @param value `AWS::ApiGateway::Method.AuthorizationType`.
         * @return {@code this}
         */
        public Builder withAuthorizationType(@javax.annotation.Nullable final java.lang.String value) {
            this._authorizationType = value;
            return this;
        }
        /**
         * Sets the value of AuthorizerId
         * @param value `AWS::ApiGateway::Method.AuthorizerId`.
         * @return {@code this}
         */
        public Builder withAuthorizerId(@javax.annotation.Nullable final java.lang.String value) {
            this._authorizerId = value;
            return this;
        }
        /**
         * Sets the value of Integration
         * @param value `AWS::ApiGateway::Method.Integration`.
         * @return {@code this}
         */
        public Builder withIntegration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._integration = value;
            return this;
        }
        /**
         * Sets the value of Integration
         * @param value `AWS::ApiGateway::Method.Integration`.
         * @return {@code this}
         */
        public Builder withIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty value) {
            this._integration = value;
            return this;
        }
        /**
         * Sets the value of MethodResponses
         * @param value `AWS::ApiGateway::Method.MethodResponses`.
         * @return {@code this}
         */
        public Builder withMethodResponses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._methodResponses = value;
            return this;
        }
        /**
         * Sets the value of MethodResponses
         * @param value `AWS::ApiGateway::Method.MethodResponses`.
         * @return {@code this}
         */
        public Builder withMethodResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._methodResponses = value;
            return this;
        }
        /**
         * Sets the value of OperationName
         * @param value `AWS::ApiGateway::Method.OperationName`.
         * @return {@code this}
         */
        public Builder withOperationName(@javax.annotation.Nullable final java.lang.String value) {
            this._operationName = value;
            return this;
        }
        /**
         * Sets the value of RequestModels
         * @param value `AWS::ApiGateway::Method.RequestModels`.
         * @return {@code this}
         */
        public Builder withRequestModels(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._requestModels = value;
            return this;
        }
        /**
         * Sets the value of RequestModels
         * @param value `AWS::ApiGateway::Method.RequestModels`.
         * @return {@code this}
         */
        public Builder withRequestModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._requestModels = value;
            return this;
        }
        /**
         * Sets the value of RequestParameters
         * @param value `AWS::ApiGateway::Method.RequestParameters`.
         * @return {@code this}
         */
        public Builder withRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._requestParameters = value;
            return this;
        }
        /**
         * Sets the value of RequestParameters
         * @param value `AWS::ApiGateway::Method.RequestParameters`.
         * @return {@code this}
         */
        public Builder withRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._requestParameters = value;
            return this;
        }
        /**
         * Sets the value of RequestValidatorId
         * @param value `AWS::ApiGateway::Method.RequestValidatorId`.
         * @return {@code this}
         */
        public Builder withRequestValidatorId(@javax.annotation.Nullable final java.lang.String value) {
            this._requestValidatorId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMethodProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnMethodProps build() {
            return new CfnMethodProps() {
                private final java.lang.String $httpMethod = java.util.Objects.requireNonNull(_httpMethod, "httpMethod is required");
                private final java.lang.String $resourceId = java.util.Objects.requireNonNull(_resourceId, "resourceId is required");
                private final java.lang.String $restApiId = java.util.Objects.requireNonNull(_restApiId, "restApiId is required");
                @javax.annotation.Nullable
                private final java.lang.Object $apiKeyRequired = _apiKeyRequired;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $authorizationScopes = _authorizationScopes;
                @javax.annotation.Nullable
                private final java.lang.String $authorizationType = _authorizationType;
                @javax.annotation.Nullable
                private final java.lang.String $authorizerId = _authorizerId;
                @javax.annotation.Nullable
                private final java.lang.Object $integration = _integration;
                @javax.annotation.Nullable
                private final java.lang.Object $methodResponses = _methodResponses;
                @javax.annotation.Nullable
                private final java.lang.String $operationName = _operationName;
                @javax.annotation.Nullable
                private final java.lang.Object $requestModels = _requestModels;
                @javax.annotation.Nullable
                private final java.lang.Object $requestParameters = _requestParameters;
                @javax.annotation.Nullable
                private final java.lang.String $requestValidatorId = _requestValidatorId;

                @Override
                public java.lang.String getHttpMethod() {
                    return this.$httpMethod;
                }

                @Override
                public java.lang.String getResourceId() {
                    return this.$resourceId;
                }

                @Override
                public java.lang.String getRestApiId() {
                    return this.$restApiId;
                }

                @Override
                public java.lang.Object getApiKeyRequired() {
                    return this.$apiKeyRequired;
                }

                @Override
                public java.util.List<java.lang.String> getAuthorizationScopes() {
                    return this.$authorizationScopes;
                }

                @Override
                public java.lang.String getAuthorizationType() {
                    return this.$authorizationType;
                }

                @Override
                public java.lang.String getAuthorizerId() {
                    return this.$authorizerId;
                }

                @Override
                public java.lang.Object getIntegration() {
                    return this.$integration;
                }

                @Override
                public java.lang.Object getMethodResponses() {
                    return this.$methodResponses;
                }

                @Override
                public java.lang.String getOperationName() {
                    return this.$operationName;
                }

                @Override
                public java.lang.Object getRequestModels() {
                    return this.$requestModels;
                }

                @Override
                public java.lang.Object getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public java.lang.String getRequestValidatorId() {
                    return this.$requestValidatorId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                    obj.set("resourceId", om.valueToTree(this.getResourceId()));
                    obj.set("restApiId", om.valueToTree(this.getRestApiId()));
                    obj.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
                    obj.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
                    obj.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
                    obj.set("authorizerId", om.valueToTree(this.getAuthorizerId()));
                    obj.set("integration", om.valueToTree(this.getIntegration()));
                    obj.set("methodResponses", om.valueToTree(this.getMethodResponses()));
                    obj.set("operationName", om.valueToTree(this.getOperationName()));
                    obj.set("requestModels", om.valueToTree(this.getRequestModels()));
                    obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                    obj.set("requestValidatorId", om.valueToTree(this.getRequestValidatorId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnMethodProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::ApiGateway::Method.HttpMethod`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         */
        @Override
        public java.lang.String getHttpMethod() {
            return this.jsiiGet("httpMethod", java.lang.String.class);
        }

        /**
         * `AWS::ApiGateway::Method.ResourceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
         */
        @Override
        public java.lang.String getResourceId() {
            return this.jsiiGet("resourceId", java.lang.String.class);
        }

        /**
         * `AWS::ApiGateway::Method.RestApiId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
         */
        @Override
        public java.lang.String getRestApiId() {
            return this.jsiiGet("restApiId", java.lang.String.class);
        }

        /**
         * `AWS::ApiGateway::Method.ApiKeyRequired`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getApiKeyRequired() {
            return this.jsiiGet("apiKeyRequired", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGateway::Method.AuthorizationScopes`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.jsiiGet("authorizationScopes", java.util.List.class);
        }

        /**
         * `AWS::ApiGateway::Method.AuthorizationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAuthorizationType() {
            return this.jsiiGet("authorizationType", java.lang.String.class);
        }

        /**
         * `AWS::ApiGateway::Method.AuthorizerId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAuthorizerId() {
            return this.jsiiGet("authorizerId", java.lang.String.class);
        }

        /**
         * `AWS::ApiGateway::Method.Integration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getIntegration() {
            return this.jsiiGet("integration", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGateway::Method.MethodResponses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getMethodResponses() {
            return this.jsiiGet("methodResponses", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGateway::Method.OperationName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOperationName() {
            return this.jsiiGet("operationName", java.lang.String.class);
        }

        /**
         * `AWS::ApiGateway::Method.RequestModels`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getRequestModels() {
            return this.jsiiGet("requestModels", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGateway::Method.RequestParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getRequestParameters() {
            return this.jsiiGet("requestParameters", java.lang.Object.class);
        }

        /**
         * `AWS::ApiGateway::Method.RequestValidatorId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRequestValidatorId() {
            return this.jsiiGet("requestValidatorId", java.lang.String.class);
        }
    }
}
