package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:13:10.646Z")
public interface DeploymentProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Rest API to deploy.
     */
    software.amazon.awscdk.services.apigateway.IRestApi getApi();
    /**
     * A description of the purpose of the API Gateway deployment.
     */
    java.lang.String getDescription();
    /**
     * When an API Gateway model is updated, a new deployment will automatically be created. If this is true (default), the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example.
     * 
     * Default: false
     */
    java.lang.Boolean getRetainDeployments();

    /**
     * @return a {@link Builder} of {@link DeploymentProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DeploymentProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.apigateway.IRestApi _api;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _retainDeployments;

        /**
         * Sets the value of Api
         * @param value The Rest API to deploy.
         * @return {@code this}
         */
        public Builder withApi(final software.amazon.awscdk.services.apigateway.IRestApi value) {
            this._api = java.util.Objects.requireNonNull(value, "api is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the API Gateway deployment.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of RetainDeployments
         * @param value When an API Gateway model is updated, a new deployment will automatically be created. If this is true (default), the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example.
         * @return {@code this}
         */
        public Builder withRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._retainDeployments = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public DeploymentProps build() {
            return new DeploymentProps() {
                private final software.amazon.awscdk.services.apigateway.IRestApi $api = java.util.Objects.requireNonNull(_api, "api is required");
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.Boolean $retainDeployments = _retainDeployments;

                @Override
                public software.amazon.awscdk.services.apigateway.IRestApi getApi() {
                    return this.$api;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("api", om.valueToTree(this.getApi()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.DeploymentProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Rest API to deploy.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.IRestApi getApi() {
            return this.jsiiGet("api", software.amazon.awscdk.services.apigateway.IRestApi.class);
        }

        /**
         * A description of the purpose of the API Gateway deployment.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * When an API Gateway model is updated, a new deployment will automatically be created. If this is true (default), the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getRetainDeployments() {
            return this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }
    }
}
