/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface DeploymentProps
extends JsiiSerializable {
    public IRestApi getApi();

    public String getDescription();

    public Boolean getRetainDeployments();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IRestApi _api;
        @Nullable
        private String _description;
        @Nullable
        private Boolean _retainDeployments;

        public Builder withApi(IRestApi value) {
            this._api = Objects.requireNonNull(value, "api is required");
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withRetainDeployments(@Nullable Boolean value) {
            this._retainDeployments = value;
            return this;
        }

        public DeploymentProps build() {
            return new DeploymentProps(){
                private final IRestApi $api;
                @Nullable
                private final String $description;
                @Nullable
                private final Boolean $retainDeployments;
                {
                    this.$api = Objects.requireNonNull(_api, "api is required");
                    this.$description = _description;
                    this.$retainDeployments = _retainDeployments;
                }

                @Override
                public IRestApi getApi() {
                    return this.$api;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("api", om.valueToTree((Object)this.getApi()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("retainDeployments", om.valueToTree((Object)this.getRetainDeployments()));
                    return obj;
                }
            };
        }
    }
}

