/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IRestApiResource;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.ResourceOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ProxyResourceProps
extends JsiiSerializable,
ResourceOptions {
    public IRestApiResource getParent();

    public Boolean getAnyMethod();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IRestApiResource _parent;
        @Nullable
        private Boolean _anyMethod;
        @Nullable
        private Integration _defaultIntegration;
        @Nullable
        private MethodOptions _defaultMethodOptions;

        public Builder withParent(IRestApiResource value) {
            this._parent = Objects.requireNonNull(value, "parent is required");
            return this;
        }

        public Builder withAnyMethod(@Nullable Boolean value) {
            this._anyMethod = value;
            return this;
        }

        public Builder withDefaultIntegration(@Nullable Integration value) {
            this._defaultIntegration = value;
            return this;
        }

        public Builder withDefaultMethodOptions(@Nullable MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        public ProxyResourceProps build() {
            return new ProxyResourceProps(){
                private final IRestApiResource $parent;
                @Nullable
                private final Boolean $anyMethod;
                @Nullable
                private final Integration $defaultIntegration;
                @Nullable
                private final MethodOptions $defaultMethodOptions;
                {
                    this.$parent = Objects.requireNonNull(_parent, "parent is required");
                    this.$anyMethod = _anyMethod;
                    this.$defaultIntegration = _defaultIntegration;
                    this.$defaultMethodOptions = _defaultMethodOptions;
                }

                @Override
                public IRestApiResource getParent() {
                    return this.$parent;
                }

                @Override
                public Boolean getAnyMethod() {
                    return this.$anyMethod;
                }

                @Override
                public Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("parent", om.valueToTree((Object)this.getParent()));
                    obj.set("anyMethod", om.valueToTree((Object)this.getAnyMethod()));
                    obj.set("defaultIntegration", om.valueToTree((Object)this.getDefaultIntegration()));
                    obj.set("defaultMethodOptions", om.valueToTree((Object)this.getDefaultMethodOptions()));
                    return obj;
                }
            };
        }
    }
}

