package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:55:31.073Z")
public interface ProxyResourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {
    /**
     * The parent resource of this resource.
     * 
     * You can either pass another
     * `Resource` object or a `RestApi` object here.
     */
    software.amazon.awscdk.services.apigateway.IResource getParent();
    /**
     * Adds an "ANY" method to this resource.
     * 
     * If set to `false`, you will have to explicitly
     * add methods to this resource after it's created.
     * 
     * Default: true
     */
    java.lang.Boolean getAnyMethod();

    /**
     * @return a {@link Builder} of {@link ProxyResourceProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ProxyResourceProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.apigateway.IResource _parent;
        @javax.annotation.Nullable
        private java.lang.Boolean _anyMethod;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Integration _defaultIntegration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodOptions _defaultMethodOptions;

        /**
         * Sets the value of Parent
         * @param value The parent resource of this resource.
         * @return {@code this}
         */
        public Builder withParent(final software.amazon.awscdk.services.apigateway.IResource value) {
            this._parent = java.util.Objects.requireNonNull(value, "parent is required");
            return this;
        }
        /**
         * Sets the value of AnyMethod
         * @param value Adds an "ANY" method to this resource.
         * @return {@code this}
         */
        public Builder withAnyMethod(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._anyMethod = value;
            return this;
        }
        /**
         * Sets the value of DefaultIntegration
         * @param value An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        public Builder withDefaultIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this._defaultIntegration = value;
            return this;
        }
        /**
         * Sets the value of DefaultMethodOptions
         * @param value Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        public Builder withDefaultMethodOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProxyResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ProxyResourceProps build() {
            return new ProxyResourceProps() {
                private final software.amazon.awscdk.services.apigateway.IResource $parent = java.util.Objects.requireNonNull(_parent, "parent is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $anyMethod = _anyMethod;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.Integration $defaultIntegration = _defaultIntegration;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.MethodOptions $defaultMethodOptions = _defaultMethodOptions;

                @Override
                public software.amazon.awscdk.services.apigateway.IResource getParent() {
                    return this.$parent;
                }

                @Override
                public java.lang.Boolean getAnyMethod() {
                    return this.$anyMethod;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("parent", om.valueToTree(this.getParent()));
                    obj.set("anyMethod", om.valueToTree(this.getAnyMethod()));
                    obj.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
                    obj.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ProxyResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The parent resource of this resource.
         * 
         * You can either pass another
         * `Resource` object or a `RestApi` object here.
         */
        @Override
        public software.amazon.awscdk.services.apigateway.IResource getParent() {
            return this.jsiiGet("parent", software.amazon.awscdk.services.apigateway.IResource.class);
        }

        /**
         * Adds an "ANY" method to this resource.
         * 
         * If set to `false`, you will have to explicitly
         * add methods to this resource after it's created.
         * 
         * Default: true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getAnyMethod() {
            return this.jsiiGet("anyMethod", java.lang.Boolean.class);
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }
    }
}
