package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::RestApi`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:17:57.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnRestApi")
public class CfnRestApi extends software.amazon.awscdk.CfnResource {
    protected CfnRestApi(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnRestApi.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ApiGateway::RestApi`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnRestApi(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.CfnRestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::ApiGateway::RestApi`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnRestApi(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.apigateway.CfnRestApiProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.apigateway.CfnRestApiProps.class);
    }

    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getRestApiRootResourceId() {
        return this.jsiiGet("restApiRootResourceId", java.lang.String.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     */
    public static interface EndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRestApi.EndpointConfigurationProperty.Types`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        java.util.List<java.lang.String> getTypes();

        /**
         * @return a {@link Builder} of {@link EndpointConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EndpointConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _types;

            /**
             * Sets the value of Types
             * @param value `CfnRestApi.EndpointConfigurationProperty.Types`.
             * @return {@code this}
             */
            public Builder withTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._types = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EndpointConfigurationProperty build() {
                return new EndpointConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $types = _types;

                    @Override
                    public java.util.List<java.lang.String> getTypes() {
                        return this.$types;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("types", om.valueToTree(this.getTypes()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRestApi.EndpointConfigurationProperty.Types`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getTypes() {
                return this.jsiiGet("types", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRestApi.S3LocationProperty.Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        java.lang.String getBucket();
        /**
         * `CfnRestApi.S3LocationProperty.ETag`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        java.lang.String getETag();
        /**
         * `CfnRestApi.S3LocationProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        java.lang.String getKey();
        /**
         * `CfnRestApi.S3LocationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _bucket;
            @javax.annotation.Nullable
            private java.lang.String _eTag;
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _version;

            /**
             * Sets the value of Bucket
             * @param value `CfnRestApi.S3LocationProperty.Bucket`.
             * @return {@code this}
             */
            public Builder withBucket(@javax.annotation.Nullable final java.lang.String value) {
                this._bucket = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value `CfnRestApi.S3LocationProperty.ETag`.
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final java.lang.String value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of Key
             * @param value `CfnRestApi.S3LocationProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnRestApi.S3LocationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $bucket = _bucket;
                    @javax.annotation.Nullable
                    private final java.lang.String $eTag = _eTag;
                    @javax.annotation.Nullable
                    private final java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private final java.lang.String $version = _version;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.String getETag() {
                        return this.$eTag;
                    }

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("eTag", om.valueToTree(this.getETag()));
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("version", om.valueToTree(this.getVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRestApi.S3LocationProperty.Bucket`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnRestApi.S3LocationProperty.ETag`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getETag() {
                return this.jsiiGet("eTag", java.lang.String.class);
            }

            /**
             * `CfnRestApi.S3LocationProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnRestApi.S3LocationProperty.Version`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }
        }
    }
}
