/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnApiV2Props
extends JsiiSerializable {
    public String getName();

    public String getProtocolType();

    public String getRouteSelectionExpression();

    public String getApiKeySelectionExpression();

    public String getDescription();

    public Object getDisableSchemaValidation();

    public String getVersion();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        private String _protocolType;
        private String _routeSelectionExpression;
        @Nullable
        private String _apiKeySelectionExpression;
        @Nullable
        private String _description;
        @Nullable
        private Object _disableSchemaValidation;
        @Nullable
        private String _version;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withProtocolType(String value) {
            this._protocolType = Objects.requireNonNull(value, "protocolType is required");
            return this;
        }

        public Builder withRouteSelectionExpression(String value) {
            this._routeSelectionExpression = Objects.requireNonNull(value, "routeSelectionExpression is required");
            return this;
        }

        public Builder withApiKeySelectionExpression(@Nullable String value) {
            this._apiKeySelectionExpression = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withDisableSchemaValidation(@Nullable Boolean value) {
            this._disableSchemaValidation = value;
            return this;
        }

        public Builder withDisableSchemaValidation(@Nullable Token value) {
            this._disableSchemaValidation = value;
            return this;
        }

        public Builder withVersion(@Nullable String value) {
            this._version = value;
            return this;
        }

        public CfnApiV2Props build() {
            return new CfnApiV2Props(){
                private final String $name;
                private final String $protocolType;
                private final String $routeSelectionExpression;
                @Nullable
                private final String $apiKeySelectionExpression;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $disableSchemaValidation;
                @Nullable
                private final String $version;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$protocolType = Objects.requireNonNull(_protocolType, "protocolType is required");
                    this.$routeSelectionExpression = Objects.requireNonNull(_routeSelectionExpression, "routeSelectionExpression is required");
                    this.$apiKeySelectionExpression = _apiKeySelectionExpression;
                    this.$description = _description;
                    this.$disableSchemaValidation = _disableSchemaValidation;
                    this.$version = _version;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getProtocolType() {
                    return this.$protocolType;
                }

                @Override
                public String getRouteSelectionExpression() {
                    return this.$routeSelectionExpression;
                }

                @Override
                public String getApiKeySelectionExpression() {
                    return this.$apiKeySelectionExpression;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getDisableSchemaValidation() {
                    return this.$disableSchemaValidation;
                }

                @Override
                public String getVersion() {
                    return this.$version;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("protocolType", om.valueToTree((Object)this.getProtocolType()));
                    obj.set("routeSelectionExpression", om.valueToTree((Object)this.getRouteSelectionExpression()));
                    obj.set("apiKeySelectionExpression", om.valueToTree((Object)this.getApiKeySelectionExpression()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("disableSchemaValidation", om.valueToTree(this.getDisableSchemaValidation()));
                    obj.set("version", om.valueToTree((Object)this.getVersion()));
                    return obj;
                }
            };
        }
    }
}

