/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.Deployment;
import software.amazon.awscdk.services.apigateway.MethodDeploymentOptions;
import software.amazon.awscdk.services.apigateway.MethodLoggingLevel;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StageProps
extends JsiiSerializable,
StageOptions {
    public Deployment getDeployment();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Deployment _deployment;
        @Nullable
        private Boolean _cacheClusterEnabled;
        @Nullable
        private String _cacheClusterSize;
        @Nullable
        private String _clientCertificateId;
        @Nullable
        private String _description;
        @Nullable
        private String _documentationVersion;
        @Nullable
        private Map<String, MethodDeploymentOptions> _methodOptions;
        @Nullable
        private String _stageName;
        @Nullable
        private Boolean _tracingEnabled;
        @Nullable
        private Map<String, String> _variables;
        @Nullable
        private Boolean _cacheDataEncrypted;
        @Nullable
        private Number _cacheTtlSeconds;
        @Nullable
        private Boolean _cachingEnabled;
        @Nullable
        private Boolean _dataTraceEnabled;
        @Nullable
        private MethodLoggingLevel _loggingLevel;
        @Nullable
        private Boolean _metricsEnabled;
        @Nullable
        private Number _throttlingBurstLimit;
        @Nullable
        private Number _throttlingRateLimit;

        public Builder withDeployment(Deployment value) {
            this._deployment = Objects.requireNonNull(value, "deployment is required");
            return this;
        }

        public Builder withCacheClusterEnabled(@Nullable Boolean value) {
            this._cacheClusterEnabled = value;
            return this;
        }

        public Builder withCacheClusterSize(@Nullable String value) {
            this._cacheClusterSize = value;
            return this;
        }

        public Builder withClientCertificateId(@Nullable String value) {
            this._clientCertificateId = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withDocumentationVersion(@Nullable String value) {
            this._documentationVersion = value;
            return this;
        }

        public Builder withMethodOptions(@Nullable Map<String, MethodDeploymentOptions> value) {
            this._methodOptions = value;
            return this;
        }

        public Builder withStageName(@Nullable String value) {
            this._stageName = value;
            return this;
        }

        public Builder withTracingEnabled(@Nullable Boolean value) {
            this._tracingEnabled = value;
            return this;
        }

        public Builder withVariables(@Nullable Map<String, String> value) {
            this._variables = value;
            return this;
        }

        public Builder withCacheDataEncrypted(@Nullable Boolean value) {
            this._cacheDataEncrypted = value;
            return this;
        }

        public Builder withCacheTtlSeconds(@Nullable Number value) {
            this._cacheTtlSeconds = value;
            return this;
        }

        public Builder withCachingEnabled(@Nullable Boolean value) {
            this._cachingEnabled = value;
            return this;
        }

        public Builder withDataTraceEnabled(@Nullable Boolean value) {
            this._dataTraceEnabled = value;
            return this;
        }

        public Builder withLoggingLevel(@Nullable MethodLoggingLevel value) {
            this._loggingLevel = value;
            return this;
        }

        public Builder withMetricsEnabled(@Nullable Boolean value) {
            this._metricsEnabled = value;
            return this;
        }

        public Builder withThrottlingBurstLimit(@Nullable Number value) {
            this._throttlingBurstLimit = value;
            return this;
        }

        public Builder withThrottlingRateLimit(@Nullable Number value) {
            this._throttlingRateLimit = value;
            return this;
        }

        public StageProps build() {
            return new StageProps(){
                private final Deployment $deployment;
                @Nullable
                private final Boolean $cacheClusterEnabled;
                @Nullable
                private final String $cacheClusterSize;
                @Nullable
                private final String $clientCertificateId;
                @Nullable
                private final String $description;
                @Nullable
                private final String $documentationVersion;
                @Nullable
                private final Map<String, MethodDeploymentOptions> $methodOptions;
                @Nullable
                private final String $stageName;
                @Nullable
                private final Boolean $tracingEnabled;
                @Nullable
                private final Map<String, String> $variables;
                @Nullable
                private final Boolean $cacheDataEncrypted;
                @Nullable
                private final Number $cacheTtlSeconds;
                @Nullable
                private final Boolean $cachingEnabled;
                @Nullable
                private final Boolean $dataTraceEnabled;
                @Nullable
                private final MethodLoggingLevel $loggingLevel;
                @Nullable
                private final Boolean $metricsEnabled;
                @Nullable
                private final Number $throttlingBurstLimit;
                @Nullable
                private final Number $throttlingRateLimit;
                {
                    this.$deployment = Objects.requireNonNull(_deployment, "deployment is required");
                    this.$cacheClusterEnabled = _cacheClusterEnabled;
                    this.$cacheClusterSize = _cacheClusterSize;
                    this.$clientCertificateId = _clientCertificateId;
                    this.$description = _description;
                    this.$documentationVersion = _documentationVersion;
                    this.$methodOptions = _methodOptions;
                    this.$stageName = _stageName;
                    this.$tracingEnabled = _tracingEnabled;
                    this.$variables = _variables;
                    this.$cacheDataEncrypted = _cacheDataEncrypted;
                    this.$cacheTtlSeconds = _cacheTtlSeconds;
                    this.$cachingEnabled = _cachingEnabled;
                    this.$dataTraceEnabled = _dataTraceEnabled;
                    this.$loggingLevel = _loggingLevel;
                    this.$metricsEnabled = _metricsEnabled;
                    this.$throttlingBurstLimit = _throttlingBurstLimit;
                    this.$throttlingRateLimit = _throttlingRateLimit;
                }

                @Override
                public Deployment getDeployment() {
                    return this.$deployment;
                }

                @Override
                public Boolean getCacheClusterEnabled() {
                    return this.$cacheClusterEnabled;
                }

                @Override
                public String getCacheClusterSize() {
                    return this.$cacheClusterSize;
                }

                @Override
                public String getClientCertificateId() {
                    return this.$clientCertificateId;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getDocumentationVersion() {
                    return this.$documentationVersion;
                }

                @Override
                public Map<String, MethodDeploymentOptions> getMethodOptions() {
                    return this.$methodOptions;
                }

                @Override
                public String getStageName() {
                    return this.$stageName;
                }

                @Override
                public Boolean getTracingEnabled() {
                    return this.$tracingEnabled;
                }

                @Override
                public Map<String, String> getVariables() {
                    return this.$variables;
                }

                @Override
                public Boolean getCacheDataEncrypted() {
                    return this.$cacheDataEncrypted;
                }

                @Override
                public Number getCacheTtlSeconds() {
                    return this.$cacheTtlSeconds;
                }

                @Override
                public Boolean getCachingEnabled() {
                    return this.$cachingEnabled;
                }

                @Override
                public Boolean getDataTraceEnabled() {
                    return this.$dataTraceEnabled;
                }

                @Override
                public MethodLoggingLevel getLoggingLevel() {
                    return this.$loggingLevel;
                }

                @Override
                public Boolean getMetricsEnabled() {
                    return this.$metricsEnabled;
                }

                @Override
                public Number getThrottlingBurstLimit() {
                    return this.$throttlingBurstLimit;
                }

                @Override
                public Number getThrottlingRateLimit() {
                    return this.$throttlingRateLimit;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("deployment", om.valueToTree((Object)this.getDeployment()));
                    obj.set("cacheClusterEnabled", om.valueToTree((Object)this.getCacheClusterEnabled()));
                    obj.set("cacheClusterSize", om.valueToTree((Object)this.getCacheClusterSize()));
                    obj.set("clientCertificateId", om.valueToTree((Object)this.getClientCertificateId()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("documentationVersion", om.valueToTree((Object)this.getDocumentationVersion()));
                    obj.set("methodOptions", om.valueToTree(this.getMethodOptions()));
                    obj.set("stageName", om.valueToTree((Object)this.getStageName()));
                    obj.set("tracingEnabled", om.valueToTree((Object)this.getTracingEnabled()));
                    obj.set("variables", om.valueToTree(this.getVariables()));
                    obj.set("cacheDataEncrypted", om.valueToTree((Object)this.getCacheDataEncrypted()));
                    obj.set("cacheTtlSeconds", om.valueToTree((Object)this.getCacheTtlSeconds()));
                    obj.set("cachingEnabled", om.valueToTree((Object)this.getCachingEnabled()));
                    obj.set("dataTraceEnabled", om.valueToTree((Object)this.getDataTraceEnabled()));
                    obj.set("loggingLevel", om.valueToTree((Object)this.getLoggingLevel()));
                    obj.set("metricsEnabled", om.valueToTree((Object)this.getMetricsEnabled()));
                    obj.set("throttlingBurstLimit", om.valueToTree((Object)this.getThrottlingBurstLimit()));
                    obj.set("throttlingRateLimit", om.valueToTree((Object)this.getThrottlingRateLimit()));
                    return obj;
                }
            };
        }
    }
}

