package software.amazon.awscdk.services.apigateway;

/**
 * ApiKey Properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:06:14.362Z")
public interface ApiKeyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {
    /**
     * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
     * 
     * Default: none
     */
    java.lang.String getCustomerId();
    /**
     * A description of the purpose of the API key.
     * 
     * Default: none
     */
    java.lang.String getDescription();
    /**
     * Indicates whether the API key can be used by clients.
     * 
     * Default: true
     */
    java.lang.Boolean getEnabled();
    /**
     * Specifies whether the key identifier is distinct from the created API key value.
     * 
     * Default: false
     */
    java.lang.Boolean getGenerateDistinctId();
    /**
     * A name for the API key.
     * 
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
     * 
     * Default: automically generated name
     */
    java.lang.String getName();
    /**
     * A list of resources this api key is associated with.
     * 
     * Default: none
     */
    java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources();

    /**
     * @return a {@link Builder} of {@link ApiKeyProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApiKeyProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _customerId;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private java.lang.Boolean _generateDistinctId;
        @javax.annotation.Nullable
        private java.lang.String _name;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.RestApi> _resources;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Integration _defaultIntegration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodOptions _defaultMethodOptions;

        /**
         * Sets the value of CustomerId
         * @param value An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * @return {@code this}
         */
        public Builder withCustomerId(@javax.annotation.Nullable final java.lang.String value) {
            this._customerId = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the API key.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Indicates whether the API key can be used by clients.
         * @return {@code this}
         */
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of GenerateDistinctId
         * @param value Specifies whether the key identifier is distinct from the created API key value.
         * @return {@code this}
         */
        public Builder withGenerateDistinctId(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._generateDistinctId = value;
            return this;
        }
        /**
         * Sets the value of Name
         * @param value A name for the API key.
         * @return {@code this}
         */
        public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
            this._name = value;
            return this;
        }
        /**
         * Sets the value of Resources
         * @param value A list of resources this api key is associated with.
         * @return {@code this}
         */
        public Builder withResources(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> value) {
            this._resources = value;
            return this;
        }
        /**
         * Sets the value of DefaultIntegration
         * @param value An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        public Builder withDefaultIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this._defaultIntegration = value;
            return this;
        }
        /**
         * Sets the value of DefaultMethodOptions
         * @param value Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        public Builder withDefaultMethodOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApiKeyProps build() {
            return new ApiKeyProps() {
                @javax.annotation.Nullable
                private final java.lang.String $customerId = _customerId;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private final java.lang.Boolean $generateDistinctId = _generateDistinctId;
                @javax.annotation.Nullable
                private final java.lang.String $name = _name;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> $resources = _resources;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.Integration $defaultIntegration = _defaultIntegration;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.MethodOptions $defaultMethodOptions = _defaultMethodOptions;

                @Override
                public java.lang.String getCustomerId() {
                    return this.$customerId;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public java.lang.Boolean getGenerateDistinctId() {
                    return this.$generateDistinctId;
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
                    return this.$resources;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("customerId", om.valueToTree(this.getCustomerId()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                    obj.set("generateDistinctId", om.valueToTree(this.getGenerateDistinctId()));
                    obj.set("name", om.valueToTree(this.getName()));
                    obj.set("resources", om.valueToTree(this.getResources()));
                    obj.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
                    obj.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ApiKeyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCustomerId() {
            return this.jsiiGet("customerId", java.lang.String.class);
        }

        /**
         * A description of the purpose of the API key.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Indicates whether the API key can be used by clients.
         * 
         * Default: true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * Specifies whether the key identifier is distinct from the created API key value.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getGenerateDistinctId() {
            return this.jsiiGet("generateDistinctId", java.lang.Boolean.class);
        }

        /**
         * A name for the API key.
         * 
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * 
         * Default: automically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * A list of resources this api key is associated with.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
            return this.jsiiGet("resources", java.util.List.class);
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * 
         * Default: - Inherited from parent.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * 
         * Default: - Inherited from parent.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }
    }
}
