package software.amazon.awscdk.services.apigateway;

/**
 * Represents a reference to a REST API's Empty model, which is available as part of the model collection by default.
 * 
 * This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 * 
 * Definition
 * {
 *    "$schema" : "http://json-schema.org/draft-04/schema#",
 *    "title" : "Empty Schema",
 *    "type" : "object"
 * }
 * 
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:06:14.433Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.EmptyModel")
public class EmptyModel extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IModel {
    protected EmptyModel(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public EmptyModel() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    @Override
    public java.lang.String getModelId() {
        return this.jsiiGet("modelId", java.lang.String.class);
    }
}
