package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:06:14.446Z")
public interface MethodResponse extends software.amazon.jsii.JsiiSerializable {
    /**
     * The method response's status code, which you map to an IntegrationResponse. Required.
     */
    java.lang.String getStatusCode();
    /**
     * The resources used for the response's content type.
     * 
     * Specify response models as
     * key-value pairs (string-to-string maps), with a content type as the key and a Model
     * resource name as the value.
     * 
     * Default: None
     */
    java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels();
    /**
     * Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: method.response.header.name, where the name is a valid, unique header name. The Boolean specifies whether a parameter is required.
     * 
     * Default: None
     */
    java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters();

    /**
     * @return a {@link Builder} of {@link MethodResponse}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MethodResponse}
     */
    final class Builder {
        private java.lang.String _statusCode;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> _responseModels;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Boolean> _responseParameters;

        /**
         * Sets the value of StatusCode
         * @param value The method response's status code, which you map to an IntegrationResponse. Required.
         * @return {@code this}
         */
        public Builder withStatusCode(final java.lang.String value) {
            this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
            return this;
        }
        /**
         * Sets the value of ResponseModels
         * @param value The resources used for the response's content type.
         * @return {@code this}
         */
        public Builder withResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> value) {
            this._responseModels = value;
            return this;
        }
        /**
         * Sets the value of ResponseParameters
         * @param value Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: method.response.header.name, where the name is a valid, unique header name. The Boolean specifies whether a parameter is required.
         * @return {@code this}
         */
        public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Boolean> value) {
            this._responseParameters = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        public MethodResponse build() {
            return new MethodResponse() {
                private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> $responseModels = _responseModels;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Boolean> $responseParameters = _responseParameters;

                @Override
                public java.lang.String getStatusCode() {
                    return this.$statusCode;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
                    return this.$responseModels;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
                    return this.$responseParameters;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                    obj.set("responseModels", om.valueToTree(this.getResponseModels()));
                    obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.MethodResponse {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The method response's status code, which you map to an IntegrationResponse. Required.
         */
        @Override
        public java.lang.String getStatusCode() {
            return this.jsiiGet("statusCode", java.lang.String.class);
        }

        /**
         * The resources used for the response's content type.
         * 
         * Specify response models as
         * key-value pairs (string-to-string maps), with a content type as the key and a Model
         * resource name as the value.
         * 
         * Default: None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
            return this.jsiiGet("responseModels", java.util.Map.class);
        }

        /**
         * Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: method.response.header.name, where the name is a valid, unique header name. The Boolean specifies whether a parameter is required.
         * 
         * Default: None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
            return this.jsiiGet("responseParameters", java.util.Map.class);
        }
    }
}
