package software.amazon.awscdk.services.apigateway;

/**
 * Container for defining throttling parameters to API stages or methods.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:06:14.465Z")
public interface ThrottleSettings extends software.amazon.jsii.JsiiSerializable {
    /**
     * The maximum API request rate limit over a time ranging from one to a few seconds.
     * 
     * Default: none
     */
    java.lang.Number getBurstLimit();
    /**
     * The API request steady-state rate limit (average requests per second over an extended period of time).
     * 
     * Default: none
     */
    java.lang.Number getRateLimit();

    /**
     * @return a {@link Builder} of {@link ThrottleSettings}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ThrottleSettings}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _burstLimit;
        @javax.annotation.Nullable
        private java.lang.Number _rateLimit;

        /**
         * Sets the value of BurstLimit
         * @param value The maximum API request rate limit over a time ranging from one to a few seconds.
         * @return {@code this}
         */
        public Builder withBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._burstLimit = value;
            return this;
        }
        /**
         * Sets the value of RateLimit
         * @param value The API request steady-state rate limit (average requests per second over an extended period of time).
         * @return {@code this}
         */
        public Builder withRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._rateLimit = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottleSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ThrottleSettings build() {
            return new ThrottleSettings() {
                @javax.annotation.Nullable
                private final java.lang.Number $burstLimit = _burstLimit;
                @javax.annotation.Nullable
                private final java.lang.Number $rateLimit = _rateLimit;

                @Override
                public java.lang.Number getBurstLimit() {
                    return this.$burstLimit;
                }

                @Override
                public java.lang.Number getRateLimit() {
                    return this.$rateLimit;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("burstLimit", om.valueToTree(this.getBurstLimit()));
                    obj.set("rateLimit", om.valueToTree(this.getRateLimit()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ThrottleSettings {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The maximum API request rate limit over a time ranging from one to a few seconds.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getBurstLimit() {
            return this.jsiiGet("burstLimit", java.lang.Number.class);
        }

        /**
         * The API request steady-state rate limit (average requests per second over an extended period of time).
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRateLimit() {
            return this.jsiiGet("rateLimit", java.lang.Number.class);
        }
    }
}
