package software.amazon.awscdk.services.apigateway;

@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:06:14.466Z")
public interface UsagePlanProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ApiKey to be associated with the usage plan.
     * 
     * Default: none
     */
    software.amazon.awscdk.services.apigateway.IApiKey getApiKey();
    /**
     * API Stages to be associated which the usage plan.
     * 
     * Default: none
     */
    java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages();
    /**
     * Represents usage plan purpose.
     * 
     * Default: none
     */
    java.lang.String getDescription();
    /**
     * Name for this usage plan.
     * 
     * Default: none
     */
    java.lang.String getName();
    /**
     * Number of requests clients can make in a given time period.
     * 
     * Default: none
     */
    software.amazon.awscdk.services.apigateway.QuotaSettings getQuota();
    /**
     * Overall throttle settings for the API.
     * 
     * Default: none
     */
    software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle();

    /**
     * @return a {@link Builder} of {@link UsagePlanProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UsagePlanProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IApiKey _apiKey;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> _apiStages;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _name;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.QuotaSettings _quota;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ThrottleSettings _throttle;

        /**
         * Sets the value of ApiKey
         * @param value ApiKey to be associated with the usage plan.
         * @return {@code this}
         */
        public Builder withApiKey(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IApiKey value) {
            this._apiKey = value;
            return this;
        }
        /**
         * Sets the value of ApiStages
         * @param value API Stages to be associated which the usage plan.
         * @return {@code this}
         */
        public Builder withApiStages(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> value) {
            this._apiStages = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value Represents usage plan purpose.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Name
         * @param value Name for this usage plan.
         * @return {@code this}
         */
        public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
            this._name = value;
            return this;
        }
        /**
         * Sets the value of Quota
         * @param value Number of requests clients can make in a given time period.
         * @return {@code this}
         */
        public Builder withQuota(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.QuotaSettings value) {
            this._quota = value;
            return this;
        }
        /**
         * Sets the value of Throttle
         * @param value Overall throttle settings for the API.
         * @return {@code this}
         */
        public Builder withThrottle(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ThrottleSettings value) {
            this._throttle = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UsagePlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public UsagePlanProps build() {
            return new UsagePlanProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.IApiKey $apiKey = _apiKey;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> $apiStages = _apiStages;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.String $name = _name;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.QuotaSettings $quota = _quota;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.ThrottleSettings $throttle = _throttle;

                @Override
                public software.amazon.awscdk.services.apigateway.IApiKey getApiKey() {
                    return this.$apiKey;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
                    return this.$apiStages;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
                    return this.$quota;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
                    return this.$throttle;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("apiKey", om.valueToTree(this.getApiKey()));
                    obj.set("apiStages", om.valueToTree(this.getApiStages()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("name", om.valueToTree(this.getName()));
                    obj.set("quota", om.valueToTree(this.getQuota()));
                    obj.set("throttle", om.valueToTree(this.getThrottle()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.UsagePlanProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ApiKey to be associated with the usage plan.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IApiKey getApiKey() {
            return this.jsiiGet("apiKey", software.amazon.awscdk.services.apigateway.IApiKey.class);
        }

        /**
         * API Stages to be associated which the usage plan.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
            return this.jsiiGet("apiStages", java.util.List.class);
        }

        /**
         * Represents usage plan purpose.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Name for this usage plan.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * Number of requests clients can make in a given time period.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
            return this.jsiiGet("quota", software.amazon.awscdk.services.apigateway.QuotaSettings.class);
        }

        /**
         * Overall throttle settings for the API.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.jsiiGet("throttle", software.amazon.awscdk.services.apigateway.ThrottleSettings.class);
        }
    }
}
